/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageListNode
extends AbstractTreeNode<Object> {
    protected final CoverageSuitesBundle myBundle;
    protected final CoverageViewManager.StateBean myStateBean;
    private final FileStatusManager myFileStatusManager;
    private final VirtualFile myFile;
    private List<AbstractTreeNode<?>> myCachedChildren;

    @Deprecated
    public CoverageListNode(Project project2, @NotNull PsiNamedElement element, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean, boolean unused) {
        if (element == null) {
            CoverageListNode.$$$reportNull$$$0(0);
        }
        this(project2, element, bundle, stateBean);
    }

    public CoverageListNode(Project project2, @NotNull PsiNamedElement element, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        if (element == null) {
            CoverageListNode.$$$reportNull$$$0(1);
        }
        super(project2, (Object)element);
        this.myName = (String)ReadAction.compute(() -> element.getName());
        this.myBundle = bundle;
        this.myStateBean = stateBean;
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myFile = (VirtualFile)ReadAction.compute(() -> {
            VirtualFile canonical;
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file != null && (canonical = file.getCanonicalFile()) != null) {
                return canonical;
            }
            return file;
        });
    }

    @NotNull
    public synchronized List<? extends AbstractTreeNode<?>> getChildren() {
        if (this.myCachedChildren != null) {
            List<AbstractTreeNode<?>> list2 = this.myCachedChildren;
            if (list2 == null) {
                CoverageListNode.$$$reportNull$$$0(2);
            }
            return list2;
        }
        this.myCachedChildren = this.myBundle.getCoverageEngine().createCoverageViewExtension(this.myProject, this.myBundle, this.myStateBean).getChildrenNodes(this);
        if (this.myCachedChildren == null) {
            CoverageListNode.$$$reportNull$$$0(3);
        }
        return this.myCachedChildren;
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            CoverageListNode.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.getValue();
            if (object instanceof PsiNamedElement) {
                PsiNamedElement value2 = (PsiNamedElement)object;
                if (value2 instanceof PsiQualifiedNamedElement && (this.myStateBean.isFlattenPackages() && value2.getContainingFile() == null || this.getParent() instanceof CoverageListRootNode)) {
                    presentation2.setPresentableText(((PsiQualifiedNamedElement)value2).getQualifiedName());
                } else {
                    presentation2.setPresentableText(value2.getName());
                }
                presentation2.setIcon(value2.getIcon(0));
                presentation2.setForcedTextForeground(this.getFileStatus().getColor());
            }
        });
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public FileStatus getFileStatus() {
        VirtualFile virtualFile = this.myFile;
        return virtualFile != null ? this.myFileStatusManager.getStatus(virtualFile) : super.getFileStatus();
    }

    @Nullable
    protected Color computeBackgroundColor() {
        return null;
    }

    protected boolean shouldPostprocess() {
        return false;
    }

    public boolean canNavigate() {
        PsiElement element;
        Object value2 = this.getValue();
        return value2 instanceof PsiElement && (element = (PsiElement)value2).isValid() && element.getContainingFile() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            PsiNamedElement value2 = (PsiNamedElement)this.getValue();
            if (requestFocus) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)value2, (boolean)true);
            } else if (value2 instanceof NavigationItem) {
                NavigationItem navigationItem = (NavigationItem)value2;
                navigationItem.navigate(false);
            }
        }
    }

    public int getWeight() {
        return (Integer)ReadAction.compute(() -> {
            PsiElement element;
            Object value2 = this.getValue();
            if (value2 instanceof PsiElement && (element = (PsiElement)value2).getContainingFile() != null) {
                return 40;
            }
            return 30;
        });
    }

    public boolean contains(VirtualFile file) {
        PsiElement element;
        boolean equalContainingFile;
        Object value2 = this.getValue();
        if (value2 instanceof PsiElement && (equalContainingFile = Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)(element = (PsiElement)value2)), (Object)file))) {
            return true;
        }
        if (value2 instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)value2;
            return this.contains(file, directory);
        }
        if (value2 instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories;
            PsiDirectoryContainer container = (PsiDirectoryContainer)value2;
            for (PsiDirectory directory : directories = container.getDirectories()) {
                if (!this.contains(file, directory)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(VirtualFile file, PsiDirectory value2) {
        if (this.myStateBean.isFlattenPackages()) {
            return Comparing.equal((Object)value2.getVirtualFile(), (Object)file.getParent());
        }
        return VfsUtilCore.isAncestor((VirtualFile)value2.getVirtualFile(), (VirtualFile)file, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

