/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DvcsBranchUtil {
    @Nullable
    public static <T extends DvcsBranchInfo> T find(@Nullable Collection<T> branches, @Nullable Repository repository, @NotNull String sourceBranch2) {
        if (sourceBranch2 == null) {
            DvcsBranchUtil.$$$reportNull$$$0(0);
        }
        if (branches == null) {
            return null;
        }
        return (T)((DvcsBranchInfo)ContainerUtil.find(branches, targetInfo -> DvcsBranchUtil.repoAndSourceAreEqual(repository, sourceBranch2, targetInfo)));
    }

    private static boolean repoAndSourceAreEqual(@Nullable Repository repository, @NotNull String sourceBranch2, @NotNull DvcsBranchInfo targetInfo) {
        if (sourceBranch2 == null) {
            DvcsBranchUtil.$$$reportNull$$$0(1);
        }
        if (targetInfo == null) {
            DvcsBranchUtil.$$$reportNull$$$0(2);
        }
        return StringUtil.equals((CharSequence)targetInfo.sourceName, (CharSequence)sourceBranch2) && DvcsBranchUtil.getPathFor(repository).equals(targetInfo.repoPath);
    }

    @NotNull
    public static String getPathFor(@Nullable Repository repository) {
        String string2 = repository == null ? "" : repository.getRoot().getPath();
        if (string2 == null) {
            DvcsBranchUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static List<Change> swapRevisions(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            DvcsBranchUtil.$$$reportNull$$$0(4);
        }
        List list2 = ContainerUtil.map(changes, change -> {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision == null || afterRevision == null) {
                return new Change(afterRevision, beforeRevision);
            }
            return new Change(afterRevision, beforeRevision, change.getFileStatus());
        });
        if (list2 == null) {
            DvcsBranchUtil.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nls
    @NotNull
    public static String shortenBranchName(@Nls @NotNull String fullBranchName) {
        if (fullBranchName == null) {
            DvcsBranchUtil.$$$reportNull$$$0(6);
        }
        String string2 = StringUtil.shortenTextWithEllipsis((String)fullBranchName, (int)100, (int)5);
        if (string2 == null) {
            DvcsBranchUtil.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInfo";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "swapRevisions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "repoAndSourceAreEqual";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "swapRevisions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shortenBranchName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 7 -> new IllegalStateException(string2);
        };
    }
}

