/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.ByteContent;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryException;
import com.intellij.history.core.ByteContentRetriever;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeListStorageImpl;
import com.intellij.history.core.InMemoryChangeListStorage;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryActionImpl;
import com.intellij.history.integration.LocalHistoryEventDispatcher;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.LocalHistoryUtil;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.models.EntireFileHistoryDialogModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0001BB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0007J\b\u0010\"\u001a\u00020\u001eH\u0007J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u000f\u0010+\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020\u001eH\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020(H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J%\u00105\u001a\u0002022\u0006\u00106\u001a\u0002072\u000b\u00108\u001a\u000709\u00a2\u0006\u0002\b:2\u0006\u0010;\u001a\u00020\tH\u0016J\u001d\u0010<\u001a\u0002022\u0006\u00106\u001a\u0002072\u000b\u00108\u001a\u000709\u00a2\u0006\u0002\b:H\u0016J \u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u0002072\u0006\u00100\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0002J\u0017\u0010?\u001a\u00020@2\r\u00108\u001a\t\u0018\u000109\u00a2\u0006\u0002\b:H\u0016J\f\u0010A\u001a\u00020\u001e*\u00020\u0007H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/history/integration/LocalHistoryImpl;", "Lcom/intellij/history/LocalHistory;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "changeList", "Lcom/intellij/history/core/ChangeList;", "daysToKeep", "", "eventDispatcher", "Lcom/intellij/history/integration/LocalHistoryEventDispatcher;", "<set-?>", "Lcom/intellij/history/core/LocalHistoryFacade;", "facade", "getFacade", "()Lcom/intellij/history/core/LocalHistoryFacade;", "flusherTask", "Lkotlinx/coroutines/Job;", "Lcom/intellij/history/integration/IdeaGateway;", "gateway", "getGateway", "()Lcom/intellij/history/integration/IdeaGateway;", "initialFlush", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "isDisabled", "()Z", "isInitialized", "addVFSListenerAfterLocalHistoryOne", "", "virtualFileListener", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "disposable", "cleanupForNextTest", "dispose", "doDispose", "getByteContent", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "comparator", "Lcom/intellij/history/FileRevisionTimestampComparator;", "getEventDispatcher", "getEventDispatcher$intellij_platform_lvcs_impl", "init", "initHistory", "isUnderControl", "f", "label", "Lcom/intellij/history/Label;", "impl", "Lcom/intellij/history/core/LabelImpl;", "putSystemLabel", "p", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "color", "putUserLabel", "revertToLabel", "project", "startAction", "Lcom/intellij/history/LocalHistoryAction;", "purgeObsolete", "Companion", "intellij.platform.lvcs.impl"})
public final class LocalHistoryImpl
extends LocalHistory
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    private int daysToKeep;
    private boolean isDisabled;
    @Nullable
    private ChangeList changeList;
    @Nullable
    private LocalHistoryFacade facade;
    @Nullable
    private IdeaGateway gateway;
    @Nullable
    private Job flusherTask;
    @NotNull
    private final AtomicBoolean initialFlush;
    @Nullable
    private LocalHistoryEventDispatcher eventDispatcher;
    @NotNull
    private final AtomicBoolean isInitialized;
    @NotNull
    private static final String DAYS_TO_KEEP = "localHistory.daysToKeep";

    public LocalHistoryImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.daysToKeep = AdvancedSettings.Companion.getInt(DAYS_TO_KEEP);
        this.initialFlush = new AtomicBoolean(true);
        this.isInitialized = new AtomicBoolean();
        this.init();
    }

    public final boolean isDisabled() {
        return this.isDisabled;
    }

    @Nullable
    public final LocalHistoryFacade getFacade() {
        return this.facade;
    }

    @Nullable
    public final IdeaGateway getGateway() {
        return this.gateway;
    }

    @Nullable
    public final LocalHistoryEventDispatcher getEventDispatcher$intellij_platform_lvcs_impl() {
        return this.eventDispatcher;
    }

    private final void init() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isHeadlessEnvironment()) {
            return;
        }
        if (SystemProperties.getBooleanProperty((String)"lvcs.disable.local.history", (boolean)false)) {
            LocalHistoryLog.LOG.warn("Local history is disabled");
            this.isDisabled = true;
            return;
        }
        ShutDownTracker.getInstance().registerShutdownTask(() -> LocalHistoryImpl.init$lambda$0(this));
        this.initHistory();
        app.getMessageBus().simpleConnect().subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(this){
            final /* synthetic */ LocalHistoryImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)"localHistory.daysToKeep")) {
                    LocalHistoryImpl.access$setDaysToKeep$p(this.this$0, (Integer)newValue);
                }
            }
        });
        this.flusherTask = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LocalHistoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                        // 3 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if (LocalHistoryImpl.access$getChangeList$p(this.this$0) == null) ** GOTO lbl6
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, changeList, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ LocalHistoryImpl this$0;
                            final /* synthetic */ ChangeList $changeList;
                            {
                                this.this$0 = $receiver;
                                this.$changeList = $changeList;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                        if (LocalHistoryImpl.access$getInitialFlush$p(this.this$0).compareAndSet(true, false)) {
                                            LocalHistoryImpl.access$purgeObsolete(this.this$0, this.$changeList);
                                        }
                                        JobKt.ensureActive((CoroutineContext)$this$withContext.getCoroutineContext());
                                        this.$changeList.force();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.isInitialized.set(true);
    }

    private final void initHistory() {
        ChangeListStorage storage = null;
        try {
            storage = new ChangeListStorageImpl(Companion.getStorageDir());
        }
        catch (Throwable e) {
            LocalHistoryLog.LOG.warn("cannot create storage, in-memory  implementation will be used", e);
            storage = new InMemoryChangeListStorage();
        }
        this.changeList = new ChangeList(storage);
        this.facade = new LocalHistoryFacade(this.changeList);
        this.gateway = new IdeaGateway();
        this.eventDispatcher = new LocalHistoryEventDispatcher(this.facade, this.gateway);
    }

    public void dispose() {
        this.doDispose();
    }

    private final void doDispose() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        Job job2 = this.flusherTask;
        if (job2 != null) {
            Job it = job2;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
            this.flusherTask = null;
        }
        ChangeList changeList = this.changeList;
        if (changeList != null) {
            changeList.close();
        }
        LocalHistoryLog.LOG.debug("Local history storage successfully closed.");
    }

    private final void purgeObsolete(ChangeList $this$purgeObsolete) {
        long period = (long)this.daysToKeep * 1000L * 60L * 60L * 24L;
        LocalHistoryLog.LOG.debug("Purging local history...");
        $this$purgeObsolete.purgeObsolete(period);
    }

    @TestOnly
    public final void cleanupForNextTest() {
        this.doDispose();
        PathKt.delete$default((Path)Companion.getStorageDir(), (boolean)false, (int)1, null);
        this.init();
    }

    @NotNull
    public LocalHistoryAction startAction(@Nullable String name) {
        if (!this.isInitialized()) {
            LocalHistoryAction localHistoryAction = LocalHistoryAction.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)localHistoryAction, (String)"NULL");
            return localHistoryAction;
        }
        LocalHistoryActionImpl a = new LocalHistoryActionImpl(this.eventDispatcher, name);
        a.start();
        return a;
    }

    @NotNull
    public Label putUserLabel(@NotNull Project p, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.isInitialized()) {
            Label label2 = Label.NULL_INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"NULL_INSTANCE");
            return label2;
        }
        IdeaGateway ideaGateway = this.gateway;
        Intrinsics.checkNotNull((Object)ideaGateway);
        LocalHistoryFacade localHistoryFacade = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        ideaGateway.registerUnsavedDocuments(localHistoryFacade);
        LocalHistoryFacade localHistoryFacade2 = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade2);
        LabelImpl labelImpl = localHistoryFacade2.putUserLabel(name, LocalHistoryImpl.Companion.getProjectId(p));
        Intrinsics.checkNotNullExpressionValue((Object)labelImpl, (String)"putUserLabel(...)");
        return this.label(labelImpl);
    }

    @NotNull
    public Label putSystemLabel(@NotNull Project p, @NotNull String name, int color) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.isInitialized()) {
            Label label2 = Label.NULL_INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"NULL_INSTANCE");
            return label2;
        }
        IdeaGateway ideaGateway = this.gateway;
        Intrinsics.checkNotNull((Object)ideaGateway);
        LocalHistoryFacade localHistoryFacade = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        ideaGateway.registerUnsavedDocuments(localHistoryFacade);
        LocalHistoryFacade localHistoryFacade2 = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade2);
        LabelImpl labelImpl = localHistoryFacade2.putSystemLabel(name, LocalHistoryImpl.Companion.getProjectId(p), color);
        Intrinsics.checkNotNullExpressionValue((Object)labelImpl, (String)"putSystemLabel(...)");
        return this.label(labelImpl);
    }

    @ApiStatus.Internal
    public final void addVFSListenerAfterLocalHistoryOne(@NotNull BulkFileListener virtualFileListener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)virtualFileListener, (String)"virtualFileListener");
        LocalHistoryEventDispatcher localHistoryEventDispatcher = this.eventDispatcher;
        Intrinsics.checkNotNull((Object)localHistoryEventDispatcher);
        localHistoryEventDispatcher.addVirtualFileListener(virtualFileListener, disposable);
    }

    private final Label label(LabelImpl impl) {
        return new Label(this, impl){
            final /* synthetic */ LocalHistoryImpl this$0;
            final /* synthetic */ LabelImpl $impl;
            {
                this.this$0 = $receiver;
                this.$impl = $impl;
            }

            public void revert(@NotNull Project project2, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                LocalHistoryImpl.access$revertToLabel(this.this$0, project2, file, this.$impl);
            }

            @NotNull
            public ByteContent getByteContent(@NotNull String path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Object object = ApplicationManager.getApplication().runReadAction(() -> label.1.getByteContent$lambda$0(this.$impl, this.this$0, path2));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                return (ByteContent)object;
            }

            private static final ByteContent getByteContent$lambda$0(LabelImpl $impl, LocalHistoryImpl this$0, String $path) {
                Intrinsics.checkNotNullParameter((Object)$impl, (String)"$impl");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
                IdeaGateway ideaGateway = this$0.getGateway();
                Intrinsics.checkNotNull((Object)ideaGateway);
                return $impl.getByteContent(ideaGateway.createTransientRootEntryForPathOnly($path), $path);
            }
        };
    }

    @Nullable
    public byte[] getByteContent(@NotNull VirtualFile virtualFile, @NotNull FileRevisionTimestampComparator comparator2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
        if (!this.isInitialized()) {
            return null;
        }
        return (byte[])ApplicationManager.getApplication().runReadAction(() -> LocalHistoryImpl.getByteContent$lambda$2(this, virtualFile, comparator2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUnderControl(@NotNull VirtualFile f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (!this.isInitialized()) return false;
        IdeaGateway ideaGateway = this.gateway;
        Intrinsics.checkNotNull((Object)ideaGateway);
        if (!ideaGateway.isVersioned(f)) return false;
        return true;
    }

    private final boolean isInitialized() {
        return this.isInitialized.get();
    }

    private final void revertToLabel(Project project2, VirtualFile f, LabelImpl impl) throws LocalHistoryException {
        HistoryDialogModel dirHistoryModel = f.isDirectory() ? (HistoryDialogModel)new DirectoryHistoryDialogModel(project2, this.gateway, this.facade, f) : (HistoryDialogModel)new EntireFileHistoryDialogModel(project2, this.gateway, this.facade, f);
        int leftRev = LocalHistoryUtil.findRevisionIndexToRevert(dirHistoryModel, impl);
        if (leftRev < 0) {
            throw new LocalHistoryException("Couldn't find label revision");
        }
        if (leftRev == 0) {
            return;
        }
        try {
            dirHistoryModel.selectRevisions(-1, leftRev - 1);
            dirHistoryModel.createReverter().revert();
        }
        catch (Exception e) {
            throw new LocalHistoryException("Couldn't revert " + f.getName() + " to local history label.", (Throwable)e);
        }
    }

    private static final void init$lambda$0(LocalHistoryImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.doDispose();
    }

    private static final byte[] getByteContent$lambda$2(LocalHistoryImpl this$0, VirtualFile $virtualFile, FileRevisionTimestampComparator $comparator) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)$comparator, (String)"$comparator");
        IdeaGateway ideaGateway = this$0.gateway;
        Intrinsics.checkNotNull((Object)ideaGateway);
        return ideaGateway.areContentChangesVersioned($virtualFile) ? new ByteContentRetriever(this$0.gateway, this$0.facade, $virtualFile, $comparator).getResult() : null;
    }

    @JvmStatic
    @NotNull
    public static final LocalHistoryImpl getInstanceImpl() {
        return Companion.getInstanceImpl();
    }

    public static final /* synthetic */ void access$setDaysToKeep$p(LocalHistoryImpl $this, int n) {
        $this.daysToKeep = n;
    }

    public static final /* synthetic */ ChangeList access$getChangeList$p(LocalHistoryImpl $this) {
        return $this.changeList;
    }

    public static final /* synthetic */ AtomicBoolean access$getInitialFlush$p(LocalHistoryImpl $this) {
        return $this.initialFlush;
    }

    public static final /* synthetic */ void access$purgeObsolete(LocalHistoryImpl $this, ChangeList $receiver) {
        $this.purgeObsolete($receiver);
    }

    public static final /* synthetic */ void access$revertToLabel(LocalHistoryImpl $this, Project project2, VirtualFile f, LabelImpl impl) {
        $this.revertToLabel(project2, f, impl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/history/integration/LocalHistoryImpl$Companion;", "", "()V", "DAYS_TO_KEEP", "", "storageDir", "Ljava/nio/file/Path;", "getStorageDir", "()Ljava/nio/file/Path;", "getInstanceImpl", "Lcom/intellij/history/integration/LocalHistoryImpl;", "getProjectId", "p", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LocalHistoryImpl getInstanceImpl() {
            LocalHistory localHistory = LocalHistory.getInstance();
            Intrinsics.checkNotNull((Object)localHistory, (String)"null cannot be cast to non-null type com.intellij.history.integration.LocalHistoryImpl");
            return (LocalHistoryImpl)localHistory;
        }

        @NotNull
        public final Path getStorageDir() {
            String[] stringArray = new String[]{"LocalHistory"};
            Path path2 = Path.of(PathManager.getSystemPath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            return path2;
        }

        private final String getProjectId(Project p) {
            String string2 = p.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocationHash(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

