/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.savedPatches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesTree;
import com.intellij.openapi.vcs.changes.savedPatches.ShelfProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManagerListener;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003;<=B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u0010\u0012\f\u0012\n #*\u0004\u0018\u00010\u00020\u00020\"H\u0002J\b\u0010$\u001a\u00020\u001eH\u0016J4\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020+0*H\u0002J$\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'H\u0016J\b\u00100\u001a\u00020+H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0002J\b\u00102\u001a\u00020\u001eH\u0002J\u001e\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u00032\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001e06H\u0016J\"\u00107\u001a\u00020\u001e*\u00020 2\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0002R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006>"}, d2={"Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider;", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "applyAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getApplyAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "dataClass", "Ljava/lang/Class;", "getDataClass", "()Ljava/lang/Class;", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "popAction", "getPopAction", "shelveManager", "Lcom/intellij/openapi/vcs/changes/shelf/ShelveChangesManager;", "getShelveManager", "()Lcom/intellij/openapi/vcs/changes/shelf/ShelveChangesManager;", "tag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "getTag", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "buildPatchesTree", "", "modelBuilder", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "deletedLists", "", "kotlin.jvm.PlatformType", "dispose", "filterLists", "selectedObjects", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject;", "predicate", "Lkotlin/Function1;", "", "getData", "", "dataId", "", "isEmpty", "mainLists", "preloadChanges", "subscribeToPatchesListChanges", "disposable", "listener", "Lkotlin/Function0;", "insertShelves", "root", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesTree$TagWithCounterChangesBrowserNode;", "shelvesList", "MyShelvedWrapper", "ShelfObject", "ShelvedChangeListChangesBrowserNode", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nShelfProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShelfProvider.kt\ncom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n766#2:187\n857#2,2:188\n766#2:190\n857#2,2:191\n1054#2:193\n1054#2:194\n766#2:195\n857#2,2:196\n*S KotlinDebug\n*F\n+ 1 ShelfProvider.kt\ncom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider\n*L\n67#1:187\n67#1:188,2\n70#1:190\n70#1:191,2\n75#1:193\n80#1:194\n113#1:195\n113#1:196,2\n*E\n"})
public final class ShelfProvider
implements SavedPatchesProvider<ShelvedChangeList>,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final ChangesBrowserNode.Tag tag;

    public ShelfProvider(@NotNull Project project2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project2;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Shelved Changes Loader", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.tag = new ChangesBrowserNode.VcsBundleTag("shelf.root.node.title");
        Disposer.register((Disposable)parent, (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<ShelveChangesManagerListener> topic = ShelveChangesManager.SHELF_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"SHELF_TOPIC");
        messageBusConnection.subscribe(topic, () -> ShelfProvider._init_$lambda$0(this));
        this.preloadChanges();
    }

    private final ShelveChangesManager getShelveManager() {
        ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)shelveChangesManager, (String)"getInstance(...)");
        return shelveChangesManager;
    }

    @Override
    @NotNull
    public Class<ShelvedChangeList> getDataClass() {
        return ShelvedChangeList.class;
    }

    @Override
    @NotNull
    public ChangesBrowserNode.Tag getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public AnAction getApplyAction() {
        AnAction anAction = ActionManager.getInstance().getAction("Vcs.Shelf.Apply");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        return anAction;
    }

    @Override
    @NotNull
    public AnAction getPopAction() {
        AnAction anAction = ActionManager.getInstance().getAction("Vcs.Shelf.Pop");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        return anAction;
    }

    private final void preloadChanges() {
        BackgroundTaskUtil.submitTask((Executor)this.executor, (Disposable)this, () -> ShelfProvider.preloadChanges$lambda$1(this));
    }

    @Override
    public void subscribeToPatchesListChanges(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        CheckedDisposable disposableFlag = checkedDisposable;
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)disposableFlag));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(disposable);
        Topic<ShelveChangesManagerListener> topic = ShelveChangesManager.SHELF_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"SHELF_TOPIC");
        messageBusConnection.subscribe(topic, () -> ShelfProvider.subscribeToPatchesListChanges$lambda$4(listener2, disposableFlag));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ShelvedChangeList> mainLists() {
        void $this$filterTo$iv$iv;
        List<ShelvedChangeList> list2 = this.getShelveManager().getAllLists();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllLists(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShelvedChangeList l = (ShelvedChangeList)element$iv$iv;
            boolean bl = false;
            if (!(!l.isDeleted() && !l.isRecycled())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ShelvedChangeList> deletedLists() {
        void $this$filterTo$iv$iv;
        List<ShelvedChangeList> list2 = this.getShelveManager().getAllLists();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllLists(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShelvedChangeList l = (ShelvedChangeList)element$iv$iv;
            boolean bl = false;
            if (!l.isDeleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isEmpty() {
        return this.mainLists().isEmpty() && this.deletedLists().isEmpty();
    }

    @Override
    public void buildPatchesTree(@NotNull TreeModelBuilder modelBuilder) {
        Intrinsics.checkNotNullParameter((Object)modelBuilder, (String)"modelBuilder");
        Iterable $this$sortedByDescending$iv = this.mainLists();
        boolean $i$f$sortedByDescending = false;
        List shelvesList = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ShelvedChangeList it = (ShelvedChangeList)b;
                boolean bl = false;
                it = (ShelvedChangeList)a;
                Comparable comparable = it.DATE;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)it.DATE);
            }
        });
        SavedPatchesTree.TagWithCounterChangesBrowserNode shelvesRoot = new SavedPatchesTree.TagWithCounterChangesBrowserNode(this.getTag(), false, null, 6, null);
        modelBuilder.insertSubtreeRoot((ChangesBrowserNode)shelvesRoot);
        this.insertShelves(modelBuilder, shelvesRoot, shelvesList);
        Iterable $this$sortedByDescending$iv2 = this.deletedLists();
        boolean $i$f$sortedByDescending2 = false;
        List deletedShelvesList = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ShelvedChangeList it = (ShelvedChangeList)b;
                boolean bl = false;
                it = (ShelvedChangeList)a;
                Comparable comparable = it.DATE;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)it.DATE);
            }
        });
        if (!((Collection)deletedShelvesList).isEmpty()) {
            String string2 = VcsBundle.message("shelve.recently.deleted.node", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            SavedPatchesTree.TagWithCounterChangesBrowserNode deletedShelvesRoot = new SavedPatchesTree.TagWithCounterChangesBrowserNode(string2, false, (Integer)20);
            modelBuilder.insertSubtreeRoot(deletedShelvesRoot, shelvesRoot);
            this.insertShelves(modelBuilder, deletedShelvesRoot, deletedShelvesList);
        }
    }

    private final void insertShelves(TreeModelBuilder $this$insertShelves, SavedPatchesTree.TagWithCounterChangesBrowserNode root, List<ShelvedChangeList> shelvesList) {
        for (ShelvedChangeList shelve : shelvesList) {
            $this$insertShelves.insertSubtreeRoot(new ShelvedChangeListChangesBrowserNode(new ShelfObject(shelve)), root);
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId, @NotNull Stream<SavedPatchesProvider.PatchObject<?>> selectedObjects) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter(selectedObjects, (String)"selectedObjects");
        if (ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY.is(dataId)) {
            return this.filterLists(selectedObjects, (Function1<? super ShelvedChangeList, Boolean>)((Function1)getData.1.INSTANCE));
        }
        if (ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY.is(dataId)) {
            return this.filterLists(selectedObjects, (Function1<? super ShelvedChangeList, Boolean>)((Function1)getData.2.INSTANCE));
        }
        if (ShelvedChangesViewManager.SHELVED_DELETED_CHANGELIST_KEY.is(dataId)) {
            return this.filterLists(selectedObjects, (Function1<? super ShelvedChangeList, Boolean>)((Function1)getData.3.INSTANCE));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ShelvedChangeList> filterLists(Stream<SavedPatchesProvider.PatchObject<?>> selectedObjects, Function1<? super ShelvedChangeList, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        StreamEx streamEx = StreamEx.of(selectedObjects.map(arg_0 -> ShelfProvider.filterLists$lambda$9((Function1)filterLists.1.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"of(...)");
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)((Iterable)streamEx), this.getDataClass());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.MILLISECONDS);
    }

    private static final void _init_$lambda$0(ShelfProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.preloadChanges();
    }

    private static final void preloadChanges$lambda$1(ShelfProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (ShelvedChangeList list2 : this$0.getShelveManager().getAllLists()) {
            ProgressManager.checkCanceled();
            list2.loadChangesIfNeeded(this$0.project);
        }
    }

    private static final void subscribeToPatchesListChanges$lambda$4$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final boolean subscribeToPatchesListChanges$lambda$4$lambda$3(CheckedDisposable $disposableFlag, Object it) {
        Intrinsics.checkNotNullParameter((Object)$disposableFlag, (String)"$disposableFlag");
        return $disposableFlag.isDisposed();
    }

    private static final void subscribeToPatchesListChanges$lambda$4(Function0 $listener, CheckedDisposable $disposableFlag) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$disposableFlag, (String)"$disposableFlag");
        if (ApplicationManager.getApplication().isDispatchThread()) {
            $listener.invoke();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> ShelfProvider.subscribeToPatchesListChanges$lambda$4$lambda$2($listener), arg_0 -> ShelfProvider.subscribeToPatchesListChanges$lambda$4$lambda$3($disposableFlag, arg_0));
        }
    }

    private static final Object filterLists$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$MyShelvedWrapper;", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedWrapper;", "shelvedChange", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChange;", "binaryFile", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile;", "changeList", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "(Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChange;Lcom/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile;Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;)V", "getTag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "intellij.platform.vcs.impl"})
    private static final class MyShelvedWrapper
    extends ShelvedWrapper {
        public MyShelvedWrapper(@Nullable ShelvedChange shelvedChange, @Nullable ShelvedBinaryFile binaryFile, @NotNull ShelvedChangeList changeList) {
            Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
            super(shelvedChange, binaryFile, changeList);
        }

        @Override
        @Nullable
        public ChangesBrowserNode.Tag getTag() {
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\u0014\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0011*\u00020\u0002H\u0002R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$ShelfObject;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject;", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "data", "(Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider;Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;)V", "getData", "()Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "cachedChanges", "", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$ChangeObject;", "getDiffPreviewTitle", "", "changeName", "loadChanges", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$LoadingResult;", "getChangeObjects", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nShelfProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShelfProvider.kt\ncom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$ShelfObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1549#2:187\n1620#2,3:188\n1549#2:191\n1620#2,3:192\n*S KotlinDebug\n*F\n+ 1 ShelfProvider.kt\ncom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$ShelfObject\n*L\n170#1:187\n170#1:188,3\n171#1:191\n171#1:192,3\n*E\n"})
    public final class ShelfObject
    implements SavedPatchesProvider.PatchObject<ShelvedChangeList> {
        @NotNull
        private final ShelvedChangeList data;

        public ShelfObject(ShelvedChangeList data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.data = data2;
        }

        @Override
        @NotNull
        public ShelvedChangeList getData() {
            return this.data;
        }

        @Override
        @Nullable
        public Collection<SavedPatchesProvider.ChangeObject> cachedChanges() {
            return this.getChangeObjects(this.getData());
        }

        @Override
        @Nullable
        public CompletableFuture<SavedPatchesProvider.LoadingResult> loadChanges() {
            Set<SavedPatchesProvider.ChangeObject> cachedChangeObjects = this.getChangeObjects(this.getData());
            if (cachedChangeObjects != null) {
                return CompletableFuture.completedFuture(new SavedPatchesProvider.LoadingResult.Changes((Collection<? extends SavedPatchesProvider.ChangeObject>)cachedChangeObjects));
            }
            return BackgroundTaskUtil.submitTask((Executor)ShelfProvider.this.executor, (Disposable)ShelfProvider.this, () -> ShelfObject.loadChanges$lambda$0(this, ShelfProvider.this)).getFuture();
        }

        private final Set<SavedPatchesProvider.ChangeObject> getChangeObjects(ShelvedChangeList $this$getChangeObjects) {
            ShelvedBinaryFile it;
            Iterable<MyShelvedWrapper> iterable;
            Iterable $this$mapTo$iv$iv;
            List<ShelvedChange> list2 = $this$getChangeObjects.getChanges();
            if (list2 == null) {
                return null;
            }
            List<ShelvedChange> cachedChanges = list2;
            Iterable $this$map$iv = cachedChanges;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ShelvedChange shelvedChange = (ShelvedChange)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl = false;
                iterable.add(new MyShelvedWrapper((ShelvedChange)((Object)it), null, $this$getChangeObjects));
            }
            Iterable iterable3 = (List)destination$iv$iv;
            List<ShelvedBinaryFile> list3 = $this$getChangeObjects.getBinaryFiles();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getBinaryFiles(...)");
            $this$map$iv = list3;
            iterable = iterable3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ShelvedBinaryFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new MyShelvedWrapper(null, it, $this$getChangeObjects));
            }
            return CollectionsKt.union(iterable, (Iterable)((List)destination$iv$iv));
        }

        @Override
        @NotNull
        public String getDiffPreviewTitle(@Nullable String changeName) {
            String string2;
            String string3;
            String string4 = changeName;
            if (string4 != null) {
                String name = string4;
                boolean bl = false;
                Object[] objectArray = new Object[]{name};
                v1 = VcsBundle.message("shelve.editor.diff.preview.title", objectArray);
            } else {
                v1 = string3 = null;
            }
            if (string3 == null) {
                String string5 = VcsBundle.message("shelved.version.name", new Object[0]);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            } else {
                string2 = string3;
            }
            return string2;
        }

        private static final SavedPatchesProvider.LoadingResult loadChanges$lambda$0(ShelfObject this$0, ShelfProvider this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            try {
                this$0.getData().loadChangesIfNeeded(this$1.project);
                String changesLoadingError = this$0.getData().getChangesLoadingError();
                if (changesLoadingError != null) {
                    return new SavedPatchesProvider.LoadingResult.Error(changesLoadingError);
                }
                Set<SavedPatchesProvider.ChangeObject> set = this$0.getChangeObjects(this$0.getData());
                Intrinsics.checkNotNull(set);
                return new SavedPatchesProvider.LoadingResult.Changes((Collection<? extends SavedPatchesProvider.ChangeObject>)set);
            }
            catch (Throwable throwable) {
                return new SavedPatchesProvider.LoadingResult.Error(throwable);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0011\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0012\u0010\u0004\u001a\u00060\u0002R\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$ShelvedChangeListChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$ShelfObject;", "Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider;", "shelf", "(Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$ShelfObject;)V", "getTextPresentation", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nShelfProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShelfProvider.kt\ncom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider$ShelvedChangeListChangesBrowserNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
    public static final class ShelvedChangeListChangesBrowserNode
    extends ChangesBrowserNode<ShelfObject> {
        @NotNull
        private final ShelfObject shelf;

        public ShelvedChangeListChangesBrowserNode(@NotNull ShelfObject shelf) {
            Intrinsics.checkNotNullParameter((Object)shelf, (String)"shelf");
            super(shelf);
            this.shelf = shelf;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)((Object)renderer2), (String)"renderer");
            CharSequence charSequence2 = this.shelf.getData().DESCRIPTION;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = VcsBundle.message("changes.nodetitle.empty.changelist.name", new Object[0]);
            } else {
                charSequence = charSequence2;
            }
            String listName = (String)charSequence;
            SimpleTextAttributes attributes = this.shelf.getData().isRecycled() || this.shelf.getData().isDeleted() ? SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            renderer2.appendTextWithIssueLinks(listName, attributes);
            Object[] objectArray = new Object[]{VcsBundle.message("shelf.tooltip.title", new Object[0]), DateFormatUtil.formatDate((Date)this.shelf.getData().DATE), DateFormatUtil.formatTime((Date)this.shelf.getData().DATE)};
            renderer2.setToolTipText(VcsBundle.message("saved.patch.created.on.date.at.time.tooltip", objectArray));
        }

        @Override
        @NotNull
        public String getTextPresentation() {
            String string2 = this.shelf.getData().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
    }
}

