/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditChangelistDialog
extends DialogWrapper {
    private final NewEditChangelistPanel myPanel;
    private final Project myProject;
    @NotNull
    private final LocalChangeList myList;

    public EditChangelistDialog(Project project2, @NotNull LocalChangeList list2) {
        if (list2 == null) {
            EditChangelistDialog.$$$reportNull$$$0(0);
        }
        super(project2, true);
        this.myProject = project2;
        this.myList = list2;
        this.myPanel = new NewEditChangelistPanel(project2){

            @Override
            protected void nameChanged(@Nullable @Nls String errorMessage) {
                EditChangelistDialog.this.setOKActionEnabled(errorMessage == null);
                EditChangelistDialog.this.setErrorText(errorMessage, (JComponent)((Object)EditChangelistDialog.this.myPanel));
            }
        };
        this.myPanel.setChangeListName(list2.getName());
        this.myPanel.setDescription(list2.getComment());
        this.myPanel.init(list2);
        this.myPanel.getMakeActiveCheckBox().setSelected(this.myList.isDefault());
        this.myPanel.getMakeActiveCheckBox().setEnabled(!this.myList.isDefault());
        this.setTitle(VcsBundle.message("changes.dialog.editchangelist.title", new Object[0]));
        this.setSize(JBUI.scale((int)500), JBUI.scale((int)230));
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getContent();
    }

    protected void doOKAction() {
        String newName;
        String oldName = this.myList.getName();
        String oldComment = this.myList.getComment();
        if (!Objects.equals(oldName, this.myPanel.getChangeListName()) && ChangeListManager.getInstance(this.myProject).findChangeList(this.myPanel.getChangeListName()) != null) {
            Messages.showErrorDialog((Component)this.myPanel.getContent(), (String)VcsBundle.message("changes.dialog.editchangelist.error.already.exists", this.myPanel.getChangeListName()), (String)VcsBundle.message("changes.dialog.editchangelist.title", new Object[0]));
            return;
        }
        ChangeListManager clManager = ChangeListManager.getInstance(this.myProject);
        String newDescription = this.myPanel.getDescription();
        if (!StringUtil.equals((CharSequence)oldComment, (CharSequence)newDescription)) {
            clManager.editComment(oldName, newDescription);
        }
        if (!StringUtil.equals((CharSequence)oldName, (CharSequence)(newName = this.myPanel.getChangeListName()))) {
            clManager.editName(oldName, newName);
        }
        if (!this.myList.isDefault() && this.myPanel.getMakeActiveCheckBox().isSelected()) {
            clManager.setDefaultChangeList(newName);
        }
        this.myPanel.changelistCreatedOrChanged(this.myList);
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "VCS.EditChangelistDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/EditChangelistDialog", "<init>"));
    }
}

