/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BoundCompositeSearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.CommitOptionsPanel;
import com.intellij.vcs.commit.CommitWorkflowHandler;
import com.intellij.vcs.commit.NullCommitWorkflowHandler;
import com.intellij.vcs.commit.message.CommitMessageInspectionsPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\n\u000bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/configurable/CommitDialogConfigurable;", "Lcom/intellij/openapi/options/BoundCompositeSearchableConfigurable;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createConfigurables", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "Companion", "SettingsMockCheckinPanel", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitDialogConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitDialogConfigurable.kt\ncom/intellij/openapi/vcs/configurable/CommitDialogConfigurable\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n115#2:106\n116#2,6:117\n1603#3,9:107\n1855#3:116\n1856#3:124\n1612#3:125\n1#4:123\n10#5:126\n*S KotlinDebug\n*F\n+ 1 CommitDialogConfigurable.kt\ncom/intellij/openapi/vcs/configurable/CommitDialogConfigurable\n*L\n33#1:106\n33#1:117,6\n33#1:107,9\n33#1:116\n33#1:124\n33#1:125\n33#1:123\n99#1:126\n*E\n"})
public final class CommitDialogConfigurable
extends BoundCompositeSearchableConfigurable<UnnamedConfigurable> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String ID = "project.propVCSSupport.CommitDialog";
    @NotNull
    private static final String HELP_ID = "reference.settings.VCS.CommitDialog";

    public CommitDialogConfigurable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string2 = VcsBundle.message("commit.dialog.configurable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(string2, HELP_ID, ID);
        this.project = project2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UnnamedConfigurable> createConfigurables() {
        void $this$mapNotNullTo$iv$iv$iv;
        void $this$mapNotNullLoggingErrors$iv;
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance(this.project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        List allVcses = ArraysKt.toList((Object[])abstractVcsArray);
        SettingsMockCheckinPanel checkinPanel = new SettingsMockCheckinPanel(this.project);
        CommitContext commitContext = new CommitContext();
        List<CheckinHandler> checkinHandlers = AbstractCommitWorkflow.Companion.getCommitHandlers(allVcses, checkinPanel, commitContext);
        Collection collection = checkinHandlers;
        Logger logger$iv = LOG;
        boolean $i$f$mapNotNullLoggingErrors = false;
        Iterable $this$mapNotNull$iv$iv = (Iterable)$this$mapNotNullLoggingErrors$iv;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnnamedConfigurable it$iv$iv$iv;
            UnnamedConfigurable unnamedConfigurable;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it$iv = element$iv$iv$iv;
            boolean bl2 = false;
            try {
                CheckinHandler it = (CheckinHandler)it$iv;
                boolean bl3 = false;
                unnamedConfigurable = it.getBeforeCheckinSettings();
            }
            catch (Throwable e$iv) {
                logger$iv.error(e$iv);
                unnamedConfigurable = null;
            }
            if (unnamedConfigurable == null) continue;
            boolean bl4 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    @NotNull
    public DialogPanel createPanel() {
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        Disposable disposable2 = disposable;
        VcsApplicationSettings appSettings = VcsApplicationSettings.getInstance();
        VcsConfiguration settings = VcsConfiguration.getInstance(this.project);
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, appSettings, settings, disposable2){
            final /* synthetic */ CommitDialogConfigurable this$0;
            final /* synthetic */ VcsApplicationSettings $appSettings;
            final /* synthetic */ VcsConfiguration $settings;
            final /* synthetic */ Disposable $disposable;
            {
                this.this$0 = $receiver;
                this.$appSettings = $appSettings;
                this.$settings = $settings;
                this.$disposable = $disposable;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$appSettings, this.this$0){
                    final /* synthetic */ VcsApplicationSettings $appSettings;
                    final /* synthetic */ CommitDialogConfigurable this$0;
                    {
                        this.$appSettings = $appSettings;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string2 = VcsBundle.message("settings.commit.without.dialog", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(string2), (String)VcsBundle.message("settings.commit.without.dialog.applies.to.git.mercurial", new Object[0]), (int)0, null, (int)6, null), (Function0)((Function0)new Function0<Boolean>(this.$appSettings){
                            final /* synthetic */ VcsApplicationSettings $appSettings;
                            {
                                this.$appSettings = $appSettings;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return this.$appSettings.COMMIT_FROM_LOCAL_CHANGES;
                            }
                        }), (Function1)((Function1)new Function1<Boolean, Unit>(this.this$0){
                            final /* synthetic */ CommitDialogConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                CommitModeManager.Companion.setCommitFromLocalChanges(CommitDialogConfigurable.access$getProject$p(this.this$0), it);
                            }
                        }));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$settings){
                    final /* synthetic */ VcsConfiguration $settings;
                    {
                        this.$settings = $settings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string2 = VcsBundle.message("checkbox.clear.initial.commit.message", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        Cell cell = $this$row.checkBox(string2);
                        VcsConfiguration vcsConfiguration = this.$settings;
                        Intrinsics.checkNotNullExpressionValue((Object)vcsConfiguration, (String)"$settings");
                        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(vcsConfiguration){

                            @Nullable
                            public Object get() {
                                return ((VcsConfiguration)this.receiver).CLEAR_INITIAL_COMMIT_MESSAGE;
                            }

                            public void set(@Nullable Object value2) {
                                ((VcsConfiguration)this.receiver).CLEAR_INITIAL_COMMIT_MESSAGE = (Boolean)value2;
                            }
                        }));
                    }
                }), (int)1, null);
                Panel.group$default((Panel)$this$panel, (String)VcsBundle.message("settings.commit.message.inspections", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0, this.$disposable){
                    final /* synthetic */ CommitDialogConfigurable this$0;
                    final /* synthetic */ Disposable $disposable;
                    {
                        this.this$0 = $receiver;
                        this.$disposable = $disposable;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, this.$disposable){
                            final /* synthetic */ CommitDialogConfigurable this$0;
                            final /* synthetic */ Disposable $disposable;
                            {
                                this.this$0 = $receiver;
                                this.$disposable = $disposable;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                CommitMessageInspectionsPanel panel2 = new CommitMessageInspectionsPanel(CommitDialogConfigurable.access$getProject$p(this.this$0));
                                Disposer.register((Disposable)this.$disposable, (Disposable)panel2);
                                $this$row.cell((JComponent)((Object)panel2)).align((Align)AlignX.FILL.INSTANCE).onApply((Function0)new Function0<Unit>(panel2){
                                    final /* synthetic */ CommitMessageInspectionsPanel $panel;
                                    {
                                        this.$panel = $panel;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.$panel.apply();
                                    }
                                }).onReset((Function0)new Function0<Unit>(panel2){
                                    final /* synthetic */ CommitMessageInspectionsPanel $panel;
                                    {
                                        this.$panel = $panel;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.$panel.reset();
                                    }
                                }).onIsModified((Function0)new Function0<Boolean>(panel2){
                                    final /* synthetic */ CommitMessageInspectionsPanel $panel;
                                    {
                                        this.$panel = $panel;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Boolean invoke() {
                                        return this.$panel.isModified();
                                    }
                                });
                            }
                        }), (int)1, null).resizableRow();
                    }
                }), (int)2, null);
                if (!((Collection)this.this$0.getConfigurables()).isEmpty()) {
                    String string2 = UIUtil.removeMnemonic((String)AbstractCommitWorkflowHandler.Companion.getDefaultCommitActionName(CollectionsKt.emptyList()));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"removeMnemonic(...)");
                    String actionName = string2;
                    Panel.group$default((Panel)$this$panel, (String)CommitOptionsPanel.Companion.commitChecksGroupTitle(CommitDialogConfigurable.access$getProject$p(this.this$0), actionName), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                        final /* synthetic */ CommitDialogConfigurable this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Panel $this$group) {
                            Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                            for (UnnamedConfigurable configurable : this.this$0.getConfigurables()) {
                                CommitDialogConfigurable.access$appendDslConfigurable(this.this$0, $this$group, configurable);
                            }
                        }
                    }), (int)2, null);
                }
            }
        }));
    }

    public static final /* synthetic */ Project access$getProject$p(CommitDialogConfigurable $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$appendDslConfigurable(CommitDialogConfigurable $this, Panel $receiver, UnnamedConfigurable configurable) {
        $this.appendDslConfigurable($receiver, configurable);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommitDialogConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/configurable/CommitDialogConfigurable$Companion;", "", "()V", "HELP_ID", "", "Lorg/jetbrains/annotations/NonNls;", "ID", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/vcs/configurable/CommitDialogConfigurable$SettingsMockCheckinPanel;", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getCommitActionName", "", "getCommitMessage", "getCommitWorkflowHandler", "Lcom/intellij/vcs/commit/CommitWorkflowHandler;", "getComponent", "", "getFiles", "", "Ljava/io/File;", "getPreferredFocusedComponent", "getProject", "getRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSelectedChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "getVirtualFiles", "hasDiffs", "", "restoreState", "", "saveState", "setCommitMessage", "currentDescription", "vcsIsAffected", "name", "intellij.platform.vcs.impl"})
    private static final class SettingsMockCheckinPanel
    implements CheckinProjectPanel {
        @NotNull
        private final Project project;

        public SettingsMockCheckinPanel(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        @Nullable
        public Void getComponent() {
            return null;
        }

        @Nullable
        public Void getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @NotNull
        public CommitWorkflowHandler getCommitWorkflowHandler() {
            return NullCommitWorkflowHandler.INSTANCE;
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @Override
        public boolean vcsIsAffected(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return false;
        }

        @Override
        public boolean hasDiffs() {
            return false;
        }

        @NotNull
        public List<VirtualFile> getRoots() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<VirtualFile> getVirtualFiles() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<Change> getSelectedChanges() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<File> getFiles() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public String getCommitActionName() {
            return AbstractCommitWorkflowHandler.Companion.getDefaultCommitActionName(CollectionsKt.emptyList());
        }

        @Override
        public void setCommitMessage(@NotNull String currentDescription) {
            Intrinsics.checkNotNullParameter((Object)currentDescription, (String)"currentDescription");
        }

        @Override
        @NotNull
        public String getCommitMessage() {
            return "";
        }

        @Override
        public void saveState() {
        }

        @Override
        public void restoreState() {
        }
    }
}

