/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.serialization.ClassUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.ComboTableCellEditor;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.TextControl;
import java.awt.Component;
import java.lang.reflect.Type;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomUIFactoryImpl
extends DomUIFactory {
    private final ClassMap<Function<DomWrapper<String>, BaseControl>> myCustomControlCreators = new ClassMap();
    private final ClassMap<Function<DomElement, TableCellEditor>> myCustomCellEditorCreators = new ClassMap();

    public DomUIFactoryImpl() {
        Function booleanCreator = domElement -> new BooleanTableCellEditor();
        this.registerCustomCellEditor(Boolean.class, (Function<DomElement, TableCellEditor>)booleanCreator);
        this.registerCustomCellEditor(Boolean.TYPE, (Function<DomElement, TableCellEditor>)booleanCreator);
        this.registerCustomCellEditor(String.class, (Function<DomElement, TableCellEditor>)((Function)domElement -> new DefaultCellEditor(DomUIFactoryImpl.removeBorder(new JTextField()))));
        for (Consumer extension : EXTENSION_POINT_NAME.getExtensionList()) {
            extension.consume((Object)this);
        }
    }

    @Override
    protected TableCellEditor createCellEditor(DomElement element, Class type2) {
        if (Enum.class.isAssignableFrom(type2)) {
            return new ComboTableCellEditor(type2, false);
        }
        Function function = (Function)this.myCustomCellEditorCreators.get(type2);
        assert (function != null) : "Type not supported: " + type2;
        return (TableCellEditor)function.fun((Object)element);
    }

    @Override
    @NotNull
    public final UserActivityWatcher createEditorAwareUserActivityWatcher() {
        return new UserActivityWatcher(){
            private final DocumentListener myListener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.fireUIChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/xml/ui/DomUIFactoryImpl$1$1", "documentChanged"));
                }
            };

            protected void processComponent(Component component2) {
                super.processComponent(component2);
                if (component2 instanceof EditorComponentImpl) {
                    ((EditorComponentImpl)component2).getEditor().getDocument().addDocumentListener(this.myListener);
                }
            }

            protected void unprocessComponent(Component component2) {
                super.unprocessComponent(component2);
                if (component2 instanceof EditorComponentImpl) {
                    ((EditorComponentImpl)component2).getEditor().getDocument().removeDocumentListener(this.myListener);
                }
            }
        };
    }

    @Override
    public void setupErrorOutdatingUserActivityWatcher(final CommittablePanel panel2, final DomElement ... elements) {
        UserActivityWatcher userActivityWatcher = this.createEditorAwareUserActivityWatcher();
        userActivityWatcher.addUserActivityListener(new UserActivityListener(){
            private boolean isProcessingChange;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged() {
                if (this.isProcessingChange) {
                    return;
                }
                this.isProcessingChange = true;
                try {
                    for (DomElement element : elements) {
                        ((DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance(element.getManager().getProject())).outdateProblemHolder(element);
                    }
                    CommittableUtil.updateHighlighting(panel2);
                }
                finally {
                    this.isProcessingChange = false;
                }
            }
        }, (Disposable)panel2);
        userActivityWatcher.register((Component)panel2.getComponent());
    }

    @Override
    @Nullable
    public BaseControl createCustomControl(Type type2, DomWrapper<String> wrapper, boolean commitOnEveryChange) {
        Function factory = (Function)this.myCustomControlCreators.get(ClassUtil.getRawType((Type)type2));
        return factory == null ? null : (BaseControl)factory.fun(wrapper);
    }

    @Override
    public BackgroundEditorHighlighter createDomHighlighter(Project project2, PerspectiveFileEditor editor, DomElement element) {
        return () -> {
            if (!element.isValid()) {
                return HighlightingPass.EMPTY_ARRAY;
            }
            XmlFile psiFile2 = DomUtil.getFile(element);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            Document document2 = psiDocumentManager.getDocument((PsiFile)psiFile2);
            if (document2 == null) {
                return HighlightingPass.EMPTY_ARRAY;
            }
            editor.commit();
            return TextEditorHighlightingPassRegistrarEx.getInstanceEx((Project)project2).instantiateMainPasses((PsiFile)psiFile2, document2, (HighlightInfoProcessor)new DefaultHighlightInfoProcessor()).toArray(HighlightingPass.EMPTY_ARRAY);
        };
    }

    @Override
    public BaseControl createTextControl(DomWrapper<String> wrapper, boolean commitOnEveryChange) {
        return new TextControl(wrapper, commitOnEveryChange);
    }

    @Override
    public void registerCustomControl(@NotNull Class aClass, Function<DomWrapper<String>, BaseControl> creator) {
        if (aClass == null) {
            DomUIFactoryImpl.$$$reportNull$$$0(0);
        }
        this.myCustomControlCreators.put(aClass, creator);
    }

    @Override
    public void registerCustomCellEditor(@NotNull Class aClass, Function<DomElement, TableCellEditor> creator) {
        if (aClass == null) {
            DomUIFactoryImpl.$$$reportNull$$$0(1);
        }
        this.myCustomCellEditorCreators.put(aClass, creator);
    }

    private static <T extends JComponent> T removeBorder(T component2) {
        component2.setBorder((Border)JBUI.Borders.empty());
        return component2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "aClass";
        objectArray2[1] = "com/intellij/util/xml/ui/DomUIFactoryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCustomControl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCustomCellEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

