/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StripeTableCellRenderer
implements TableCellRenderer {
    private final TableCellRenderer myRenderer;
    private static final double FACTOR = 0.92;

    public StripeTableCellRenderer(TableCellRenderer renderer2) {
        this.myRenderer = renderer2;
    }

    public StripeTableCellRenderer() {
        this(null);
    }

    public static Color darken(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.92), 0), Math.max((int)((double)color.getGreen() * 0.92), 0), Math.max((int)((double)color.getBlue() * 0.92), 0));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column) {
        JComponent component2 = (JComponent)this.getRenderer(row2, column).getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column);
        if (row2 % 2 != 0 && !isSelected) {
            component2.setBackground(StripeTableCellRenderer.darken(table.getBackground()));
        } else {
            component2.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        }
        component2.setOpaque(true);
        return component2;
    }

    protected TableCellRenderer getRenderer(int row2, int column) {
        return this.myRenderer;
    }
}

