/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.browser.LoadingChangesPanel;
import com.intellij.openapi.vcs.history.actions.GetVersionAction;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ChangesBrowserToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompareWithLocalDialog {
    @RequiresEdt
    public static void showChanges(@NotNull Project project2, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull LocalContent localContent, @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project2 == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(0);
        }
        if (dialogTitle == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(1);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(2);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (localContent != LocalContent.NONE) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        if (AbstractVcsHelperImpl.showCommittedChangesAsTab()) {
            CompareWithLocalDialog.showAsTab(project2, dialogTitle, localContent, changesLoader);
        } else {
            CompareWithLocalDialog.showDialog(project2, dialogTitle, localContent, changesLoader);
        }
    }

    private static void showDialog(@NotNull Project project2, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull LocalContent localContent, @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project2 == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(4);
        }
        if (dialogTitle == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(5);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(6);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(7);
        }
        MyLoadingChangesPanel changesPanel = CompareWithLocalDialog.createPanel(project2, localContent, changesLoader);
        DialogBuilder dialogBuilder = new DialogBuilder(project2);
        dialogBuilder.setTitle(dialogTitle);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        dialogBuilder.setCenterPanel((JComponent)changesPanel);
        dialogBuilder.setPreferredFocusComponent(changesPanel.getChangesBrowser().getPreferredFocusedComponent());
        dialogBuilder.addDisposable((Disposable)changesPanel);
        dialogBuilder.setDimensionServiceKey("Git.DiffForPathsDialog");
        dialogBuilder.showNotModal();
    }

    private static void showAsTab(@NotNull Project project2, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull LocalContent localContent, @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project2 == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(8);
        }
        if (dialogTitle == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(9);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(10);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(11);
        }
        MyLoadingChangesPanel changesPanel = CompareWithLocalDialog.createPanel(project2, localContent, changesLoader);
        ChangesBrowserBase changesBrowser = changesPanel.getChangesBrowser();
        DiffPreview diffPreview = ChangesBrowserToolWindow.createDiffPreview(project2, changesBrowser, changesPanel);
        changesBrowser.setShowDiffActionPreview(diffPreview);
        Content content = ContentFactory.getInstance().createContent((JComponent)changesPanel, dialogTitle, false);
        content.setPreferredFocusableComponent(changesBrowser.getPreferredFocusedComponent());
        content.setDisposer((Disposable)changesPanel);
        ChangesBrowserToolWindow.showTab(project2, content);
    }

    @NotNull
    private static MyLoadingChangesPanel createPanel(@NotNull Project project2, @NotNull LocalContent localContent, final @NotNull ThrowableComputable<? extends Collection<Change>, ? extends VcsException> changesLoader) {
        if (project2 == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(12);
        }
        if (localContent == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(13);
        }
        if (changesLoader == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(14);
        }
        MyChangesBrowser changesBrowser = new MyChangesBrowser(project2, localContent);
        MyLoadingChangesPanel changesPanel = new MyLoadingChangesPanel(changesBrowser){

            @Override
            @NotNull
            protected Collection<Change> loadChanges() throws VcsException {
                Collection collection = (Collection)changesLoader.compute();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/CompareWithLocalDialog$1", "loadChanges"));
            }
        };
        Disposer.register((Disposable)changesPanel, (Disposable)changesBrowser);
        changesPanel.reloadChanges();
        MyLoadingChangesPanel myLoadingChangesPanel = changesPanel;
        if (myLoadingChangesPanel == null) {
            CompareWithLocalDialog.$$$reportNull$$$0(15);
        }
        return myLoadingChangesPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localContent";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesLoader";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showAsTab";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 15 -> new IllegalStateException(string2);
        };
    }

    public static enum LocalContent {
        BEFORE,
        AFTER,
        NONE;

    }

    private static abstract class MyLoadingChangesPanel
    extends JPanel
    implements DataProvider,
    Disposable {
        public static final DataKey<MyLoadingChangesPanel> DATA_KEY = DataKey.create((String)"git4idea.log.MyLoadingChangesPanel");
        private final SimpleAsyncChangesBrowser myChangesBrowser;
        private final LoadingChangesPanel myLoadingPanel;

        private MyLoadingChangesPanel(@NotNull SimpleAsyncChangesBrowser changesBrowser) {
            if (changesBrowser == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myChangesBrowser = changesBrowser;
            StatusText emptyText = this.myChangesBrowser.getViewer().getEmptyText();
            this.myLoadingPanel = new LoadingChangesPanel(this.myChangesBrowser, emptyText, this);
            this.add((Component)this.myLoadingPanel, "Center");
        }

        public void dispose() {
        }

        @NotNull
        public ChangesBrowserBase getChangesBrowser() {
            SimpleAsyncChangesBrowser simpleAsyncChangesBrowser = this.myChangesBrowser;
            if (simpleAsyncChangesBrowser == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(1);
            }
            return simpleAsyncChangesBrowser;
        }

        public void reloadChanges() {
            this.myLoadingPanel.loadChangesInBackground(this::loadChanges, this::applyResult);
        }

        @NotNull
        protected abstract Collection<Change> loadChanges() throws VcsException;

        private void applyResult(@Nullable Collection<? extends Change> changes) {
            this.myChangesBrowser.setChangesToDisplay(changes != null ? changes : Collections.emptyList());
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyLoadingChangesPanel.$$$reportNull$$$0(2);
            }
            if (DATA_KEY.is(dataId)) {
                return this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesBrowser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyLoadingChangesPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyLoadingChangesPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyChangesBrowser
    extends SimpleAsyncChangesBrowser
    implements Disposable {
        @NotNull
        private final LocalContent myLocalContent;

        private MyChangesBrowser(@NotNull Project project2, @NotNull LocalContent localContent) {
            if (project2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (localContent == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project2, false, true);
            this.myLocalContent = localContent;
            this.hideViewerBorder();
            this.myViewer.setTreeStateStrategy(ChangesTree.KEEP_NON_EMPTY);
        }

        public void dispose() {
            this.shutdown();
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
            actions2.add((AnAction)new MyRefreshAction());
            actions2.addAll(super.createToolbarActions());
            actions2.add(ActionManager.getInstance().getAction("Vcs.GetVersion"));
            ArrayList<AnAction> arrayList = actions2;
            if (arrayList == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("ChangesView.CreatePatchFromChanges"), ActionManager.getInstance().getAction("Vcs.GetVersion")});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localContent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyChangesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyRefreshAction
    extends DumbAwareAction {
        private MyRefreshAction() {
            super(VcsBundle.messagePointer("action.name.refresh.compare.with.local.panel", new Object[0]), VcsBundle.messagePointer("action.description.refresh.compare.with.local.panel", new Object[0]), AllIcons.Actions.Refresh);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Refresh"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyRefreshAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            MyLoadingChangesPanel changesPanel;
            if (e == null) {
                MyRefreshAction.$$$reportNull$$$0(1);
            }
            if ((changesPanel = (MyLoadingChangesPanel)e.getData(MyLoadingChangesPanel.DATA_KEY)) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            MyChangesBrowser browser = (MyChangesBrowser)ObjectUtils.tryCast((Object)changesPanel.getChangesBrowser(), MyChangesBrowser.class);
            e.getPresentation().setEnabledAndVisible(browser != null && browser.myLocalContent != LocalContent.NONE);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRefreshAction.$$$reportNull$$$0(2);
            }
            MyLoadingChangesPanel changesPanel = (MyLoadingChangesPanel)e.getRequiredData(MyLoadingChangesPanel.DATA_KEY);
            FileDocumentManager.getInstance().saveAllDocuments();
            changesPanel.reloadChanges();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$MyRefreshAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$MyRefreshAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }

    public static class GetVersionActionProvider
    implements AnActionExtensionProvider {
        public boolean isActive(@NotNull AnActionEvent e) {
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(0);
            }
            return e.getData(MyLoadingChangesPanel.DATA_KEY) != null;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GetVersionActionProvider.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(2);
            }
            Project project2 = e.getProject();
            MyLoadingChangesPanel changesPanel = (MyLoadingChangesPanel)e.getData(MyLoadingChangesPanel.DATA_KEY);
            if (project2 == null || changesPanel == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            MyChangesBrowser browser = (MyChangesBrowser)ObjectUtils.tryCast((Object)changesPanel.getChangesBrowser(), MyChangesBrowser.class);
            boolean isVisible2 = browser != null && browser.myLocalContent != LocalContent.NONE;
            boolean isEnabled = isVisible2 && !browser.getSelectedChanges().isEmpty();
            e.getPresentation().setVisible(isVisible2);
            e.getPresentation().setEnabled(isEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(3);
            }
            Project project2 = Objects.requireNonNull(e.getProject());
            MyLoadingChangesPanel changesPanel = (MyLoadingChangesPanel)e.getRequiredData(MyLoadingChangesPanel.DATA_KEY);
            MyChangesBrowser browser = (MyChangesBrowser)changesPanel.getChangesBrowser();
            List fileContentProviders = ContainerUtil.map(browser.getSelectedChanges(), change -> new MyFileContentProvider((Change)change, browser.myLocalContent));
            GetVersionAction.doGet(project2, VcsBundle.message("compare.with.dialog.get.from.vcs.action.title", new Object[0]), fileContentProviders, () -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                changesPanel.reloadChanges();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$GetVersionActionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$GetVersionActionProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isActive";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }

        private static class MyFileContentProvider
        implements GetVersionAction.FileRevisionProvider {
            @NotNull
            private final Change myChange;
            @NotNull
            private final LocalContent myLocalContent;

            private MyFileContentProvider(@NotNull Change change, @NotNull LocalContent localContent) {
                if (change == null) {
                    MyFileContentProvider.$$$reportNull$$$0(0);
                }
                if (localContent == null) {
                    MyFileContentProvider.$$$reportNull$$$0(1);
                }
                this.myChange = change;
                this.myLocalContent = localContent;
            }

            @Override
            @NotNull
            public FilePath getFilePath() {
                FilePath filePath = ChangesUtil.getFilePath(this.myChange);
                if (filePath == null) {
                    MyFileContentProvider.$$$reportNull$$$0(2);
                }
                return filePath;
            }

            @Override
            @Nullable
            public GetVersionAction.FileRevisionContent getContent() throws VcsException {
                ContentRevision revision;
                ContentRevision contentRevision = revision = this.myLocalContent == LocalContent.AFTER ? this.myChange.getBeforeRevision() : this.myChange.getAfterRevision();
                if (revision == null) {
                    return null;
                }
                byte[] bytes = ChangesUtil.loadContentRevision(revision);
                FilePath oldFilePath = this.myChange.isMoved() || this.myChange.isRenamed() ? revision.getFile() : null;
                return new GetVersionAction.FileRevisionContent(bytes, oldFilePath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localContent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/CompareWithLocalDialog$GetVersionActionProvider$MyFileContentProvider";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/CompareWithLocalDialog$GetVersionActionProvider$MyFileContentProvider";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilePath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        }
    }
}

