/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.ui.ExperimentalUI;
import com.intellij.vcs.log.ui.ClassicUiVcsLogColorManager;
import com.intellij.vcs.log.ui.NewUiVcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.awt.Color;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0001H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogColorManagerSwitcher;", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Ljava/util/Collection;)V", "colorManager", "isNewUI", "", "createColorManager", "getLongName", "", "path", "getPathColor", "Ljava/awt/Color;", "colorMode", "getPaths", "hasMultiplePaths", "updateColorManagerIfNeeded", "", "intellij.platform.vcs.log.impl"})
final class VcsLogColorManagerSwitcher
implements VcsLogColorManager {
    @NotNull
    private final Collection<FilePath> paths;
    private boolean isNewUI;
    @NotNull
    private VcsLogColorManager colorManager;

    public VcsLogColorManagerSwitcher(@NotNull Collection<? extends FilePath> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        this.paths = paths;
        this.isNewUI = ExperimentalUI.Companion.isNewUI();
        this.colorManager = this.createColorManager();
    }

    private final VcsLogColorManager createColorManager() {
        return this.isNewUI ? (VcsLogColorManager)new NewUiVcsLogColorManager(this.paths) : (VcsLogColorManager)new ClassicUiVcsLogColorManager(this.paths);
    }

    private final void updateColorManagerIfNeeded() {
        if (this.isNewUI == ExperimentalUI.Companion.isNewUI()) {
            return;
        }
        this.isNewUI = ExperimentalUI.Companion.isNewUI();
        this.colorManager = this.createColorManager();
    }

    @Override
    @NotNull
    public Color getPathColor(@NotNull FilePath path2, @NotNull String colorMode) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)colorMode, (String)"colorMode");
        this.updateColorManagerIfNeeded();
        Color color = this.colorManager.getPathColor(path2, colorMode);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getPathColor(...)");
        return color;
    }

    @Override
    @NotNull
    public String getLongName(@NotNull FilePath path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string2 = this.colorManager.getLongName(path2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLongName(...)");
        return string2;
    }

    @Override
    public boolean hasMultiplePaths() {
        return this.colorManager.hasMultiplePaths();
    }

    @Override
    @NotNull
    public Collection<FilePath> getPaths() {
        Collection<FilePath> collection = this.colorManager.getPaths();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getPaths(...)");
        return collection;
    }
}

