/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.sarif;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.Fix;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.sarif.InvalidSarifException;
import org.jetbrains.qodana.sarif.ProblemReaderException;
import org.jetbrains.qodana.sarif.ProblemTransformer;
import org.jetbrains.qodana.sarif.QodanaProblemsWriter;
import org.jetbrains.qodana.sarif.QodanaReportConverter;
import org.jetbrains.qodana.sarif.QodanaReportConverterKt;
import org.jetbrains.qodana.sarif.sarif.CoverageInfo;
import org.jetbrains.qodana.sarif.sarif.SarifPartialInformation;
import org.jetbrains.qodana.sarif.sarif.SarifVersionControlDetailsSupplierKt;
import org.jetbrains.teamcity.qodana.model.version3.Problem;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0002J\b\u0010\"\u001a\u00020\nH\u0002J\b\u0010#\u001a\u00020\nH\u0002J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010&\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020\nH\u0002J\u0018\u0010(\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/qodana/sarif/QodanaReportConverter;", "", "options", "Lorg/jetbrains/qodana/sarif/QodanaReportConverter$Options;", "(Lorg/jetbrains/qodana/sarif/QodanaReportConverter$Options;)V", "gson", "Lcom/google/gson/Gson;", "transformer", "Lorg/jetbrains/qodana/sarif/ProblemTransformer;", "convert", "", "copy", "file", "Ljava/io/File;", "destination", "copyFiles", "src", "Ljava/nio/file/Path;", "dst", "validateOptions", "writeCoverage", "sarif", "Lorg/jetbrains/qodana/sarif/sarif/SarifPartialInformation;", "writeCoverageArtifacts", "writeDescription", "problemsWriterOutput", "writeMetaInformation", "total", "", "writeProblems", "", "Lorg/jetbrains/teamcity/qodana/model/version3/Problem;", "tmpFile", "output", "writeProjectStructure", "writeQodanaConfig", "writeQodanaPromo", "writeQodanaSanity", "writeQodanaSarif", "writeResults", "writeResultsAllProblems", "Options", "sarif-converter"})
@SourceDebugExtension(value={"SMAP\nQodanaReportConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaReportConverter.kt\norg/jetbrains/qodana/sarif/QodanaReportConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,263:1\n1#2:264\n1295#3,2:265\n483#4,7:267\n*S KotlinDebug\n*F\n+ 1 QodanaReportConverter.kt\norg/jetbrains/qodana/sarif/QodanaReportConverter\n*L\n158#1:265,2\n229#1:267,7\n*E\n"})
public final class QodanaReportConverter {
    @NotNull
    private final Options options;
    @NotNull
    private final Gson gson;
    @NotNull
    private final ProblemTransformer transformer;

    public QodanaReportConverter(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, (Object)new ProblemTransformer.PathSerializer()).registerTypeAdapter((Type)((Object)Fix.class), (Object)SarifUtil.createGson().getAdapter(Fix.class)).setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026g()\n            .create()");
        this.gson = gson;
        this.transformer = new ProblemTransformer(this.gson);
    }

    public final void convert() {
        this.validateOptions();
        this.options.getOutput().mkdirs();
        this.writeResults();
    }

    private final void validateOptions() {
        boolean outputDirIsNotEmpty;
        if (this.options.getLimit() < 0) {
            throw new ProblemReaderException("Limit must not be less than zero", null, 2, null);
        }
        if (!this.options.getInput().isDirectory()) {
            throw new ProblemReaderException("Input must be a directory", null, 2, null);
        }
        File[] fileArray = this.options.getOutput().listFiles();
        boolean bl = fileArray != null ? !(fileArray.length == 0) : (outputDirIsNotEmpty = false);
        if (outputDirIsNotEmpty) {
            throw new ProblemReaderException("Output directory is not empty", null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeResults() {
        File tempProblemsWriterOutput = Files.createTempDirectory("qodanaTemp", new FileAttribute[0]).toFile();
        try {
            List<Problem> problems2;
            File file = this.options.getInput();
            int n = this.options.getLimit();
            Intrinsics.checkNotNullExpressionValue((Object)tempProblemsWriterOutput, (String)"tempProblemsWriterOutput");
            QodanaProblemsWriter.INSTANCE.writeProblems(file, n, tempProblemsWriterOutput);
            List<Problem> list2 = problems2 = this.writeResultsAllProblems(tempProblemsWriterOutput);
            int totalProblems = list2 != null ? list2.size() : 0;
            File sarifFile = FilesKt.resolve((File)this.options.getInput(), (String)"qodana.sarif.json");
            SarifPartialInformation sarif = SarifVersionControlDetailsSupplierKt.getSarifPartialInfo(sarifFile);
            this.writeDescription(tempProblemsWriterOutput);
            this.writeProjectStructure();
            this.writeQodanaConfig();
            this.writeQodanaSarif();
            this.writeMetaInformation(sarif, totalProblems);
            this.writeCoverage(sarif);
            this.writeCoverageArtifacts();
            this.writeQodanaSanity(tempProblemsWriterOutput);
            this.writeQodanaPromo(tempProblemsWriterOutput);
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue((Object)tempProblemsWriterOutput, (String)"tempProblemsWriterOutput");
            FilesKt.deleteRecursively((File)tempProblemsWriterOutput);
            throw throwable;
        }
        FilesKt.deleteRecursively((File)tempProblemsWriterOutput);
    }

    private final void copy(File file, File destination) {
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(file.toPath(), destination.toPath(), copyOptionArray);
        }
        catch (Exception e) {
            QodanaReportConverterKt.access$getLog$p().error("Problems occurred while moving " + file.getName() + " to " + destination + ": " + e.getMessage());
        }
    }

    private final void copyFiles(Path src, Path dst) {
        try {
            Files.deleteIfExists(dst);
            Files.createDirectories(dst, new FileAttribute[0]);
            Files.walk(src, new FileVisitOption[0]).filter(arg_0 -> QodanaReportConverter.copyFiles$lambda$0(copyFiles.1.INSTANCE, arg_0)).forEach(arg_0 -> QodanaReportConverter.copyFiles$lambda$1((Function1)new Function1<Path, Unit>(dst, src){
                final /* synthetic */ Path $dst;
                final /* synthetic */ Path $src;
                {
                    this.$dst = $dst;
                    this.$src = $src;
                    super(1);
                }

                public final void invoke(Path path) {
                    Path dest = this.$dst.resolve(this.$src.relativize(path));
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(path, dest, copyOptionArray);
                }
            }, arg_0));
        }
        catch (Exception e) {
            QodanaReportConverterKt.access$getLog$p().error("Problems occurred while moving " + src + " to " + dst + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Problem> writeProblems(File tmpFile, File output2) {
        List<Problem> list2;
        try {
            list2 = this.transformer.transformAndWriteProblemsV3(tmpFile, output2);
        }
        catch (Exception e) {
            QodanaReportConverterKt.access$getLog$p().error("Problems occurred while converting found problems to Qodana style");
            list2 = null;
        }
        finally {
            tmpFile.delete();
        }
        return list2;
    }

    private final void writeDescription(File problemsWriterOutput) {
        File file;
        File descriptionsFile = FilesKt.resolve((File)problemsWriterOutput, (String)"description.json");
        if (!descriptionsFile.exists()) {
            QodanaReportConverterKt.access$getLog$p().warn("Missing description.json file");
            return;
        }
        File it = file = FilesKt.resolve((File)this.options.getOutput(), (String)"descriptions");
        boolean bl = false;
        it.mkdirs();
        File destination = FilesKt.resolve((File)file, (String)"Code_Inspection.json");
        this.copy(descriptionsFile, destination);
    }

    private final List<Problem> writeResultsAllProblems(File problemsWriterOutput) {
        File problemsFile = FilesKt.resolve((File)problemsWriterOutput, (String)"qodanaProblems.json");
        return this.writeProblems(problemsFile, FilesKt.resolve((File)this.options.getOutput(), (String)"result-allProblems.json"));
    }

    private final void writeQodanaSanity(File problemsWriterOutput) {
        File sanityFile = FilesKt.resolve((File)problemsWriterOutput, (String)"sanity.json");
        if (sanityFile.exists()) {
            this.writeProblems(sanityFile, FilesKt.resolve((File)this.options.getOutput(), (String)"sanity.json"));
        }
    }

    private final void writeQodanaPromo(File problemsWriterOutput) {
        File sanityFile = FilesKt.resolve((File)problemsWriterOutput, (String)"promo.json");
        if (sanityFile.exists()) {
            this.writeProblems(sanityFile, FilesKt.resolve((File)this.options.getOutput(), (String)"promo.json"));
        }
    }

    private final void writeProjectStructure() {
        File file;
        File projectStructure = FilesKt.resolve((File)this.options.getInput(), (String)"projectStructure/");
        if (!projectStructure.exists()) {
            QodanaReportConverterKt.access$getLog$p().warn("Missing " + projectStructure.toPath() + " directory");
            return;
        }
        File $this$writeProjectStructure_u24lambda_u243 = file = FilesKt.resolve((File)this.options.getOutput(), (String)"projectStructure/");
        boolean bl = false;
        $this$writeProjectStructure_u24lambda_u243.mkdir();
        File codeInspectionStructureDir = file;
        this.copy(FilesKt.resolve((File)projectStructure, (String)"Modules.json"), FilesKt.resolve((File)codeInspectionStructureDir, (String)"Code_Inspection.json"));
        File $this$writeProjectStructure_u24lambda_u244 = $this$writeProjectStructure_u24lambda_u243 = FilesKt.resolve((File)this.options.getOutput(), (String)"Code_Inspection/projectStructure");
        boolean bl2 = false;
        $this$writeProjectStructure_u24lambda_u244.mkdirs();
        File reportProjectStructure = $this$writeProjectStructure_u24lambda_u243;
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)projectStructure, null, (int)1, null)), (Function1)writeProjectStructure.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl3 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            this.copy(it, FilesKt.resolve((File)reportProjectStructure, (String)string));
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            this.copy(it, FilesKt.resolve((File)codeInspectionStructureDir, (String)string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeMetaInformation(SarifPartialInformation sarif, int total) {
        Closeable closeable = new FileWriter(FilesKt.resolve((File)this.options.getOutput(), (String)"metaInformation.json"));
        Throwable throwable = null;
        try {
            void map2;
            Map map3;
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            Map map4 = map3 = (Map)new LinkedHashMap();
            Gson gson = this.gson;
            boolean bl2 = false;
            Map attributes = new LinkedHashMap();
            Integer n = total;
            map2.put("total", n);
            map2.put("tools inspection", MapsKt.mapOf((Pair)TuplesKt.to((Object)"Code Inspection", (Object)total)));
            VersionControlDetails versionControlDetails = sarif.getVersionControlDetails();
            if (versionControlDetails != null) {
                VersionControlDetails $this$writeMetaInformation_u24lambda_u248_u24lambda_u247_u24lambda_u246 = versionControlDetails;
                boolean bl3 = false;
                Map map5 = attributes;
                Pair pair = new Pair[]{TuplesKt.to((Object)"repositoryUri", (Object)$this$writeMetaInformation_u24lambda_u248_u24lambda_u247_u24lambda_u246.getRepositoryUri()), TuplesKt.to((Object)"revisionId", (Object)$this$writeMetaInformation_u24lambda_u248_u24lambda_u247_u24lambda_u246.getRevisionId()), TuplesKt.to((Object)"branch", (Object)$this$writeMetaInformation_u24lambda_u248_u24lambda_u247_u24lambda_u246.getBranch())};
                pair = TuplesKt.to((Object)"vcs", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"sarifIdea", (Object)MapsKt.mutableMapOf((Pair[])pair))));
                map5.put(pair.getFirst(), pair.getSecond());
            }
            if (sarif.getDeviceId() != null) {
                attributes.put("deviceId", sarif.getDeviceId());
            }
            if (sarif.getJobUrl() != null) {
                attributes.put("jobUrl", sarif.getJobUrl());
            }
            if (sarif.getRepoUrl() != null) {
                attributes.put("repoUrl", sarif.getRepoUrl());
            }
            if (sarif.getLinter() != null) {
                map2.put("linter", sarif.getLinter());
            }
            map2.put("attributes", attributes);
            gson.toJson((Object)map3, (Appendable)writer);
            writer.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeCoverage(SarifPartialInformation sarif) {
        Map map2;
        Object object;
        Map map3;
        if (sarif.getCoverage() != null) {
            Pair[] pairArray = new Pair[3];
            Integer n = sarif.getCoverage().getTotalCoverage();
            if (n == null) {
                throw new InvalidSarifException("Missing required coverage property: totalCoverage");
            }
            pairArray[0] = TuplesKt.to((Object)"totalCoverage", (Object)n);
            Integer n2 = sarif.getCoverage().getTotalLines();
            if (n2 == null) {
                throw new InvalidSarifException("Missing required coverage property: totalLines");
            }
            pairArray[1] = TuplesKt.to((Object)"totalLines", (Object)n2);
            Integer n3 = sarif.getCoverage().getTotalCoveredLines();
            if (n3 == null) {
                throw new InvalidSarifException("Missing required coverage property: totalCoveredLines");
            }
            pairArray[2] = TuplesKt.to((Object)"totalCoveredLines", (Object)n3);
            map3 = MapsKt.mapOf((Pair[])pairArray);
        } else {
            map3 = null;
        }
        Map total = map3;
        CoverageInfo coverageInfo = sarif.getCoverage();
        if ((coverageInfo != null ? coverageInfo.getFreshCoverage() : null) != null) {
            object = new Pair[3];
            object[0] = TuplesKt.to((Object)"freshCoverage", (Object)sarif.getCoverage().getFreshCoverage());
            Integer n = sarif.getCoverage().getFreshLines();
            if (n == null) {
                throw new InvalidSarifException("Missing required coverage property: freshLines");
            }
            object[1] = TuplesKt.to((Object)"freshLines", (Object)n);
            Integer n4 = sarif.getCoverage().getFreshCoveredLines();
            if (n4 == null) {
                throw new InvalidSarifException("Missing required coverage property: freshCoveredLines");
            }
            object[2] = TuplesKt.to((Object)"freshCoveredLines", (Object)n4);
            map2 = MapsKt.mapOf((Pair[])object);
        } else {
            map2 = null;
        }
        Map fresh = map2;
        object = new FileWriter(FilesKt.resolve((File)this.options.getOutput(), (String)"coverageInformation.json"));
        Throwable throwable = null;
        try {
            void $this$filterValues$iv;
            FileWriter writer = (FileWriter)object;
            boolean bl = false;
            Object object2 = new Pair[]{TuplesKt.to((Object)"version", (Object)"1.0"), TuplesKt.to((Object)"total", (Object)total), TuplesKt.to((Object)"fresh", (Object)fresh)};
            object2 = MapsKt.mapOf((Pair[])object2);
            Gson gson = this.gson;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                Object it = entry$iv.getValue();
                boolean bl2 = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            gson.toJson((Object)result$iv, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void writeCoverageArtifacts() {
        File coverageDir = FilesKt.resolve((File)this.options.getInput(), (String)"coverage/");
        if (!coverageDir.exists()) {
            return;
        }
        Path path = coverageDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"coverageDir.toPath()");
        Path path2 = FilesKt.resolve((File)this.options.getOutput(), (String)"coverage/").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"options.output.resolve(\"coverage/\").toPath()");
        this.copyFiles(path, path2);
    }

    private final void writeQodanaConfig() {
        File qodanaConfig = FilesKt.resolve((File)this.options.getInput(), (String)"log/qodana.yaml");
        if (!qodanaConfig.exists()) {
            QodanaReportConverterKt.access$getLog$p().warn("The project doesn't contain qodana.yaml config file");
            return;
        }
        File destination = FilesKt.resolve((File)this.options.getOutput(), (String)"qodana.yaml");
        this.copy(qodanaConfig, destination);
    }

    private final void writeQodanaSarif() {
        File sarif = FilesKt.resolve((File)this.options.getInput(), (String)"qodana.sarif.json");
        if (!sarif.exists()) {
            QodanaReportConverterKt.access$getLog$p().warn("File " + sarif + " does not exist");
            return;
        }
        File destination = FilesKt.resolve((File)this.options.getOutput(), (String)"qodana.sarif.json");
        this.copy(sarif, destination);
    }

    private static final boolean copyFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void copyFiles$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/sarif/QodanaReportConverter$Options;", "", "limit", "", "input", "Ljava/io/File;", "output", "(ILjava/io/File;Ljava/io/File;)V", "getInput", "()Ljava/io/File;", "getLimit", "()I", "getOutput", "sarif-converter"})
    public static final class Options {
        private final int limit;
        @NotNull
        private final File input;
        @NotNull
        private final File output;

        public Options(int limit, @NotNull File input, @NotNull File output2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            this.limit = limit;
            this.input = input;
            this.output = output2;
        }

        public final int getLimit() {
            return this.limit;
        }

        @NotNull
        public final File getInput() {
            return this.input;
        }

        @NotNull
        public final File getOutput() {
            return this.output;
        }
    }
}

