/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classes;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public class KotlinSerializerFilter
implements ClassSignatureFilter {
    public static final String SERIALIZER_SUFFIX = "$$serializer";

    /*
     * WARNING - void declaration
     */
    public boolean shouldFilter(ClassReader cr, ProjectData projectData) {
        void var2_2;
        void var1_1;
        void var3_3;
        String className = cr.getClassName();
        if (!className.endsWith(SERIALIZER_SUFFIX)) {
            return false;
        }
        String[] interfaces = cr.getInterfaces();
        if (interfaces.length != 1 || !"kotlinx/serialization/internal/GeneratedSerializer".equals(var3_3[0])) {
            return false;
        }
        String parentName = InstrumentationUtils.getParentClassIfIsInner(cr);
        return parentName != null && ((String)var1_1 + SERIALIZER_SUFFIX).equals(var2_2);
    }
}

