/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelBuilder;

import com.intellij.gradle.toolingExtension.impl.model.projectModel.ExternalProjectBuilderImpl;
import com.intellij.gradle.toolingExtension.impl.modelBuilder.DefaultModelBuilderContext;
import com.intellij.gradle.toolingExtension.util.GradleNegotiationUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.internal.DummyModel;
import org.jetbrains.plugins.gradle.model.internal.TurnOffDefaultTasks;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

public class ExtraModelBuilder
implements ToolingModelBuilder {
    private final List<ModelBuilderService> modelBuilderServices = Lists.newArrayList(ServiceLoader.load(ModelBuilderService.class, ExtraModelBuilder.class.getClassLoader()));
    private final AtomicReference<DefaultModelBuilderContext> modelBuilderContext = new AtomicReference<Object>(null);

    public boolean canBuild(@NotNull String modelName) {
        if (modelName == null) {
            ExtraModelBuilder.$$$reportNull$$$0(0);
        }
        if (DummyModel.class.getName().equals(modelName)) {
            return true;
        }
        if (TurnOffDefaultTasks.class.getName().equals(modelName)) {
            return true;
        }
        for (ModelBuilderService service : this.modelBuilderServices) {
            if (!service.canBuild(modelName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        if (modelName == null) {
            ExtraModelBuilder.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ExtraModelBuilder.$$$reportNull$$$0(2);
        }
        return this.buildModel(modelName, null, project);
    }

    @Nullable
    protected Object buildModel(@NotNull String modelName, @Nullable ModelBuilderService.Parameter parameter, @NotNull Project project) {
        if (modelName == null) {
            ExtraModelBuilder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ExtraModelBuilder.$$$reportNull$$$0(4);
        }
        if (DummyModel.class.getName().equals(modelName)) {
            return new DummyModel(){};
        }
        if (TurnOffDefaultTasks.class.getName().equals(modelName)) {
            ExtraModelBuilder.turnOffDefaultTasks(project);
            return null;
        }
        ModelBuilderContext context = this.modelBuilderContext.updateAndGet(it -> {
            if (it == null) {
                Gradle rootGradle = ExtraModelBuilder.getRootGradle(project.getGradle());
                return new DefaultModelBuilderContext(rootGradle);
            }
            return it;
        });
        for (ModelBuilderService service : this.modelBuilderServices) {
            if (!service.canBuild(modelName)) continue;
            return ExtraModelBuilder.buildServiceModel(modelName, project, context, service, parameter);
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    private static void turnOffDefaultTasks(@NotNull Project project) {
        StartParameter startParameter;
        List taskNames;
        if (project == null) {
            ExtraModelBuilder.$$$reportNull$$$0(5);
        }
        if ((taskNames = (startParameter = project.getGradle().getStartParameter()).getTaskNames()).isEmpty()) {
            startParameter.setTaskNames(null);
            List<String> helpTask = Collections.singletonList("help");
            project.setDefaultTasks(helpTask);
            startParameter.setExcludedTaskNames(helpTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Object buildServiceModel(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull ModelBuilderService service, @Nullable ModelBuilderService.Parameter parameter) {
        if (modelName == null) {
            ExtraModelBuilder.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ExtraModelBuilder.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ExtraModelBuilder.$$$reportNull$$$0(8);
        }
        if (service == null) {
            ExtraModelBuilder.$$$reportNull$$$0(9);
        }
        long startTime = System.currentTimeMillis();
        try {
            if (service instanceof ModelBuilderService.ParameterizedModelBuilderService) {
                Object object = ((ModelBuilderService.ParameterizedModelBuilderService)service).buildAll(modelName, project, context, parameter);
                return object;
            }
            if (service instanceof ModelBuilderService.Ex) {
                Object object = ((ModelBuilderService.Ex)service).buildAll(modelName, project, context);
                return object;
            }
            Object object = service.buildAll(modelName, project);
            return object;
        }
        catch (Exception exception) {
            if (service instanceof ExternalProjectBuilderImpl) {
                throw ExtraModelBuilder.asRuntimeException(exception);
            }
            service.reportErrorMessage(modelName, project, context, exception);
            Object var8_13 = null;
            return var8_13;
        }
        finally {
            if (Boolean.getBoolean("idea.gradle.custom.tooling.perf")) {
                long timeInMs = System.currentTimeMillis() - startTime;
                ExtraModelBuilder.reportPerformanceStatistic(project, service, modelName, timeInMs);
            }
        }
    }

    private static void reportPerformanceStatistic(@NotNull Project project, @NotNull ModelBuilderService service, @NotNull String modelName, long timeInMs) {
        if (project == null) {
            ExtraModelBuilder.$$$reportNull$$$0(10);
        }
        if (service == null) {
            ExtraModelBuilder.$$$reportNull$$$0(11);
        }
        if (modelName == null) {
            ExtraModelBuilder.$$$reportNull$$$0(12);
        }
        String projectName = GradleNegotiationUtil.getProjectDisplayName((Project)project);
        String serviceName = service.getClass().getSimpleName();
        String msg = String.format("%s: service %s imported '%s' in %d ms", projectName, serviceName, modelName, timeInMs);
        project.getLogger().error(msg);
    }

    @NotNull
    private static RuntimeException asRuntimeException(@NotNull Exception exception) {
        if (exception == null) {
            ExtraModelBuilder.$$$reportNull$$$0(13);
        }
        if (exception instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)exception;
            if (runtimeException == null) {
                ExtraModelBuilder.$$$reportNull$$$0(14);
            }
            return runtimeException;
        }
        return new ExternalSystemException((Throwable)exception);
    }

    @NotNull
    private static Gradle getRootGradle(@NotNull Gradle gradle) {
        if (gradle == null) {
            ExtraModelBuilder.$$$reportNull$$$0(15);
        }
        Gradle root = gradle;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Gradle gradle2 = root;
        if (gradle2 == null) {
            ExtraModelBuilder.$$$reportNull$$$0(16);
        }
        return gradle2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/modelBuilder/ExtraModelBuilder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelBuilder/ExtraModelBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asRuntimeException";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootGradle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBuild";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "turnOffDefaultTasks";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildServiceModel";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportPerformanceStatistic";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "asRuntimeException";
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRootGradle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ForGradle44
    extends ExtraModelBuilder
    implements ParameterizedToolingModelBuilder<ModelBuilderService.Parameter> {
        @NotNull
        public Class<ModelBuilderService.Parameter> getParameterType() {
            return ModelBuilderService.Parameter.class;
        }

        @Nullable
        public Object buildAll(@NotNull String modelName, @NotNull ModelBuilderService.Parameter parameter, @NotNull Project project) {
            if (modelName == null) {
                ForGradle44.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                ForGradle44.$$$reportNull$$$0(1);
            }
            if (project == null) {
                ForGradle44.$$$reportNull$$$0(2);
            }
            return this.buildModel(modelName, parameter, project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modelName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gradle/toolingExtension/impl/modelBuilder/ExtraModelBuilder$ForGradle44";
            objectArray[2] = "buildAll";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

