/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.webservice.routing;

import com.jetbrains.performancePlugin.remotedriver.webservice.routing.Handler;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.PathSegment;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.PathSegmentType;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.RequestContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001f\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/webservice/routing/PathHandler;", "Lcom/jetbrains/performancePlugin/remotedriver/webservice/routing/Handler;", "method", "Lio/netty/handler/codec/http/HttpMethod;", "path", "", "handler", "Lkotlin/Function1;", "Lcom/jetbrains/performancePlugin/remotedriver/webservice/routing/RequestContext;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/netty/handler/codec/http/HttpMethod;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "pathSegments", "", "Lcom/jetbrains/performancePlugin/remotedriver/webservice/routing/PathSegment;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "match", "", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathHandler.kt\ncom/jetbrains/performancePlugin/remotedriver/webservice/routing/PathHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1855#2,2:47\n*S KotlinDebug\n*F\n+ 1 PathHandler.kt\ncom/jetbrains/performancePlugin/remotedriver/webservice/routing/PathHandler\n*L\n12#1:47,2\n*E\n"})
public final class PathHandler
implements Handler {
    @NotNull
    private final HttpMethod method;
    @NotNull
    private final Function1<RequestContext, Object> handler;
    @NotNull
    private final List<PathSegment> pathSegments;

    /*
     * WARNING - void declaration
     */
    public PathHandler(@NotNull HttpMethod method, @NotNull String path, @NotNull Function1<? super RequestContext, ? extends Object> handler) {
        List list;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.method = method;
        this.handler = handler;
        List list2 = list = (List)new ArrayList();
        PathHandler pathHandler = this;
        boolean bl = false;
        String[] stringArray = new String[]{"/"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$pathSegments_u24lambda_u241;
            String segment = (String)element$iv;
            boolean bl2 = false;
            PathSegmentType type = StringsKt.startsWith$default((String)segment, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)segment, (String)"}", (boolean)false, (int)2, null) ? PathSegmentType.PARAMETER : PathSegmentType.CONSTANT;
            String value = type == PathSegmentType.PARAMETER ? StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)segment, (String)"{", null, (int)2, null), (String)"}", null, (int)2, null) : segment;
            $this$pathSegments_u24lambda_u241.add(new PathSegment(type, value));
        }
        pathHandler.pathSegments = CollectionsKt.toList((Iterable)list);
    }

    @Override
    public boolean match(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Intrinsics.areEqual((Object)request.method(), (Object)this.method)) {
            return false;
        }
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        String[] stringArray = new String[]{"/"};
        List uriSegments = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)string, (String)"?", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (uriSegments.size() != this.pathSegments.size()) {
            return false;
        }
        int n = uriSegments.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.pathSegments.get(n2).getType() == PathSegmentType.PARAMETER || Intrinsics.areEqual((Object)this.pathSegments.get(n2).getValue(), uriSegments.get(n2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Object execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        String[] stringArray = new String[]{"/"};
        List uriSegments = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)string, (String)"?", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (uriSegments.size() != this.pathSegments.size()) {
            throw new IllegalStateException("Wrong handler, uri path segments are not match handler path");
        }
        Map pathParameters = new LinkedHashMap();
        int n = uriSegments.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.pathSegments.get(n2).getType() != PathSegmentType.PARAMETER) continue;
            pathParameters.put(this.pathSegments.get(n2).getValue(), uriSegments.get(n2));
        }
        Map bodyParameters = new LinkedHashMap();
        request.content();
        return this.handler.invoke((Object)new RequestContext(urlDecoder, request, context, pathParameters));
    }
}

