/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.MultiMap;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushParamsImpl;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteRemoteBranchOperation
extends GitBranchOperation {
    private final List<String> myBranchNames;

    GitDeleteRemoteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler handler, @NotNull List<? extends GitRepository> repositories2, @NotNull List<String> names) {
        if (project == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories2 == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(3);
        }
        if (names == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(4);
        }
        super(project, git, handler, repositories2);
        this.myBranchNames = names;
    }

    @Override
    protected void execute() {
        Collection<GitRepository> repositories2 = this.getRepositories();
        ArrayList<String> allTrackingBranches = new ArrayList<String>();
        MultiMap branchToCommonTrackingBranches = new MultiMap();
        Ref decisionRef = Ref.create();
        for (String branchName : this.myBranchNames) {
            Collection<String> commonTrackingBranches = GitDeleteRemoteBranchOperation.getCommonTrackingBranches(branchName, repositories2);
            for (GitRepository repository : repositories2) {
                String currentBranch = repository.getCurrentBranchName();
                if (currentBranch == null) continue;
                commonTrackingBranches.remove(currentBranch);
            }
            allTrackingBranches.addAll(commonTrackingBranches);
            branchToCommonTrackingBranches.put((Object)branchName, commonTrackingBranches);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> decisionRef.set((Object)this.myUiHandler.confirmRemoteBranchDeletion(this.myBranchNames, allTrackingBranches, repositories2)));
        GitBranchUiHandler.DeleteRemoteBranchDecision decision = (GitBranchUiHandler.DeleteRemoteBranchDecision)((Object)decisionRef.get());
        if (decision == GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL) {
            return;
        }
        for (String branchName : this.myBranchNames) {
            boolean deletedSuccessfully = this.doDeleteRemote(branchName, repositories2);
            if (!deletedSuccessfully) continue;
            final ArrayList<String> successfullyDeletedLocalBranches = new ArrayList<String>(1);
            if (decision == GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE_WITH_TRACKING) {
                for (final String branch : branchToCommonTrackingBranches.get((Object)branchName)) {
                    this.getIndicator().setText(GitBundle.message("delete.remote.branch.operation.deleting.process", branch));
                    new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, branch){

                        @Override
                        protected void notifySuccess() {
                            successfullyDeletedLocalBranches.add(branch);
                        }
                    }.execute();
                }
            }
            this.notifySuccessfulDeletion(branchName, successfullyDeletedLocalBranches);
        }
    }

    @Override
    protected void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static Collection<String> getCommonTrackingBranches(@NotNull String remoteBranch, @NotNull Collection<? extends GitRepository> repositories2) {
        if (remoteBranch == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(5);
        }
        if (repositories2 == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(6);
        }
        Collection<String> collection = new GitMultiRootBranchConfig(repositories2).getCommonTrackingBranches(remoteBranch);
        if (collection == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private boolean doDeleteRemote(@NotNull String branchName, @NotNull Collection<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(8);
        }
        if (repositories2 == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(9);
        }
        Couple<String> pair = GitDeleteRemoteBranchOperation.splitNameOfRemoteBranch(branchName);
        String remoteName = (String)pair.getFirst();
        String branch = (String)pair.getSecond();
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository gitRepository : repositories2) {
            GitCommandResult res;
            GitRemote remote = GitDeleteRemoteBranchOperation.getRemoteByName(gitRepository, remoteName);
            if (remote == null) {
                LOG.error("Couldn't find remote by name: " + remoteName);
                res = GitCommandResult.error(GitBundle.message("delete.remote.branch.operation.couldn.t.find.remote.by.name", remoteName));
            } else {
                res = this.pushDeletion(gitRepository, remote, branch);
                if (!res.success() && GitDeleteRemoteBranchOperation.isAlreadyDeletedError(res.getErrorOutputAsJoinedString())) {
                    res = this.myGit.remotePrune(gitRepository, remote);
                }
            }
            result2.append(gitRepository, res);
            gitRepository.update();
        }
        if (!result2.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.remote.branch.deletion.error", GitBundle.message("delete.remote.branch.operation.failed.to.delete.remote.branch", branchName), result2.getErrorOutputWithReposIndication(), true);
        }
        return result2.totalSuccess();
    }

    private static boolean isAlreadyDeletedError(@NotNull String errorOutput) {
        if (errorOutput == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(10);
        }
        return errorOutput.contains("remote ref does not exist");
    }

    private static Couple<String> splitNameOfRemoteBranch(String branchName) {
        int firstSlash = branchName.indexOf(47);
        String remoteName = firstSlash > -1 ? branchName.substring(0, firstSlash) : branchName;
        String remoteBranchName = branchName.substring(firstSlash + 1);
        return Couple.of((Object)remoteName, (Object)remoteBranchName);
    }

    @NotNull
    private GitCommandResult pushDeletion(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        if (repository == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(11);
        }
        if (remote == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(12);
        }
        if (branchName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(13);
        }
        GitCommandResult gitCommandResult = this.myGit.push(repository, new GitPushParamsImpl(remote, ":" + branchName, false, false, false, null, Collections.emptyList()), new GitLineHandlerListener[0]);
        if (gitCommandResult == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(14);
        }
        return gitCommandResult;
    }

    @Nullable
    private static GitRemote getRemoteByName(@NotNull GitRepository repository, @NotNull String remoteName) {
        if (repository == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(15);
        }
        if (remoteName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(16);
        }
        for (GitRemote remote : repository.getRemotes()) {
            if (!remote.getName().equals(remoteName)) continue;
            return remote;
        }
        return null;
    }

    private void notifySuccessfulDeletion(@NotNull String remoteBranchName, @NotNull Collection<String> localBranches2) {
        if (remoteBranchName == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(17);
        }
        if (localBranches2 == null) {
            GitDeleteRemoteBranchOperation.$$$reportNull$$$0(18);
        }
        String message = "";
        if (!localBranches2.isEmpty()) {
            message = GitBundle.message("delete.remote.branch.operation.also.deleted.local.branches", localBranches2.size(), StringUtil.join(localBranches2, (String)", "));
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.remote.branch.deletion.success", GitBundle.message("delete.remote.branch.operation.deleted.remote.branch", remoteBranchName), message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranch";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitDeleteRemoteBranchOperation";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorOutput";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranchName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitDeleteRemoteBranchOperation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTrackingBranches";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "pushDeletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTrackingBranches";
                break;
            }
            case 7: 
            case 14: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteRemote";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyDeletedError";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pushDeletion";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteByName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccessfulDeletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 14 -> new IllegalStateException(string);
        };
    }
}

