/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.GitVcs;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.GitStageTrackerListener;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitRefreshListener;
import git4idea.util.CollectionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 32\u00020\u0001:\u0003345B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0001J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u0013H\u0002J\u0016\u0010'\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0013H\u0002J\b\u0010*\u001a\u00020+H\u0014J\u0015\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b.J\u001c\u0010/\u001a\u00020\u001f2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a01H\u0002J\u0006\u00102\u001a\u00020\u001fR\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00066"}, d2={"Lgit4idea/index/GitStageTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dirtyScopeManager", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "Lorg/jetbrains/annotations/NotNull;", "getDirtyScopeManager", "()Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/index/GitStageTrackerListener;", "kotlin.jvm.PlatformType", "ignoredPaths", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/openapi/vcs/FilePath;", "getIgnoredPaths", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "<set-?>", "Lgit4idea/index/GitStageTracker$State;", "state", "getState", "()Lgit4idea/index/GitStageTracker$State;", "addListener", "", "listener", "disposable", "dispose", "doUpdateState", "repository", "Lgit4idea/repo/GitRepository;", "gitRoots", "handleIndexFileEvents", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "isStagingAreaAvailable", "", "markDirty", "file", "markDirty$intellij_vcs_git", "update", "updater", "Lkotlin/Function1;", "updateTrackerState", "Companion", "RootState", "State", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1271#2,2:320\n1285#2,4:322\n1271#2,2:326\n1285#2,4:328\n1222#2,4:332\n*S KotlinDebug\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker\n*L\n45#1:320,2\n45#1:322,4\n49#1:326,2\n49#1:328,4\n121#1:332,4\n*E\n"})
public class GitStageTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private final EventDispatcher<GitStageTrackerListener> eventDispatcher;
    @NotNull
    private volatile State state;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public GitStageTracker(@NotNull Project project) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposableFlag = checkedDisposable;
        EventDispatcher eventDispatcher = EventDispatcher.create(GitStageTrackerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        Iterable iterable = this.gitRoots();
        GitStageTracker gitStageTracker = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            RootState rootState = RootState.Companion.empty((VirtualFile)it);
            map2.put(t, rootState);
        }
        Map map3 = result$iv;
        gitStageTracker.state = new State(map3);
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                this.handleIndexFileEvents(events);
            }
        });
        Topic topic2 = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VCS_CONFIGURATION_CHANGED");
        connection.subscribe(topic2, () -> GitStageTracker._init_$lambda$2(this));
        Topic<GitRefreshListener> topic3 = GitRefreshListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        connection.subscribe(topic3, (Object)new GitRefreshListener(){

            @Override
            public void repositoryUpdated(@NotNull GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                this.doUpdateState(repository);
            }
        });
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
        this.updateTrackerState();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final VcsDirtyScopeManager getDirtyScopeManager() {
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsDirtyScopeManager, (String)"getInstance(...)");
        return vcsDirtyScopeManager;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, List<FilePath>> getIgnoredPaths() {
        Iterable $this$associateWith$iv = this.gitRoots();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Object object = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick((VirtualFile)it);
            if (object == null || (object = object.getIgnoredFilesHolder()) == null || (object = ((GitRepositoryIgnoredFilesHolder)object).getIgnoredFilePaths()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
                object = CollectionsKt.emptyList();
            }
            Set<FilePath> set = object;
            map2.put(t, set);
        }
        return result$iv;
    }

    public final void updateTrackerState() {
        LOG.debug("Update tracker state");
        ChangeListManagerImpl.getInstanceImpl((Project)this.project).executeOnUpdaterThread(() -> GitStageTracker.updateTrackerState$lambda$3(this));
    }

    public final void markDirty$intellij_vcs_git(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.isStagingAreaAvailable()) {
            return;
        }
        VirtualFile virtualFile = GitStageTrackerKt.getRoot(this.project, file2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        if (!this.gitRoots().contains(root)) {
            return;
        }
        LOG.debug("Mark dirty " + GitIndexVirtualFileKt.filePath(file2));
        this.getDirtyScopeManager().fileDirty(GitIndexVirtualFileKt.filePath(file2));
    }

    private final void handleIndexFileEvents(List<? extends VFileEvent> events) {
        List pathsToDirty = new ArrayList();
        for (VFileEvent vFileEvent : events) {
            GitIndexVirtualFile file2;
            VirtualFile virtualFile;
            if (vFileEvent.isFromRefresh() || ((virtualFile = vFileEvent.getFile()) instanceof GitIndexVirtualFile ? (GitIndexVirtualFile)virtualFile : null) == null) continue;
            file2 = file2;
            pathsToDirty.add(file2.getFilePath());
        }
        if (!((Collection)pathsToDirty).isEmpty()) {
            Object[] objectArray = new Object[]{pathsToDirty};
            LOG.debug("Mark dirty on index VFiles save: ", objectArray);
            this.getDirtyScopeManager().filePathsDirty((Collection)pathsToDirty, (Collection)CollectionsKt.emptyList());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doUpdateState(GitRepository repository) {
        void destination$iv;
        Document[] $this$associateByTo$iv;
        LOG.debug("Updating " + repository.getRoot());
        List<GitFileStatus> list2 = repository.getStagingAreaHolder().getAllRecords();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllRecords(...)");
        Iterable iterable = list2;
        Map map2 = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv) {
            void it;
            GitFileStatus gitFileStatus = (GitFileStatus)t;
            void var13_14 = destination$iv;
            boolean bl = false;
            var13_14.put(it.getPath(), t);
        }
        void status = destination$iv;
        for (FilePath filePath : repository.getUntrackedFilesHolder().getUntrackedFilePaths()) {
            GitFileStatus trackedStatus = (GitFileStatus)status.get(filePath);
            if (trackedStatus == null) {
                Intrinsics.checkNotNull((Object)filePath);
                status.put(filePath, GitFileStatusKt.untrackedStatus(filePath));
                continue;
            }
            if (trackedStatus.getWorkTree() == ' ') {
                Intrinsics.checkNotNull((Object)filePath);
                status.put(filePath, new GitFileStatus(trackedStatus.getIndex(), '?', trackedStatus.getPath(), trackedStatus.getOrigPath()));
                continue;
            }
            LOG.warn("Untracked file " + filePath + " has a non-empty worktree status code: " + trackedStatus + ".");
        }
        Document[] documentArray = FileDocumentManager.getInstance().getUnsavedDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)documentArray, (String)"getUnsavedDocuments(...)");
        for (Document document : documentArray) {
            GitFileStatus gitFileStatus;
            void var11_17;
            GitFileStatus fileStatus;
            VirtualFile root;
            VirtualFile virtualFile;
            if (FileDocumentManager.getInstance().getFile(document) == null || !virtualFile.isValid() || !FileDocumentManager.getInstance().isFileModified(virtualFile) || GitStageTrackerKt.getRoot(this.project, virtualFile) == null || !Intrinsics.areEqual((Object)root, (Object)repository.getRoot())) continue;
            FilePath filePath = GitIndexVirtualFileKt.filePath(virtualFile);
            if (repository.getIgnoredFilesHolder().containsFile(filePath)) continue;
            GitFileStatus gitFileStatus2 = fileStatus = (GitFileStatus)status.get(filePath);
            if (gitFileStatus2 != null ? !gitFileStatus2.isTracked() : false) continue;
            if (virtualFile instanceof GitIndexVirtualFile) {
                GitFileStatus gitFileStatus3 = fileStatus;
                if ((gitFileStatus3 != null ? gitFileStatus3.getStagedStatus() : null) == null) {
                    var11_17 = status;
                    GitFileStatus gitFileStatus4 = fileStatus;
                    GitFileStatus gitFileStatus5 = fileStatus;
                    gitFileStatus = new GitFileStatus('M', gitFileStatus4 != null ? gitFileStatus4.getWorkTree() : (char)' ', filePath, (FilePath)(gitFileStatus5 != null ? gitFileStatus5.getOrigPath() : null));
                    var11_17.put(filePath, gitFileStatus);
                    continue;
                }
            }
            if (!virtualFile.isInLocalFileSystem()) continue;
            GitFileStatus gitFileStatus6 = fileStatus;
            if ((gitFileStatus6 != null ? gitFileStatus6.getUnStagedStatus() : null) != null) continue;
            var11_17 = status;
            GitFileStatus gitFileStatus7 = fileStatus;
            GitFileStatus gitFileStatus8 = fileStatus;
            gitFileStatus = new GitFileStatus(gitFileStatus7 != null ? gitFileStatus7.getIndex() : (char)' ', 'M', filePath, (FilePath)(gitFileStatus8 != null ? gitFileStatus8.getOrigPath() : null));
            var11_17.put(filePath, gitFileStatus);
        }
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        RootState newRootState = new RootState(virtualFile, true, (Map<FilePath, GitFileStatus>)status);
        BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)this.disposableFlag, (Function0)((Function0)new Function0<Unit>(this, repository, newRootState){
            final /* synthetic */ GitStageTracker this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ RootState $newRootState;
            {
                this.this$0 = $receiver;
                this.$repository = $repository;
                this.$newRootState = $newRootState;
                super(0);
            }

            public final void invoke() {
                GitStageTracker.access$update(this.this$0, (Function1)new Function1<State, State>(this.$repository, this.$newRootState){
                    final /* synthetic */ GitRepository $repository;
                    final /* synthetic */ RootState $newRootState;
                    {
                        this.$repository = $repository;
                        this.$newRootState = $newRootState;
                        super(1);
                    }

                    @NotNull
                    public final State invoke(@NotNull State it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        VirtualFile virtualFile = this.$repository.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                        return it.updatedWith$intellij_vcs_git(virtualFile, this.$newRootState);
                    }
                });
            }
        }));
    }

    public final void addListener(@NotNull GitStageTrackerListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    private final List<VirtualFile> gitRoots() {
        VirtualFile[] virtualFileArray = ProjectLevelVcsManager.getInstance((Project)this.project).getRootsUnderVcs((AbstractVcs)GitVcs.getInstance(this.project));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootsUnderVcs(...)");
        return ArraysKt.toList((Object[])virtualFileArray);
    }

    private final void update(Function1<? super State, State> updater) {
        this.state = (State)updater.invoke((Object)this.state);
        Object[] objectArray = new Object[]{this.state};
        LOG.debug("New state", objectArray);
        ((GitStageTrackerListener)this.eventDispatcher.getMulticaster()).update();
    }

    protected boolean isStagingAreaAvailable() {
        return GitStageManagerKt.isStagingAreaAvailable(this.project);
    }

    public void dispose() {
        this.state = State.Companion.getEMPTY$intellij_vcs_git();
    }

    private static final void _init_$lambda$2(GitStageTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)this$0.disposableFlag, (Function0)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ GitStageTracker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List roots = GitStageTracker.access$gitRoots(this.this$0);
                GitStageTracker.access$update(this.this$0, (Function1)new Function1<State, State>((List<? extends VirtualFile>)roots){
                    final /* synthetic */ List<VirtualFile> $roots;
                    {
                        this.$roots = $roots;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final State invoke(@NotNull State oldState) {
                        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
                        Iterable $this$associateWith$iv = this.$roots;
                        boolean $i$f$associateWith = false;
                        LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                        boolean $i$f$associateWithTo = false;
                        for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                            void it;
                            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
                            T t = element$iv$iv;
                            Map map2 = result$iv;
                            boolean bl = false;
                            RootState rootState = oldState.getRootStates().get(it);
                            if (rootState == null) {
                                rootState = RootState.Companion.empty((VirtualFile)it);
                            }
                            RootState rootState2 = rootState;
                            map2.put(t, rootState2);
                        }
                        Map map3 = result$iv;
                        return new State(map3);
                    }
                });
            }
        }));
    }

    private static final void updateTrackerState$lambda$3(GitStageTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (VirtualFile root : this$0.gitRoots()) {
            GitRepository repository;
            if ((GitRepository)GitRepositoryManager.getInstance(this$0.project).getRepositoryForFile(root) == null) continue;
            this$0.doUpdateState(repository);
        }
    }

    @JvmStatic
    public static final GitStageTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ void access$update(GitStageTracker $this, Function1 updater) {
        $this.update((Function1<? super State, State>)updater);
    }

    public static final /* synthetic */ List access$gitRoots(GitStageTracker $this) {
        return $this.gitRoots();
    }

    static {
        Logger logger = Logger.getInstance(GitStageTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0000\u00a2\u0006\u0002\b\rR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/index/GitStageTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lgit4idea/index/GitStageTracker;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "getTrackers", "", "getTrackers$intellij_vcs_git", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n11383#2,9:320\n13309#2:329\n13310#2:332\n11392#2:333\n49#3:330\n1#4:331\n*S KotlinDebug\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker$Companion\n*L\n190#1:320,9\n190#1:329\n190#1:332\n190#1:333\n190#1:330\n190#1:331\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final GitStageTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (GitStageTracker)project.getService(GitStageTracker.class);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<GitStageTracker> getTrackers$intellij_vcs_git() {
            void $this$mapNotNullTo$iv$iv;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$mapNotNull$iv = projectArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                GitStageTracker it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                Project it = (Project)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)it;
                boolean $i$f$serviceIfCreated = false;
                if ((GitStageTracker)$this$serviceIfCreated$iv.getServiceIfCreated(GitStageTracker.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0017\u001a\u00020\u0005J\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0005J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lgit4idea/index/GitStageTracker$RootState;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "initialized", "", "statuses", "", "Lcom/intellij/openapi/vcs/FilePath;", "Lgit4idea/index/GitFileStatus;", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLjava/util/Map;)V", "getInitialized", "()Z", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getStatuses", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "other", "hasChangedFiles", "hasConflictedFiles", "hasStagedFiles", "hashCode", "", "isEmpty", "toString", "", "Companion", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker$RootState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1747#2,3:320\n1747#2,3:323\n1747#2,3:326\n*S KotlinDebug\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker$RootState\n*L\n197#1:320,3\n201#1:323,3\n205#1:326,3\n*E\n"})
    public static final class RootState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final VirtualFile root;
        private final boolean initialized;
        @NotNull
        private final Map<FilePath, GitFileStatus> statuses;

        public RootState(@NotNull VirtualFile root, boolean initialized, @NotNull Map<FilePath, GitFileStatus> statuses) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
            this.root = root;
            this.initialized = initialized;
            this.statuses = statuses;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        public final boolean getInitialized() {
            return this.initialized;
        }

        @NotNull
        public final Map<FilePath, GitFileStatus> getStatuses() {
            return this.statuses;
        }

        public final boolean hasStagedFiles() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.statuses.values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitFileStatus line = (GitFileStatus)element$iv;
                        boolean bl2 = false;
                        if (!(line.getStagedStatus() != null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean hasChangedFiles() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.statuses.values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitFileStatus line = (GitFileStatus)element$iv;
                        boolean bl2 = false;
                        if (!line.isTracked()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean hasConflictedFiles() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.statuses.values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitFileStatus line = (GitFileStatus)element$iv;
                        boolean bl2 = false;
                        if (!line.isConflicted()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean isEmpty() {
            return this.statuses.isEmpty();
        }

        @NonNls
        @NotNull
        public String toString() {
            return "RootState(root=" + this.root.getName() + ", statuses=" + CollectionUtilKt.toShortenedLogString$default(this.statuses, ",\n", 0, null, 6, null) + ")";
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        public final boolean component2() {
            return this.initialized;
        }

        @NotNull
        public final Map<FilePath, GitFileStatus> component3() {
            return this.statuses;
        }

        @NotNull
        public final RootState copy(@NotNull VirtualFile root, boolean initialized, @NotNull Map<FilePath, GitFileStatus> statuses) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
            return new RootState(root, initialized, statuses);
        }

        public static /* synthetic */ RootState copy$default(RootState rootState, VirtualFile virtualFile, boolean bl, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = rootState.root;
            }
            if ((n & 2) != 0) {
                bl = rootState.initialized;
            }
            if ((n & 4) != 0) {
                map2 = rootState.statuses;
            }
            return rootState.copy(virtualFile, bl, map2);
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            int n = this.initialized ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + ((Object)this.statuses).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootState)) {
                return false;
            }
            RootState rootState = (RootState)other;
            if (!Intrinsics.areEqual((Object)this.root, (Object)rootState.root)) {
                return false;
            }
            if (this.initialized != rootState.initialized) {
                return false;
            }
            return Intrinsics.areEqual(this.statuses, rootState.statuses);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/index/GitStageTracker$RootState$Companion;", "", "()V", "empty", "Lgit4idea/index/GitStageTracker$RootState;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RootState empty(@NotNull VirtualFile root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                return new RootState(root, false, MapsKt.emptyMap());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u0014\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0017J\u001d\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\""}, d2={"Lgit4idea/index/GitStageTracker$State;", "", "rootStates", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lgit4idea/index/GitStageTracker$RootState;", "(Ljava/util/Map;)V", "allRoots", "", "getAllRoots", "()Ljava/util/Set;", "changedRoots", "getChangedRoots", "conflictedRoots", "getConflictedRoots", "getRootStates", "()Ljava/util/Map;", "stagedRoots", "getStagedRoots", "component1", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "toString", "", "updatedWith", "root", "newState", "updatedWith$intellij_vcs_git", "Companion", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker$State\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n494#2,7:320\n494#2,7:327\n494#2,7:334\n1726#3,3:341\n*S KotlinDebug\n*F\n+ 1 GitStageTracker.kt\ngit4idea/index/GitStageTracker$State\n*L\n226#1:320,7\n228#1:327,7\n230#1:334,7\n240#1:341,3\n*E\n"})
    public static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<VirtualFile, RootState> rootStates;
        @NotNull
        private static final State EMPTY = new State(MapsKt.emptyMap());

        public State(@NotNull Map<VirtualFile, RootState> rootStates) {
            Intrinsics.checkNotNullParameter(rootStates, (String)"rootStates");
            this.rootStates = rootStates;
        }

        @NotNull
        public final Map<VirtualFile, RootState> getRootStates() {
            return this.rootStates;
        }

        @NotNull
        public final Set<VirtualFile> getAllRoots() {
            return this.rootStates.keySet();
        }

        @NotNull
        public final Set<VirtualFile> getStagedRoots() {
            Map<VirtualFile, RootState> $this$filterValues$iv = this.rootStates;
            boolean $i$f$filterValues = false;
            LinkedHashMap<VirtualFile, RootState> result$iv = new LinkedHashMap<VirtualFile, RootState>();
            for (Map.Entry<VirtualFile, RootState> entry$iv : $this$filterValues$iv.entrySet()) {
                RootState p0 = entry$iv.getValue();
                boolean bl = false;
                if (!p0.hasStagedFiles()) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return ((Map)result$iv).keySet();
        }

        @NotNull
        public final Set<VirtualFile> getChangedRoots() {
            Map<VirtualFile, RootState> $this$filterValues$iv = this.rootStates;
            boolean $i$f$filterValues = false;
            LinkedHashMap<VirtualFile, RootState> result$iv = new LinkedHashMap<VirtualFile, RootState>();
            for (Map.Entry<VirtualFile, RootState> entry$iv : $this$filterValues$iv.entrySet()) {
                RootState p0 = entry$iv.getValue();
                boolean bl = false;
                if (!p0.hasChangedFiles()) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return ((Map)result$iv).keySet();
        }

        @NotNull
        public final Set<VirtualFile> getConflictedRoots() {
            Map<VirtualFile, RootState> $this$filterValues$iv = this.rootStates;
            boolean $i$f$filterValues = false;
            LinkedHashMap<VirtualFile, RootState> result$iv = new LinkedHashMap<VirtualFile, RootState>();
            for (Map.Entry<VirtualFile, RootState> entry$iv : $this$filterValues$iv.entrySet()) {
                RootState p0 = entry$iv.getValue();
                boolean bl = false;
                if (!p0.hasConflictedFiles()) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return ((Map)result$iv).keySet();
        }

        @NotNull
        public final State updatedWith$intellij_vcs_git(@NotNull VirtualFile root, @NotNull RootState newState) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            Map result2 = new LinkedHashMap();
            result2.putAll(this.rootStates);
            result2.put(root, newState);
            return new State(result2);
        }

        public final boolean isEmpty() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.rootStates.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        RootState it = (RootState)element$iv;
                        boolean bl2 = false;
                        if (it.isEmpty()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NonNls
        @NotNull
        public String toString() {
            return "State(" + CollectionUtilKt.toShortenedLogString$default(this.rootStates, "\n", 0, (Function1)toString.1.INSTANCE, 2, null);
        }

        @NotNull
        public final Map<VirtualFile, RootState> component1() {
            return this.rootStates;
        }

        @NotNull
        public final State copy(@NotNull Map<VirtualFile, RootState> rootStates) {
            Intrinsics.checkNotNullParameter(rootStates, (String)"rootStates");
            return new State(rootStates);
        }

        public static /* synthetic */ State copy$default(State state2, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = state2.rootStates;
            }
            return state2.copy(map2);
        }

        public int hashCode() {
            return ((Object)this.rootStates).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            return Intrinsics.areEqual(this.rootStates, state2.rootStates);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/index/GitStageTracker$State$Companion;", "", "()V", "EMPTY", "Lgit4idea/index/GitStageTracker$State;", "getEMPTY$intellij_vcs_git", "()Lgit4idea/index/GitStageTracker$State;", "intellij.vcs.git"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final State getEMPTY$intellij_vcs_git() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

