/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.javac.Iterators;

public interface Difference {
    public boolean unchanged();

    public static <V> Specifier<V, ?> diff(@Nullable Iterable<V> past, @Nullable Iterable<V> now) {
        Iterable _past = Iterators.map(past, v -> DiffCapable.wrap(v));
        Iterable _now = Iterators.map(now, v -> DiffCapable.wrap(v));
        final Specifier diff = Difference.deepDiff(_past, _now);
        return new Specifier<V, Difference>(){

            @Override
            public Iterable<V> added() {
                return Iterators.map(diff.added(), adapter -> adapter.getValue());
            }

            @Override
            public Iterable<V> removed() {
                return Iterators.map(diff.removed(), adapter -> adapter.getValue());
            }

            @Override
            public Iterable<Change<V, Difference>> changed() {
                return Iterators.map(diff.changed(), c -> Change.create(((DiffCapable.Adapter)c.getPast()).getValue(), ((DiffCapable.Adapter)c.getNow()).getValue(), c.getDiff()));
            }
        };
    }

    public static <T extends DiffCapable<T, D>, D extends Difference> Specifier<T, D> deepDiff(final @Nullable Iterable<T> past, final @Nullable Iterable<T> now) {
        if (Iterators.isEmpty(past)) {
            if (Iterators.isEmpty(now)) {
                return new Specifier<T, D>(){

                    @Override
                    public boolean unchanged() {
                        return true;
                    }
                };
            }
            return new Specifier<T, D>(){

                @Override
                public Iterable<T> added() {
                    return now;
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        if (Iterators.isEmpty(now)) {
            return new Specifier<T, D>(){

                @Override
                public Iterable<T> removed() {
                    return past;
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        Set pastSet = Collections.unmodifiableSet((Set)Iterators.collect(past, Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode)));
        Set<DiffCapable> nowSet = Collections.unmodifiableSet((Set)Iterators.collect(now, Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode)));
        Map<DiffCapable, DiffCapable> nowMap = Containers.createCustomPolicyMap(DiffCapable::isSame, DiffCapable::diffHashCode);
        for (DiffCapable s : nowSet) {
            if (!pastSet.contains(s)) continue;
            nowMap.put(s, s);
        }
        final Set<DiffCapable> added = Containers.createCustomPolicySet(nowSet, DiffCapable::isSame, DiffCapable::diffHashCode);
        added.removeAll(pastSet);
        final Set<DiffCapable> removed = Containers.createCustomPolicySet(pastSet, DiffCapable::isSame, DiffCapable::diffHashCode);
        removed.removeAll(nowSet);
        final Iterable changed = Iterators.lazy(() -> {
            ArrayList result = new ArrayList(0);
            for (DiffCapable before : pastSet) {
                Object diff;
                DiffCapable after = (DiffCapable)nowMap.get(before);
                if (after == null || (diff = after.difference(before)).unchanged()) continue;
                result.add(Change.create(before, after, diff));
            }
            return result;
        });
        return new Specifier<T, D>(){

            @Override
            public Iterable<T> added() {
                return added;
            }

            @Override
            public Iterable<T> removed() {
                return removed;
            }

            @Override
            public Iterable<Change<T, D>> changed() {
                return changed;
            }
        };
    }

    public static interface Specifier<T, D extends Difference> {
        default public Iterable<T> added() {
            return Collections.emptyList();
        }

        default public Iterable<T> removed() {
            return Collections.emptyList();
        }

        default public Iterable<Change<T, D>> changed() {
            return Collections.emptyList();
        }

        default public boolean unchanged() {
            return Iterators.isEmpty(this.added()) && Iterators.isEmpty(this.removed()) && Iterators.isEmpty(this.changed());
        }
    }

    public static interface Change<T, D extends Difference> {
        public T getPast();

        public T getNow();

        public D getDiff();

        public static <T, D extends Difference> Change<T, D> create(final T past, final T now, final D diff) {
            return new Change<T, D>(){

                @Override
                public T getPast() {
                    return past;
                }

                @Override
                public T getNow() {
                    return now;
                }

                @Override
                public D getDiff() {
                    return diff;
                }
            };
        }
    }
}

