/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl.serializer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.jps.dependency.SerializableGraphElement;
import org.jetbrains.jps.dependency.impl.FileSource;
import org.jetbrains.jps.dependency.impl.serializer.NodeSerializerImpl;

public final class FileSourceNodeSerializerImpl
extends NodeSerializerImpl<FileSource> {
    public FileSourceNodeSerializerImpl() {
        super(FileSource.class);
    }

    @Override
    public <T extends SerializableGraphElement> void write(T elem, DataOutput out) throws IOException {
        Path p = ((FileSource)elem).getPath();
        out.writeUTF(p.toString());
    }

    @Override
    public <T extends SerializableGraphElement> T read(DataInput in) throws IOException {
        String s = in.readUTF();
        return (T)new FileSource(Paths.get(s, new String[0]));
    }
}

