/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl.serializer;

import com.intellij.serialization.SerializationException;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.AnnotationUsage;
import org.jetbrains.jps.dependency.java.ClassAsGenericBoundUsage;
import org.jetbrains.jps.dependency.java.ClassExtendsUsage;
import org.jetbrains.jps.dependency.java.ClassNewUsage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.FieldAssignUsage;
import org.jetbrains.jps.dependency.java.FieldUsage;
import org.jetbrains.jps.dependency.java.ImportStaticMemberUsage;
import org.jetbrains.jps.dependency.java.ImportStaticOnDemandUsage;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.MemberUsage;
import org.jetbrains.jps.dependency.java.MethodUsage;
import org.jetbrains.jps.dependency.java.ModulePackage;
import org.jetbrains.jps.dependency.java.ModuleRequires;
import org.jetbrains.jps.dependency.java.ModuleUsage;
import org.jetbrains.jps.dependency.java.ParamAnnotation;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.org.objectweb.asm.Type;

public final class SerializerUtil {
    static void writeProto(Proto proto, DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)proto.getFlags().hashCode());
        out.writeUTF(proto.getSignature());
        out.writeUTF(proto.getName());
        int annotationCount = 0;
        for (TypeRepr.ClassType type : proto.getAnnotations()) {
            ++annotationCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)annotationCount);
        for (TypeRepr.ClassType annotation : proto.getAnnotations()) {
            out.writeUTF(annotation.getJvmName());
        }
    }

    static void writeJVMClassNode(JVMClassNode jvmClassNode, DataOutput out) throws IOException {
        SerializerUtil.writeProto(jvmClassNode, out);
        out.writeUTF(jvmClassNode.getOutFilePath());
        int usagesCount = 0;
        for (Usage usage : jvmClassNode.getUsages()) {
            ++usagesCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)usagesCount);
        for (Usage usage : jvmClassNode.getUsages()) {
            if (usage instanceof Usage) {
                SerializerUtil.writeUsage(usage, out);
                continue;
            }
            throw new SerializationException("Serialization error: Unexpected type for 'usage'");
        }
    }

    /*
     * WARNING - void declaration
     */
    static void writeJvmClass(JvmClass jvmClass, DataOutput out) throws IOException {
        void var5_18;
        void var4_11;
        SerializerUtil.writeJVMClassNode(jvmClass, out);
        out.writeUTF(jvmClass.getSuperFqName());
        out.writeUTF(jvmClass.getOuterFqName());
        int interfacesCount = 0;
        for (String string : jvmClass.getInterfaces()) {
            ++interfacesCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)interfacesCount);
        for (String string : jvmClass.getInterfaces()) {
            out.writeUTF(string);
        }
        int fieldsCount = 0;
        for (JvmField jvmField : jvmClass.getFields()) {
            ++fieldsCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)fieldsCount);
        for (JvmField jvmField : jvmClass.getFields()) {
            SerializerUtil.writeJvmField(jvmField, out);
        }
        boolean bl = false;
        for (JvmMethod jvmMethod : jvmClass.getMethods()) {
            ++var4_11;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)var4_11);
        for (JvmMethod jvmMethod : jvmClass.getMethods()) {
            SerializerUtil.writeJvmMethod(jvmMethod, out);
        }
        boolean bl2 = false;
        for (ElemType elemType : jvmClass.getAnnotationTargets()) {
            ++var5_18;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)var5_18);
        for (ElemType elemType : jvmClass.getAnnotationTargets()) {
            SerializerUtil.writeElemType(elemType, out);
        }
        if (jvmClass.getRetentionPolicy() != null) {
            out.writeUTF(jvmClass.getRetentionPolicy().name());
        } else {
            out.writeUTF("");
        }
    }

    static void writeJvmField(JvmField jvmField, DataOutput out) throws IOException {
        SerializerUtil.writeProtoMember(jvmField, out);
    }

    static void writeProtoMember(ProtoMember protoMember, DataOutput out) throws IOException {
        SerializerUtil.writeProto(protoMember, out);
        SerializerUtil.writeTypeRepr(protoMember.getType(), out);
        SerializerUtil.writeValueObject(protoMember.getValue(), out);
    }

    static void writeTypeRepr(TypeRepr typeRepr, DataOutput out) throws IOException {
        String typeReprName = typeRepr.getClass().getSimpleName();
        out.writeUTF(typeReprName);
        switch (typeReprName) {
            case "PrimitiveType": {
                out.writeUTF(typeRepr.getDescriptor());
                break;
            }
            case "ClassType": {
                out.writeUTF(((TypeRepr.ClassType)typeRepr).getJvmName());
                break;
            }
            case "ArrayType": {
                out.writeUTF(typeRepr.getDescriptor());
            }
        }
    }

    static void writeValueObject(Object obj, DataOutput out) {
        try {
            Class<?> valueType;
            Class<?> clazz = valueType = obj != null ? obj.getClass() : null;
            if (valueType != null && valueType.isArray()) {
                int length = Array.getLength(obj);
                Class<?> dataType = length > 0 ? Array.get(obj, 0).getClass() : valueType.getComponentType();
                DataDescriptor descriptor = DataDescriptor.findByValueType(dataType);
                out.writeByte(-descriptor.getId());
                if (descriptor != DataDescriptor.NONE) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)length);
                    for (int idx = 0; idx < length; ++idx) {
                        Object element = Array.get(obj, idx);
                        descriptor.save(out, element);
                    }
                }
            } else {
                DataDescriptor descriptor = DataDescriptor.findByValueType(valueType);
                out.writeByte(descriptor.getId());
                descriptor.save(out, obj);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static void writeElemType(ElemType elemType, DataOutput out) throws IOException {
        out.writeUTF(elemType.name());
    }

    static void writeJvmMethod(JvmMethod jvmMethod, DataOutput out) throws IOException {
        SerializerUtil.writeProtoMember(jvmMethod, out);
        int argTypesCount = 0;
        for (TypeRepr typeRepr : jvmMethod.getArgTypes()) {
            ++argTypesCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)argTypesCount);
        for (TypeRepr typeRepr : jvmMethod.getArgTypes()) {
            SerializerUtil.writeTypeRepr(typeRepr, out);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)jvmMethod.getParamAnnotations().size());
        for (ParamAnnotation paramAnnotation : jvmMethod.getParamAnnotations()) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)paramAnnotation.paramIndex);
            out.writeUTF(paramAnnotation.type.getJvmName());
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)jvmMethod.getExceptions().size());
        for (TypeRepr.ClassType exceptions : jvmMethod.getExceptions()) {
            out.writeUTF(exceptions.getJvmName());
        }
        out.writeUTF(jvmMethod.getDescriptor());
    }

    static void writeUsage(Usage usage, DataOutput out) throws IOException {
        String usageName = usage.getClass().getSimpleName();
        out.writeUTF(usageName);
        switch (usageName) {
            case "FieldAssignUsage": {
                SerializerUtil.writeFieldAssignUsage((FieldAssignUsage)usage, out);
                break;
            }
            case "FieldUsage": {
                SerializerUtil.writeFieldUsage((FieldUsage)usage, out);
                break;
            }
            case "MethodUsage": {
                SerializerUtil.writeMethodUsage((MethodUsage)usage, out);
                break;
            }
            case "ImportStaticMemberUsage": {
                SerializerUtil.writeImportStaticMemberUsage((ImportStaticMemberUsage)usage, out);
                break;
            }
            case "ClassAsGenericBoundUsage": 
            case "ClassExtendsUsage": 
            case "ClassNewUsage": 
            case "ClassUsage": {
                SerializerUtil.writeClassUsage((ClassUsage)usage, out);
                break;
            }
            case "AnnotationUsage": {
                SerializerUtil.writeAnnotationUsage((AnnotationUsage)usage, out);
                break;
            }
            case "ModuleUsage": {
                SerializerUtil.writeModuleUsage((ModuleUsage)usage, out);
                break;
            }
            case "ImportStaticOnDemandUsage": {
                SerializerUtil.writeImportStaticOnDemandUsage((ImportStaticOnDemandUsage)usage, out);
                break;
            }
            default: {
                throw new SerializationException("Serialization error: Unexpected type for 'usage':" + usageName);
            }
        }
    }

    static void writeFieldAssignUsage(FieldAssignUsage fieldAssignUsage, DataOutput out) throws IOException {
        SerializerUtil.writeFieldUsage(fieldAssignUsage, out);
    }

    static void writeFieldUsage(FieldUsage fieldUsage, DataOutput out) throws IOException {
        ReferenceID refId = fieldUsage.getElementOwner();
        if (!(refId instanceof JvmNodeReferenceID)) {
            throw new SerializationException("Serialization error: Unexpected ReferenceID type: " + refId.getClass().getTypeName());
        }
        out.writeUTF(((JvmNodeReferenceID)refId).getNodeName());
        out.writeUTF(fieldUsage.getName());
        out.writeUTF(fieldUsage.getDescriptor());
    }

    public static void writeMethodUsage(MethodUsage methodUsage, DataOutput out) throws IOException {
        ReferenceID refId = methodUsage.getElementOwner();
        if (!(refId instanceof JvmNodeReferenceID)) {
            throw new SerializationException("Serialization error: Unexpected ReferenceID type: " + refId.getClass().getTypeName());
        }
        out.writeUTF(((JvmNodeReferenceID)refId).getNodeName());
        out.writeUTF(methodUsage.getName());
        out.writeUTF(methodUsage.getDescriptor());
    }

    public static void writeImportStaticMemberUsage(ImportStaticMemberUsage importStaticMemberUsage, DataOutput out) throws IOException {
        ReferenceID refId = importStaticMemberUsage.getElementOwner();
        if (!(refId instanceof JvmNodeReferenceID)) {
            throw new SerializationException("Serialization error: Unexpected ReferenceID type: " + refId.getClass().getTypeName());
        }
        out.writeUTF(((JvmNodeReferenceID)refId).getNodeName());
        out.writeUTF(importStaticMemberUsage.getName());
    }

    public static void writeClassUsage(ClassUsage classUsage, DataOutput out) throws IOException {
        out.writeUTF(classUsage.getClassName());
    }

    public static void writeModuleUsage(ModuleUsage moduleUsage, DataOutput out) throws IOException {
        out.writeUTF(moduleUsage.getModuleName());
    }

    public static void writeImportStaticOnDemandUsage(ImportStaticOnDemandUsage importStaticOnDemandUsage, DataOutput out) throws IOException {
        out.writeUTF(importStaticOnDemandUsage.getImportedClassName());
    }

    public static void writeAnnotationUsage(AnnotationUsage annotationUsage, DataOutput out) throws IOException {
        out.writeUTF(annotationUsage.getClassType().getJvmName());
        int userArgNamesCount = 0;
        for (String userArgName : annotationUsage.getUsedArgNames()) {
            ++userArgNamesCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)userArgNamesCount);
        for (String userArgName : annotationUsage.getUsedArgNames()) {
            out.writeUTF(userArgName);
        }
        int targetsCount = 0;
        for (ElemType elemType : annotationUsage.getTargets()) {
            ++targetsCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)targetsCount);
        for (ElemType elemType : annotationUsage.getTargets()) {
            SerializerUtil.writeElemType(elemType, out);
        }
    }

    static Proto readProto(DataInput in) throws IOException {
        int flags = DataInputOutputUtil.readINT((DataInput)in);
        String signature = in.readUTF();
        String name = in.readUTF();
        int annotationCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<TypeRepr.ClassType> annotations = new ArrayList<TypeRepr.ClassType>(annotationCount);
        for (int i = 0; i < annotationCount; ++i) {
            String annotationJvmName = in.readUTF();
            annotations.add(new TypeRepr.ClassType(annotationJvmName));
        }
        return new Proto(new JVMFlags(flags), signature, name, annotations);
    }

    static JVMClassNode readJvmClassNode(DataInput in) throws IOException {
        Proto proto = SerializerUtil.readProto(in);
        String outFilePath = in.readUTF();
        int usagesCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<Usage> usages = new ArrayList<Usage>(usagesCount);
        for (int i = 0; i < usagesCount; ++i) {
            Usage usage = SerializerUtil.readUsage(in);
            usages.add(usage);
        }
        return new JVMClassNode(proto.getFlags(), proto.getSignature(), proto.getName(), outFilePath, (Iterable)proto.getAnnotations(), usages){

            @Override
            public Difference difference(DiffCapable past) {
                return null;
            }
        };
    }

    static FieldAssignUsage readFieldAssignUsage(DataInput in) throws IOException {
        FieldUsage fieldUsage = SerializerUtil.readFieldUsage(in);
        return (FieldAssignUsage)fieldUsage;
    }

    static FieldUsage readFieldUsage(DataInput in) throws IOException {
        String refId = in.readUTF();
        String name = in.readUTF();
        String descriptor = in.readUTF();
        return new FieldUsage(refId, name, descriptor);
    }

    static JvmClass readJvmClass(DataInput in) throws IOException {
        JVMClassNode jvmClassNode = SerializerUtil.readJvmClassNode(in);
        String superFqName = in.readUTF();
        String outerFqName = in.readUTF();
        int interfacesCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<String> interfaces = new ArrayList<String>(interfacesCount);
        for (int i = 0; i < interfacesCount; ++i) {
            String myInterface = in.readUTF();
            interfaces.add(myInterface);
        }
        int fieldsCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<JvmField> fields = new ArrayList<JvmField>(fieldsCount);
        for (int i = 0; i < fieldsCount; ++i) {
            JvmField field = SerializerUtil.readJvmField(in);
            fields.add(field);
        }
        int methodCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<JvmMethod> methods = new ArrayList<JvmMethod>(methodCount);
        for (int i = 0; i < methodCount; ++i) {
            JvmMethod method = SerializerUtil.readJvmMethod(in);
            methods.add(method);
        }
        int elemTypeCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<ElemType> annotationTargets = new ArrayList<ElemType>(elemTypeCount);
        for (int i = 0; i < elemTypeCount; ++i) {
            ElemType elemType = SerializerUtil.readElemType(in);
            annotationTargets.add(elemType);
        }
        String retentionPolicyName = in.readUTF();
        RetentionPolicy retentionPolicy = retentionPolicyName.isEmpty() ? null : RetentionPolicy.valueOf(retentionPolicyName);
        return new JvmClass(jvmClassNode.getFlags(), jvmClassNode.getSignature(), jvmClassNode.getName(), jvmClassNode.getOutFilePath(), superFqName, outerFqName, interfaces, fields, methods, jvmClassNode.getAnnotations(), annotationTargets, retentionPolicy, jvmClassNode.getUsages());
    }

    static JvmMethod readJvmMethod(DataInput in) throws IOException {
        ProtoMember protoMember = SerializerUtil.readProtoMember(in);
        int argTypesCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<TypeRepr> argTypes = new ArrayList<TypeRepr>();
        for (int i = 0; i < argTypesCount; ++i) {
            argTypes.add(SerializerUtil.readTypeRepr(in));
        }
        int paramAnnotationsCount = DataInputOutputUtil.readINT((DataInput)in);
        HashSet<ParamAnnotation> paramAnnotations = new HashSet<ParamAnnotation>();
        for (int i = 0; i < paramAnnotationsCount; ++i) {
            int paramIndex = DataInputOutputUtil.readINT((DataInput)in);
            String typeName = in.readUTF();
            TypeRepr.ClassType paramType = new TypeRepr.ClassType(typeName);
            paramAnnotations.add(new ParamAnnotation(paramIndex, paramType));
        }
        int exceptionsCount = DataInputOutputUtil.readINT((DataInput)in);
        String[] exceptions = new String[exceptionsCount];
        for (int i = 0; i < exceptionsCount; ++i) {
            String exceptionName;
            exceptions[i] = exceptionName = in.readUTF();
        }
        String descriptor = in.readUTF();
        return new JvmMethod(protoMember.getFlags(), protoMember.getSignature(), protoMember.getName(), descriptor, protoMember.getAnnotations(), paramAnnotations, exceptions, protoMember.getValue());
    }

    private static String getJvmMethodDescr(Iterable<TypeRepr> myArgTypes, TypeRepr type) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (TypeRepr t : myArgTypes) {
            buf.append(t.getDescriptor());
        }
        buf.append(")");
        buf.append(type.getDescriptor());
        return buf.toString();
    }

    static JvmField readJvmField(DataInput in) throws IOException {
        ProtoMember protoMember = SerializerUtil.readProtoMember(in);
        return new JvmField(protoMember.getFlags(), protoMember.getSignature(), protoMember.getName(), protoMember.getType().getDescriptor(), protoMember.getAnnotations(), protoMember.getValue());
    }

    static ProtoMember readProtoMember(DataInput in) throws IOException {
        Proto proto = SerializerUtil.readProto(in);
        TypeRepr typeRepr = SerializerUtil.readTypeRepr(in);
        Object value = SerializerUtil.readValueObject(in);
        return new ProtoMember(proto.getFlags(), proto.getSignature(), proto.getName(), typeRepr, (Iterable)proto.getAnnotations(), value){

            @Override
            public MemberUsage createUsage(String owner) {
                return null;
            }
        };
    }

    static TypeRepr readTypeRepr(DataInput in) throws IOException {
        String typeReprName;
        switch (typeReprName = in.readUTF()) {
            case "PrimitiveType": {
                String descriptor = in.readUTF();
                return new TypeRepr.PrimitiveType(descriptor);
            }
            case "ClassType": {
                String jvmName = in.readUTF();
                return new TypeRepr.ClassType(jvmName);
            }
            case "ArrayType": {
                String arrayDescriptor = in.readUTF();
                return new TypeRepr.ArrayType(TypeRepr.getType(arrayDescriptor));
            }
        }
        throw new SerializationException("Serialization error: Unexpected type for 'TypeRepr': " + typeReprName);
    }

    static Object readValueObject(DataInput in) {
        try {
            byte tag = in.readByte();
            if (tag < 0) {
                int length = DataInputOutputUtil.readINT((DataInput)in);
                DataDescriptor descriptor = DataDescriptor.findById(-tag);
                Object array = Array.newInstance(descriptor.getDataType(), length);
                for (int idx = 0; idx < length; ++idx) {
                    Array.set(array, idx, descriptor.load(in));
                }
                return array;
            }
            return DataDescriptor.findById(tag).load(in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    static MethodUsage readMethodUsage(DataInput in) throws IOException {
        String className = in.readUTF();
        String name = in.readUTF();
        String descriptor = in.readUTF();
        return new MethodUsage(className, name, descriptor);
    }

    static ImportStaticMemberUsage readImportStaticMemberUsage(DataInput in) throws IOException {
        String className = in.readUTF();
        String name = in.readUTF();
        return new ImportStaticMemberUsage(className, name);
    }

    static ClassUsage readClassUsage(DataInput in) throws IOException {
        String className = in.readUTF();
        return new ClassUsage(className);
    }

    static ModuleUsage readModuleUsage(DataInput in) throws IOException {
        String moduleName = in.readUTF();
        return new ModuleUsage(moduleName);
    }

    static ImportStaticOnDemandUsage readImportStaticOnDemandUsage(DataInput in) throws IOException {
        String importedClassName = in.readUTF();
        return new ImportStaticOnDemandUsage(importedClassName);
    }

    static AnnotationUsage readAnnotationUsage(DataInput in) throws IOException {
        String classTypeJvmName = in.readUTF();
        int userArgNamesCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<String> userArgNames = new ArrayList<String>(userArgNamesCount);
        for (int i = 0; i < userArgNamesCount; ++i) {
            String userArgName = in.readUTF();
            userArgNames.add(userArgName);
        }
        int targetsCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<ElemType> targets = new ArrayList<ElemType>(targetsCount);
        for (int i = 0; i < targetsCount; ++i) {
            ElemType elemType = SerializerUtil.readElemType(in);
            targets.add(elemType);
        }
        return new AnnotationUsage(new TypeRepr.ClassType(classTypeJvmName), userArgNames, targets);
    }

    static ElemType readElemType(DataInput in) throws IOException {
        String elemTypeName = in.readUTF();
        return ElemType.valueOf(elemTypeName);
    }

    static ClassAsGenericBoundUsage readClassAsGenericBoundUsage(DataInput in) throws IOException {
        return new ClassAsGenericBoundUsage(SerializerUtil.readClassUsage(in).getClassName());
    }

    static ClassExtendsUsage readClassExtendsUsage(DataInput in) throws IOException {
        return new ClassExtendsUsage(SerializerUtil.readClassUsage(in).getClassName());
    }

    static ClassNewUsage readClassNewUsage(DataInput in) throws IOException {
        return new ClassNewUsage(SerializerUtil.readClassUsage(in).getClassName());
    }

    static Usage readUsage(DataInput in) throws IOException {
        String usageClassName;
        switch (usageClassName = in.readUTF()) {
            case "FieldAssignUsage": {
                return SerializerUtil.readFieldAssignUsage(in);
            }
            case "FieldUsage": {
                return SerializerUtil.readFieldUsage(in);
            }
            case "MethodUsage": {
                return SerializerUtil.readMethodUsage(in);
            }
            case "ImportStaticMemberUsage": {
                return SerializerUtil.readImportStaticMemberUsage(in);
            }
            case "ClassAsGenericBoundUsage": {
                return SerializerUtil.readClassAsGenericBoundUsage(in);
            }
            case "ClassExtendsUsage": {
                return SerializerUtil.readClassExtendsUsage(in);
            }
            case "ClassNewUsage": {
                return SerializerUtil.readClassNewUsage(in);
            }
            case "ClassUsage": {
                return SerializerUtil.readClassUsage(in);
            }
            case "AnnotationUsage": {
                return SerializerUtil.readAnnotationUsage(in);
            }
            case "ModuleUsage": {
                return SerializerUtil.readModuleUsage(in);
            }
            case "ImportStaticOnDemandUsage": {
                return SerializerUtil.readImportStaticOnDemandUsage(in);
            }
        }
        throw new SerializationException("Unknown Usage class: " + usageClassName);
    }

    static void writeJvmModule(JvmModule jvmModule, DataOutput out) throws IOException {
        SerializerUtil.writeJVMClassNode(jvmModule, out);
        out.writeUTF(jvmModule.getVersion());
        int requiresCount = 0;
        for (ModuleRequires moduleRequires : jvmModule.getRequires()) {
            ++requiresCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)requiresCount);
        for (ModuleRequires moduleRequires : jvmModule.getRequires()) {
            SerializerUtil.writeProto(moduleRequires, out);
            out.writeUTF(moduleRequires.getVersion());
        }
        int exportsCount = 0;
        for (ModulePackage export : jvmModule.getExports()) {
            ++exportsCount;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)exportsCount);
        for (ModulePackage export : jvmModule.getExports()) {
            SerializerUtil.writeProto(export, out);
            int modulesCount = 0;
            for (String module : export.getModules()) {
                ++modulesCount;
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)modulesCount);
            for (String module : export.getModules()) {
                out.writeUTF(module);
            }
        }
    }

    static JvmModule readJvmModule(DataInput in) throws IOException {
        JVMClassNode jvmClassNode = SerializerUtil.readJvmClassNode(in);
        String version = in.readUTF();
        int requiresCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<ModuleRequires> requiresList = new ArrayList<ModuleRequires>();
        for (int i = 0; i < requiresCount; ++i) {
            Proto proto = SerializerUtil.readProto(in);
            String moduleVersion = in.readUTF();
            requiresList.add(new ModuleRequires(proto.getFlags(), proto.getName(), moduleVersion));
        }
        int exportsCount = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<ModulePackage> exportsList = new ArrayList<ModulePackage>();
        for (int i = 0; i < exportsCount; ++i) {
            Proto proto = SerializerUtil.readProto(in);
            int modulesCount = DataInputOutputUtil.readINT((DataInput)in);
            ArrayList<String> modulesList = new ArrayList<String>();
            for (int j = 0; j < modulesCount; ++j) {
                String module = in.readUTF();
                modulesList.add(module);
            }
            exportsList.add(new ModulePackage(proto.getName(), modulesList));
        }
        return new JvmModule(jvmClassNode.getFlags(), jvmClassNode.getName(), jvmClassNode.getOutFilePath(), version, requiresList, exportsList, jvmClassNode.getUsages());
    }

    private static abstract class DataDescriptor<T> {
        public static final DataDescriptor NONE = new DataDescriptor(0, null){

            public Object load(DataInput out) {
                return null;
            }

            public void save(DataOutput out, Object value) {
            }
        };
        public static final DataDescriptor<String> STRING = new DataDescriptor<String>(1, String.class){

            @Override
            public String load(DataInput in) throws IOException {
                return in.readUTF();
            }

            @Override
            public void save(DataOutput out, String value) throws IOException {
                out.writeUTF(value);
            }
        };
        public static final DataDescriptor<Integer> INTEGER = new DataDescriptor<Integer>(2, Integer.class){

            @Override
            public Integer load(DataInput in) throws IOException {
                return DataInputOutputUtil.readINT((DataInput)in);
            }

            @Override
            public void save(DataOutput out, Integer value) throws IOException {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
            }
        };
        public static final DataDescriptor<Long> LONG = new DataDescriptor<Long>(3, Long.class){

            @Override
            public Long load(DataInput in) throws IOException {
                return in.readLong();
            }

            @Override
            public void save(DataOutput out, Long value) throws IOException {
                out.writeLong(value);
            }
        };
        public static final DataDescriptor<Float> FLOAT = new DataDescriptor<Float>(4, Float.class){

            @Override
            public Float load(DataInput in) throws IOException {
                return Float.valueOf(in.readFloat());
            }

            @Override
            public void save(DataOutput out, Float value) throws IOException {
                out.writeFloat(value.floatValue());
            }
        };
        public static final DataDescriptor<Double> DOUBLE = new DataDescriptor<Double>(5, Double.class){

            @Override
            public Double load(DataInput in) throws IOException {
                return in.readDouble();
            }

            @Override
            public void save(DataOutput out, Double value) throws IOException {
                out.writeDouble(value);
            }
        };
        public static final DataDescriptor<Type> TYPE = new DataDescriptor<Type>(6, Type.class){

            @Override
            public Type load(DataInput in) throws IOException {
                return Type.getType((String)in.readUTF());
            }

            @Override
            public void save(DataOutput out, Type value) throws IOException {
                out.writeUTF(value.getDescriptor());
            }
        };
        private final byte myId;
        @Nullable
        private final Class<T> myDataType;

        private DataDescriptor(int id, Class<T> dataType) {
            this.myId = (byte)id;
            this.myDataType = dataType;
        }

        public byte getId() {
            return this.myId;
        }

        @Nullable
        public Class<T> getDataType() {
            return this.myDataType;
        }

        public abstract void save(DataOutput var1, T var2) throws IOException;

        public abstract T load(DataInput var1) throws IOException;

        @NotNull
        public static DataDescriptor findById(byte tag) {
            if (STRING.getId() == tag) {
                DataDescriptor<String> dataDescriptor = STRING;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(0);
                }
                return dataDescriptor;
            }
            if (INTEGER.getId() == tag) {
                DataDescriptor<Integer> dataDescriptor = INTEGER;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(1);
                }
                return dataDescriptor;
            }
            if (LONG.getId() == tag) {
                DataDescriptor<Long> dataDescriptor = LONG;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(2);
                }
                return dataDescriptor;
            }
            if (FLOAT.getId() == tag) {
                DataDescriptor<Float> dataDescriptor = FLOAT;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(3);
                }
                return dataDescriptor;
            }
            if (DOUBLE.getId() == tag) {
                DataDescriptor<Double> dataDescriptor = DOUBLE;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(4);
                }
                return dataDescriptor;
            }
            if (TYPE.getId() == tag) {
                DataDescriptor<Type> dataDescriptor = TYPE;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(5);
                }
                return dataDescriptor;
            }
            if (NONE.getId() == tag) {
                DataDescriptor dataDescriptor = NONE;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(6);
                }
                return dataDescriptor;
            }
            assert (false) : "Unknown descriptor tag: " + tag;
            DataDescriptor dataDescriptor = NONE;
            if (dataDescriptor == null) {
                DataDescriptor.$$$reportNull$$$0(7);
            }
            return dataDescriptor;
        }

        public static DataDescriptor findByValueType(@Nullable Class<?> dataType) {
            if (dataType != null) {
                if (dataType.equals(STRING.getDataType())) {
                    return STRING;
                }
                if (dataType.equals(INTEGER.getDataType())) {
                    return INTEGER;
                }
                if (dataType.equals(LONG.getDataType())) {
                    return LONG;
                }
                if (dataType.equals(FLOAT.getDataType())) {
                    return FLOAT;
                }
                if (dataType.equals(DOUBLE.getDataType())) {
                    return DOUBLE;
                }
                if (TYPE.getDataType().isAssignableFrom(dataType)) {
                    return TYPE;
                }
            }
            return NONE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/dependency/impl/serializer/SerializerUtil$DataDescriptor", "findById"));
        }
    }
}

