/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;

public final class BuildTargetTypeState {
    private static final int VERSION = 1;
    private static final Logger LOG = Logger.getInstance(BuildTargetTypeState.class);
    private final Map<BuildTarget<?>, Integer> myTargetIds;
    private final List<Pair<String, Integer>> myStaleTargetIds;
    private final ConcurrentMap<BuildTarget<?>, BuildTargetConfiguration> myConfigurations;
    private final BuildTargetType<?> myTargetType;
    private final BuildTargetsState myTargetsState;
    private final File myTargetsFile;
    private volatile long myAverageTargetBuildTimeMs = -1L;

    public BuildTargetTypeState(BuildTargetType<?> targetType, BuildTargetsState state) {
        this.myTargetType = targetType;
        this.myTargetsState = state;
        this.myTargetsFile = new File(state.getDataPaths().getTargetTypeDataRoot(targetType), "targets.dat");
        this.myConfigurations = new ConcurrentHashMap(16, 0.75f, 1);
        this.myTargetIds = new HashMap();
        this.myStaleTargetIds = new ArrayList<Pair<String, Integer>>();
        this.load();
    }

    private boolean load() {
        boolean bl;
        if (!this.myTargetsFile.exists()) {
            return false;
        }
        DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myTargetsFile)));
        try {
            int version = input.readInt();
            int size = input.readInt();
            BuildTargetLoader<?> loader = this.myTargetType.createLoader(this.myTargetsState.getModel());
            while (size-- > 0) {
                String stringId = IOUtil.readString((DataInput)input);
                int intId = input.readInt();
                this.myTargetsState.markUsedId(intId);
                Object target = loader.createTarget(stringId);
                if (target != null) {
                    this.myTargetIds.put((BuildTarget<?>)target, intId);
                    continue;
                }
                this.myStaleTargetIds.add((Pair<String, Integer>)Pair.create((Object)stringId, (Object)intId));
            }
            if (version >= 1) {
                this.myAverageTargetBuildTimeMs = input.readLong();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.info("Cannot load " + this.myTargetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        input.close();
        return bl;
    }

    public synchronized void save() {
        FileUtil.createParentDirs((File)this.myTargetsFile);
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.myTargetsFile)));){
            output.writeInt(1);
            output.writeInt(this.myTargetIds.size() + this.myStaleTargetIds.size());
            for (Map.Entry<BuildTarget<?>, Integer> entry : this.myTargetIds.entrySet()) {
                IOUtil.writeString((String)entry.getKey().getId(), (DataOutput)output);
                output.writeInt(entry.getValue());
            }
            for (Pair pair : this.myStaleTargetIds) {
                IOUtil.writeString((String)((String)pair.first), (DataOutput)output);
                output.writeInt((Integer)pair.second);
            }
            output.writeLong(this.myAverageTargetBuildTimeMs);
        }
        catch (IOException e) {
            LOG.info("Cannot save " + this.myTargetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized List<Pair<String, Integer>> getStaleTargetIds() {
        return new ArrayList<Pair<String, Integer>>(this.myStaleTargetIds);
    }

    public synchronized void removeStaleTarget(String targetId) {
        this.myStaleTargetIds.removeIf(pair -> ((String)pair.first).equals(targetId));
    }

    public synchronized int getTargetId(BuildTarget<?> target) {
        if (!this.myTargetIds.containsKey(target)) {
            this.myTargetIds.put(target, this.myTargetsState.getFreeId());
        }
        return this.myTargetIds.get(target);
    }

    public void setAverageTargetBuildTime(long timeInMs) {
        this.myAverageTargetBuildTimeMs = timeInMs;
    }

    public long getAverageTargetBuildTime() {
        return this.myAverageTargetBuildTimeMs;
    }

    public BuildTargetConfiguration getConfiguration(BuildTarget<?> target) {
        BuildTargetConfiguration existing;
        BuildTargetConfiguration configuration = (BuildTargetConfiguration)this.myConfigurations.get(target);
        if (configuration == null && (existing = this.myConfigurations.putIfAbsent(target, configuration = new BuildTargetConfiguration(target, this.myTargetsState))) != null) {
            configuration = existing;
        }
        return configuration;
    }
}

