/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie;

import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.GrazieRemote;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.Languages;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cH\u0002J2\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0016\b\u0004\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0!H\u0082\b\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020'J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020%0\u001c2\u0006\u0010&\u001a\u00020'J\u0014\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u0001012\u0006\u00102\u001a\u00020'J\u0010\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u000206R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR+\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00050\rj\b\u0012\u0004\u0012\u00020\u0005`\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00067"}, d2={"Lcom/intellij/grazie/GrazieDynamic;", "Lcom/intellij/ide/plugins/DynamicPluginListener;", "()V", "dynClassLoaders", "", "Ljava/lang/ClassLoader;", "getDynClassLoaders", "()Ljava/util/Set;", "dynamicFolder", "Ljava/nio/file/Path;", "getDynamicFolder", "()Ljava/nio/file/Path;", "myDynClassLoaders", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getMyDynClassLoaders", "()Ljava/util/HashSet;", "myDynClassLoaders$delegate", "Lkotlin/Lazy;", "addDynClassLoader", "", "classLoader", "beforePluginUnload", "", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "isUpdate", "collectValidLocalBundles", "", "forClassLoader", "T", "", "body", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getDynamicFolderPath", "getResource", "Ljava/net/URL;", "path", "", "getResourceAsStream", "Ljava/io/InputStream;", "getResourceBundle", "Ljava/util/ResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "getResources", "loadClass", "Ljava/lang/Class;", "className", "loadLang", "Lorg/languagetool/Language;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "intellij.grazie.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGrazieDynamic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieDynamic.kt\ncom/intellij/grazie/GrazieDynamic\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n140#1,5:150\n140#1,5:155\n140#1,5:160\n140#1,5:165\n140#1,5:170\n8#2:148\n1#3:149\n*S KotlinDebug\n*F\n+ 1 GrazieDynamic.kt\ncom/intellij/grazie/GrazieDynamic\n*L\n104#1:150,5\n115#1:155,5\n119#1:160,5\n123#1:165,5\n129#1:170,5\n53#1:148\n*E\n"})
public final class GrazieDynamic
implements DynamicPluginListener {
    @NotNull
    public static final GrazieDynamic INSTANCE = new GrazieDynamic();
    @NotNull
    private static final Lazy myDynClassLoaders$delegate = LazyKt.lazy((Function0)myDynClassLoaders.2.INSTANCE);

    private GrazieDynamic() {
    }

    private final HashSet<ClassLoader> getMyDynClassLoaders() {
        Lazy lazy = myDynClassLoaders$delegate;
        return (HashSet)lazy.getValue();
    }

    private final List<Path> collectValidLocalBundles() {
        Set set;
        List<Lang> languages2 = GrazieRemote.INSTANCE.allAvailableLocally();
        Set $this$collectValidLocalBundles_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (Lang language : languages2) {
            Path path = language.getRemote().getFile();
            if (language.isEnglish() || GrazieRemote.INSTANCE.isValidBundleForLanguage(language, path)) {
                $this$collectValidLocalBundles_u24lambda_u240.add(path);
                continue;
            }
            Set $this$thisLogger$iv = $this$collectValidLocalBundles_u24lambda_u240;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Set.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(StringsKt.trimIndent((String)("\n          Skipping local bundle " + path + " for language " + language.getNativeName() + ". \n          Failed to verify integrity of local language bundle before adding it to class loader.\n          ")));
        }
        Set bundles = SetsKt.build((Set)set);
        return CollectionsKt.toList((Iterable)bundles);
    }

    public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        PluginId pluginId = pluginDescriptor.getPluginId();
        if (Intrinsics.areEqual((Object)(pluginId != null ? pluginId.getIdString() : null), (Object)"tanvd.grazi")) {
            this.getMyDynClassLoaders().clear();
        }
    }

    public final boolean addDynClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.getMyDynClassLoaders().add(classLoader);
    }

    private final Set<ClassLoader> getDynClassLoaders() {
        return CollectionsKt.toSet((Iterable)this.getMyDynClassLoaders());
    }

    private final Path getDynamicFolderPath() {
        String customFolder = System.getProperty("grazie.dynamic.customJarDirectory");
        if (customFolder != null) {
            Path path = Path.of(customFolder, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }
        String[] stringArray = new String[]{"grazie"};
        Path path = Paths.get(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path getDynamicFolder() {
        Path result2 = this.getDynamicFolderPath();
        Files.createDirectories(result2, new FileAttribute[0]);
        return result2;
    }

    @Nullable
    public final Language loadLang(@NotNull Lang lang) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            for (String className : lang.getRemote().getLangsClasses()) {
                try {
                    Languages.getOrAddLanguageByClassName("org.languagetool.language." + className);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ClassNotFoundException) continue;
                    throw e;
                }
            }
            List<Language> list = Languages.get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Language it = (Language)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)lang.getClassName())) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final Class<?> loadClass(@NotNull String className) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        try {
            clazz = Class.forName(className, true, it);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        Class<?> clazz2 = clazz;
        Object object = clazz2;
        if (clazz2 == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)new Function1<ClassLoader, Class<?>>(className){
                final /* synthetic */ String $className$inlined;
                {
                    this.$className$inlined = string2;
                    super(1);
                }

                @Nullable
                public final Class<?> invoke(@NotNull ClassLoader it) {
                    Class<?> clazz;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    try {
                        clazz = Class.forName(this.$className$inlined, true, it2);
                    }
                    catch (ClassNotFoundException e) {
                        clazz = null;
                    }
                    return clazz;
                }
            }));
        }
        return object;
    }

    @Nullable
    public final InputStream getResourceAsStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        Object object = it.getResourceAsStream(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        if (object == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, InputStream>(path){
                final /* synthetic */ String $path$inlined;
                {
                    this.$path$inlined = string2;
                    super(1);
                }

                @Nullable
                public final InputStream invoke(@NotNull ClassLoader it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    return it2.getResourceAsStream(StringsKt.removePrefix((String)this.$path$inlined, (CharSequence)"/"));
                }
            })));
        }
        return object;
    }

    @Nullable
    public final URL getResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        Object object = it.getResource(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        if (object == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, URL>(path){
                final /* synthetic */ String $path$inlined;
                {
                    this.$path$inlined = string2;
                    super(1);
                }

                @Nullable
                public final URL invoke(@NotNull ClassLoader it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    return it2.getResource(StringsKt.removePrefix((String)this.$path$inlined, (CharSequence)"/"));
                }
            })));
        }
        return object;
    }

    @NotNull
    public final List<URL> getResources(@NotNull String path) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader loader = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        Enumeration<URL> enumeration = loader.getResources(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        List it = list = (List)arrayList;
        boolean bl2 = false;
        List list2 = !((Collection)it).isEmpty() ? list : null;
        Object object = list2;
        if (list2 == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, List<? extends URL>>(path){
                final /* synthetic */ String $path$inlined;
                {
                    this.$path$inlined = string2;
                    super(1);
                }

                @Nullable
                public final List<? extends URL> invoke(@NotNull ClassLoader it) {
                    List<E> list;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader loader = it;
                    boolean bl = false;
                    Enumeration<URL> enumeration = loader.getResources(StringsKt.removePrefix((String)this.$path$inlined, (CharSequence)"/"));
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
                    ArrayList<URL> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    List<E> it2 = list = (List<E>)arrayList;
                    boolean bl2 = false;
                    return !((Collection)it2).isEmpty() ? list : null;
                }
            })));
        }
        List list3 = object;
        if (object == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        ResourceBundle resourceBundle;
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        try {
            ResourceBundle bundle = resourceBundle = ResourceBundle.getBundle(baseName, locale, it);
            boolean bl2 = false;
            resourceBundle = Intrinsics.areEqual((Object)bundle.getLocale().getLanguage(), (Object)locale.getLanguage()) ? resourceBundle : null;
        }
        catch (MissingResourceException e) {
            resourceBundle = null;
        }
        ResourceBundle resourceBundle2 = resourceBundle;
        Object object = resourceBundle2;
        if (resourceBundle2 == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, ResourceBundle>(baseName, locale){
                final /* synthetic */ String $baseName$inlined;
                final /* synthetic */ Locale $locale$inlined;
                {
                    this.$baseName$inlined = string2;
                    this.$locale$inlined = locale;
                    super(1);
                }

                @Nullable
                public final ResourceBundle invoke(@NotNull ClassLoader it) {
                    ResourceBundle resourceBundle;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    try {
                        ResourceBundle bundle = resourceBundle = ResourceBundle.getBundle(this.$baseName$inlined, this.$locale$inlined, it2);
                        boolean bl2 = false;
                        resourceBundle = Intrinsics.areEqual((Object)bundle.getLocale().getLanguage(), (Object)this.$locale$inlined.getLanguage()) ? resourceBundle : null;
                    }
                    catch (MissingResourceException e) {
                        resourceBundle = null;
                    }
                    return resourceBundle;
                }
            })));
        }
        if (object == null) {
            throw new MissingResourceException("Missing resource bundle for " + baseName + " with locale " + locale, INSTANCE.getClass().getName(), baseName);
        }
        return object;
    }

    private final <T> T forClassLoader(Function1<? super ClassLoader, ? extends T> body) {
        boolean $i$f$forClassLoader = false;
        Object object = body.invoke((Object)GraziePlugin.INSTANCE.getClassLoader());
        if (object == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getDynClassLoaders()), (Function1)new Function1<ClassLoader, T>(body){
                final /* synthetic */ Function1<ClassLoader, T> $body;
                {
                    this.$body = $body;
                    super(1);
                }

                @Nullable
                public final T invoke(@NotNull ClassLoader it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (T)this.$body.invoke((Object)it);
                }
            }));
        }
        return (T)object;
    }

    public static final /* synthetic */ List access$collectValidLocalBundles(GrazieDynamic $this) {
        return $this.collectValidLocalBundles();
    }
}

