/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver;", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "()V", "resolveImplementationClass", "Ljava/lang/Class;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "adapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "intellij.platform.extensions"})
public final class InterfaceExtensionImplementationClassResolver
implements ImplementationClassResolver {
    @NotNull
    public static final InterfaceExtensionImplementationClassResolver INSTANCE = new InterfaceExtensionImplementationClassResolver();

    private InterfaceExtensionImplementationClassResolver() {
    }

    @Override
    @NotNull
    public Class<?> resolveImplementationClass(@NotNull ComponentManager componentManager, @NotNull ExtensionComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Object className = adapter.implementationClassOrName;
        if (!(className instanceof String)) {
            Intrinsics.checkNotNull((Object)className, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            return (Class)className;
        }
        PluginDescriptor pluginDescriptor = adapter.pluginDescriptor;
        Class clazz = componentManager.loadClass((String)className, pluginDescriptor);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
        Class result = clazz;
        if (!(result.getClassLoader() == pluginDescriptor.getPluginClassLoader() || pluginDescriptor.getPluginClassLoader() == null || StringsKt.startsWith$default((String)((String)className), (String)"com.intellij.webcore.resourceRoots.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((String)className), (String)"com.intellij.tasks.impl.", (boolean)false, (int)2, null) || result.isAnnotationPresent(InternalIgnoreDependencyViolation.class))) {
            String string = pluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
            String idString = string;
            if (!(Intrinsics.areEqual((Object)idString, (Object)"com.intellij.java") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.java.ide") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.java.frontend") || Intrinsics.areEqual((Object)idString, (Object)"org.jetbrains.android") || Intrinsics.areEqual((Object)idString, (Object)"com.intellij.kotlinNative.platformDeps") || Intrinsics.areEqual((Object)idString, (Object)"com.jetbrains.rider.android"))) {
                ExtensionPointImpl.LOG.error((Throwable)componentManager.createError("Created extension classloader is not equal to plugin's one.\nSee https://youtrack.jetbrains.com/articles/IDEA-A-65/Plugin-Model#internalignoredependencyviolation\n(\n  className=" + className + ",\n  extensionInstanceClassloader=" + result.getClassLoader() + ",\n  pluginClassloader=" + pluginDescriptor.getPluginClassLoader() + "\n)", pluginDescriptor.getPluginId()));
            }
        }
        adapter.implementationClassOrName = result;
        return result;
    }
}

