/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.WinPty;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

public class NamedPipe {
    private WinNT.HANDLE myHandle;
    boolean myCloseHandleOnFinalize;
    private WinNT.HANDLE shutdownEvent;
    private volatile boolean shutdownFlag = false;
    private volatile boolean myFinalizedFlag = false;
    private ReentrantLock readLock = new ReentrantLock();
    private ReentrantLock writeLock = new ReentrantLock();
    private Memory readBuffer = new Memory(16384L);
    private Memory writeBuffer = new Memory(16384L);
    private WinNT.HANDLE readEvent;
    private WinNT.HANDLE writeEvent;
    private WinNT.HANDLE[] readWaitHandles;
    private WinNT.HANDLE[] writeWaitHandles;
    private IntByReference readActual = new IntByReference();
    private IntByReference writeActual = new IntByReference();
    private IntByReference peekActual = new IntByReference();
    private WinBase.OVERLAPPED readOver = new WinBase.OVERLAPPED();
    private WinBase.OVERLAPPED writeOver = new WinBase.OVERLAPPED();

    public NamedPipe(WinNT.HANDLE handle, boolean closeHandleOnFinalize) {
        this.myHandle = handle;
        this.myCloseHandleOnFinalize = closeHandleOnFinalize;
        this.shutdownEvent = Kernel32.INSTANCE.CreateEvent(null, true, false, null);
        this.readEvent = Kernel32.INSTANCE.CreateEvent(null, true, false, null);
        this.writeEvent = Kernel32.INSTANCE.CreateEvent(null, true, false, null);
        this.readWaitHandles = new WinNT.HANDLE[]{this.readEvent, this.shutdownEvent};
        this.writeWaitHandles = new WinNT.HANDLE[]{this.writeEvent, this.shutdownEvent};
    }

    public static NamedPipe connectToServer(String name, int desiredAccess) throws IOException {
        WinNT.HANDLE handle = Kernel32.INSTANCE.CreateFile(name, desiredAccess, 0, null, 3, 0, null);
        if (handle == WinBase.INVALID_HANDLE_VALUE) {
            throw new IOException("Error connecting to pipe '" + name + "': " + Native.getLastError());
        }
        return new NamedPipe(handle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.readLock.lock();
        try {
            if (this.shutdownFlag) {
                int n = -1;
                return n;
            }
            if (len == 0) {
                int n = 0;
                return n;
            }
            if (this.readBuffer.size() < (long)len) {
                this.readBuffer = new Memory((long)len);
            }
            this.readOver.hEvent = this.readEvent;
            this.readOver.write();
            this.readActual.setValue(0);
            boolean success = WinPty.KERNEL32.ReadFile(this.myHandle, (Pointer)this.readBuffer, len, this.readActual, this.readOver.getPointer());
            if (!success && Native.getLastError() == 997) {
                int waitRet = Kernel32.INSTANCE.WaitForMultipleObjects(this.readWaitHandles.length, this.readWaitHandles, false, -1);
                if (waitRet != 0) {
                    WinPty.KERNEL32.CancelIo(this.myHandle);
                }
                success = WinPty.KERNEL32.GetOverlappedResult(this.myHandle, this.readOver.getPointer(), this.readActual, true);
            }
            int actual = this.readActual.getValue();
            if (!success || actual <= 0) {
                int n = -1;
                return n;
            }
            this.readBuffer.read(0L, buf, off, actual);
            int n = actual;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.writeLock.lock();
        try {
            if (this.shutdownFlag) {
                return;
            }
            if (len == 0) {
                return;
            }
            if (this.writeBuffer.size() < (long)len) {
                this.writeBuffer = new Memory((long)len);
            }
            this.writeBuffer.write(0L, buf, off, len);
            this.writeOver.hEvent = this.writeEvent;
            this.writeOver.write();
            this.writeActual.setValue(0);
            boolean success = WinPty.KERNEL32.WriteFile(this.myHandle, (Pointer)this.writeBuffer, len, this.writeActual, this.writeOver.getPointer());
            if (!success && Native.getLastError() == 997) {
                int waitRet = Kernel32.INSTANCE.WaitForMultipleObjects(this.writeWaitHandles.length, this.writeWaitHandles, false, -1);
                if (waitRet != 0) {
                    WinPty.KERNEL32.CancelIo(this.myHandle);
                }
                WinPty.KERNEL32.GetOverlappedResult(this.myHandle, this.writeOver.getPointer(), this.writeActual, true);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int available() throws IOException {
        this.readLock.lock();
        try {
            if (this.shutdownFlag) {
                int n = -1;
                return n;
            }
            this.peekActual.setValue(0);
            if (!WinPty.KERNEL32.PeekNamedPipe(this.myHandle, null, 0, null, this.peekActual, null)) {
                throw new IOException("PeekNamedPipe failed");
            }
            int n = this.peekActual.getValue();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public synchronized void markClosed() {
        this.closeImpl();
    }

    public synchronized void close() throws IOException {
        if (!this.closeImpl()) {
            return;
        }
        if (!Kernel32.INSTANCE.CloseHandle(this.myHandle)) {
            throw new IOException("Close error:" + Native.getLastError());
        }
    }

    private synchronized boolean closeImpl() {
        if (this.shutdownFlag) {
            return false;
        }
        this.shutdownFlag = true;
        Kernel32.INSTANCE.SetEvent(this.shutdownEvent);
        if (!this.myFinalizedFlag) {
            this.readLock.lock();
            this.writeLock.lock();
            this.writeLock.unlock();
            this.readLock.unlock();
        }
        Kernel32.INSTANCE.CloseHandle(this.shutdownEvent);
        Kernel32.INSTANCE.CloseHandle(this.readEvent);
        Kernel32.INSTANCE.CloseHandle(this.writeEvent);
        return true;
    }

    protected synchronized void finalize() throws Throwable {
        this.myFinalizedFlag = true;
        if (this.myCloseHandleOnFinalize) {
            this.close();
        }
        super.finalize();
    }
}

