/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.List;
import java.util.Objects;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class AnnotationExprent
extends Exprent {
    public static final int ANNOTATION_NORMAL = 1;
    public static final int ANNOTATION_MARKER = 2;
    public static final int ANNOTATION_SINGLE_ELEMENT = 3;
    private final String className;
    private final List<String> parNames;
    private final List<? extends Exprent> parValues;

    public AnnotationExprent(String className, List<String> parNames, List<? extends Exprent> parValues) {
        super(13);
        this.className = className;
        this.parNames = parNames;
        this.parValues = parValues;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buffer = new TextBuffer();
        buffer.appendIndent(indent);
        buffer.append('@');
        buffer.append(DecompilerContext.getImportCollector().getNestedName(ExprProcessor.buildJavaClassName(this.className)));
        int type = this.getAnnotationType();
        if (type != 2) {
            buffer.append('(');
            boolean oneLiner = type == 3 || indent < 0;
            for (int i = 0; i < this.parNames.size(); ++i) {
                if (!oneLiner) {
                    buffer.appendLineSeparator().appendIndent(indent + 1);
                }
                if (type != 3) {
                    buffer.append(this.parNames.get(i));
                    buffer.append(" = ");
                }
                buffer.append(this.parValues.get(i).toJava(0, tracer));
                if (i >= this.parNames.size() - 1) continue;
                buffer.append(',');
            }
            if (!oneLiner) {
                buffer.appendLineSeparator().appendIndent(indent);
            }
            buffer.append(')');
        }
        return buffer;
    }

    public String getClassName() {
        return this.className;
    }

    public int getAnnotationType() {
        if (this.parNames.isEmpty()) {
            return 2;
        }
        if (this.parNames.size() == 1 && "value".equals(this.parNames.get(0))) {
            return 3;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.parNames, this.parValues);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationExprent)) {
            return false;
        }
        AnnotationExprent ann = (AnnotationExprent)o;
        return this.className.equals(ann.className) && this.parNames.equals(ann.parNames) && this.parValues.equals(ann.parValues);
    }
}

