/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J0\u0010\r\u001a\u00020\u00072\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\r\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J0\u0010\u0015\u001a\u00020\u00072\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\u0016\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0004\u0012\u00020\u00130\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J0\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001dH\u0002J&\u0010\u001e\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/perforce/actions/ShelfUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "browseShelf", "", "project", "Lcom/intellij/openapi/project/Project;", "shelvedChanges", "", "Lorg/jetbrains/idea/perforce/application/ShelvedChange;", "deleteFromShelf", "paths", "Lcom/intellij/util/containers/MultiMap;", "Lkotlin/Pair;", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "", "", "changes", "doUnshelve", "groupByChangeList", "selected", "handleUnshelveException", "connection", "unshelveException", "Lcom/intellij/openapi/vcs/VcsException;", "specs", "", "unshelveChanges", "delete", "", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nShelfUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShelfUtils.kt\norg/jetbrains/idea/perforce/actions/ShelfUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,165:1\n1549#2:166\n1620#2,3:167\n1603#2,9:170\n1855#2:179\n1856#2:182\n1612#2:183\n1855#2,2:184\n1549#2:188\n1620#2,3:189\n1#3:180\n1#3:181\n37#4,2:186\n*S KotlinDebug\n*F\n+ 1 ShelfUtils.kt\norg/jetbrains/idea/perforce/actions/ShelfUtils\n*L\n34#1:166\n34#1:167,3\n96#1:170,9\n96#1:179\n96#1:182\n96#1:183\n98#1:184,2\n67#1:188\n67#1:189,3\n96#1:181\n137#1:186,2\n*E\n"})
public final class ShelfUtils {
    @NotNull
    public static final ShelfUtils INSTANCE = new ShelfUtils();
    @NotNull
    private static final Logger LOG;

    private ShelfUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void browseShelf(@NotNull Project project, @NotNull List<? extends ShelvedChange> shelvedChanges) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(shelvedChanges, (String)"shelvedChanges");
        Iterable $this$map$iv = shelvedChanges;
        boolean $i$f$map = false;
        DialogBuilder.ActionDescriptor[] actionDescriptorArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShelvedChange shelvedChange = (ShelvedChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toIdeaChange(project));
        }
        List changes = (List)destination$iv$iv;
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        SimpleChangesBrowser browser = new SimpleChangesBrowser(project, true, false);
        browser.setInclusionChangedListener(() -> ShelfUtils.browseShelf$lambda$1(dialogBuilder, browser));
        browser.setChangesToDisplay((Collection)changes);
        browser.setIncludedChanges((Collection)changes);
        actionDescriptorArray = PerforceBundle.messagePointer("shelf.unshelve", new Object[0]);
        Supplier<String> supplier = PerforceBundle.messagePointer("shelf.unshelve.action.description", new Object[0]);
        Icon icon = AllIcons.Vcs.Unshelve;
        browser.addToolbarAction((AnAction)new DumbAwareAction(browser, project, (Supplier<String>)actionDescriptorArray, supplier, icon){
            final /* synthetic */ SimpleChangesBrowser $browser;
            final /* synthetic */ Project $project;
            {
                this.$browser = $browser;
                this.$project = $project;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                List list = this.$browser.getIncludedChanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIncludedChanges(...)");
                presentation.setEnabled(!((Collection)list).isEmpty());
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull AnActionEvent e) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileDocumentManager.getInstance().saveAllDocuments();
                List list = this.$browser.getIncludedChanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIncludedChanges(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Change change = (Change)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.idea.perforce.application.ShelvedChange.IdeaChange");
                    collection.add(((ShelvedChange.IdeaChange)it).getOriginal());
                }
                ShelfUtils.unshelveChanges((List)destination$iv$iv, this.$project, false);
            }
        });
        dialogBuilder.setTitle(PerforceBundle.message("shelf.changes", new Object[0]));
        actionDescriptorArray = new DialogBuilder.ActionDescriptor[]{new DialogBuilder.OkActionDescriptor(), new DialogBuilder.CloseDialogAction()};
        dialogBuilder.setActionDescriptors(actionDescriptorArray);
        dialogBuilder.getOkAction().setText(PerforceBundle.message("shelf.unshelve.and.delete", new Object[0]));
        dialogBuilder.setOkOperation(() -> ShelfUtils.browseShelf$lambda$3(browser, project, dialogBuilder));
        dialogBuilder.setCenterPanel((JComponent)browser);
        dialogBuilder.setPreferredFocusComponent(browser.getPreferredFocusedComponent());
        dialogBuilder.showNotModal();
    }

    @JvmStatic
    @NotNull
    public static final MultiMap<Pair<P4Connection, Long>, String> groupByChangeList(@NotNull List<? extends ShelvedChange> selected) {
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap paths = multiMap;
        for (ShelvedChange shelvedChange : selected) {
            paths.putValue((Object)TuplesKt.to((Object)shelvedChange.getConnection(), (Object)shelvedChange.getChangeList()), (Object)shelvedChange.getDepotPath());
        }
        return paths;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @JvmStatic
    public static final void unshelveChanges(@NotNull List<? extends ShelvedChange> selected, @NotNull Project project, boolean delete) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MultiMap<Pair<P4Connection, Long>, String> paths = ShelfUtils.groupByChangeList(selected);
        INSTANCE.doUnshelve(paths, project);
        if (delete) {
            ShelfUtils.deleteFromShelf(paths, project);
        }
        Iterable $this$mapNotNull$iv = selected;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        VirtualFile[] virtualFileArray = $this$forEach$iv$iv$iv.iterator();
        while (virtualFileArray.hasNext()) {
            FilePath filePath;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = virtualFileArray.next();
            boolean bl = false;
            ShelvedChange it = (ShelvedChange)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() != null) {
                File file;
                boolean bl3 = false;
                filePath = VcsUtil.getFilePath((File)file);
            } else {
                filePath = null;
            }
            if (filePath == null) continue;
            FilePath it$iv$iv = filePath;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dirtyFiles = (List)destination$iv$iv;
        Iterable $this$forEach$iv = dirtyFiles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePath it = (FilePath)element$iv;
            boolean bl = false;
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(it.getPath());
            if (file == null) continue;
            virtualFileArray = new VirtualFile[]{file};
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
        }
        VcsDirtyScopeManager.getInstance((Project)project).filePathsDirty((Collection)dirtyFiles, (Collection)CollectionsKt.emptyList());
    }

    private final void doUnshelve(MultiMap<Pair<P4Connection, Long>, String> paths, Project project) {
        for (Map.Entry entry : paths.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            Pair pair = (Pair)entry.getKey();
            Collection specs = (Collection)entry.getValue();
            P4Connection connection = (P4Connection)pair.component1();
            long changeList = ((Number)pair.component2()).longValue();
            try {
                PerforceRunner.getInstance(project).unshelve(connection, changeList, specs);
            }
            catch (VcsException e) {
                AbstractVcsHelper.getInstance((Project)project).showError(e, PerforceBundle.message("shelf.unshelve", new Object[0]));
            }
        }
    }

    private final void handleUnshelveException(P4Connection connection, VcsException unshelveException, Project project, Collection<String> specs) {
        String string = unshelveException.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-message>(...)");
        String msg = string;
        if (StringsKt.contains$default((CharSequence)msg, (CharSequence)"needs resolve", (boolean)false, (int)2, null)) {
            LinkedHashSet<VirtualFile> toResolve = null;
            try {
                LinkedHashSet<VirtualFile> linkedHashSet = PerforceRunner.getInstance(project).getResolvedWithConflicts(connection, specs);
                Intrinsics.checkNotNullExpressionValue(linkedHashSet, (String)"getResolvedWithConflicts(...)");
                toResolve = linkedHashSet;
            }
            catch (VcsException resolveException) {
                AbstractVcsHelper.getInstance((Project)project).showError(unshelveException, PerforceBundle.message("shelf.unshelve", new Object[0]));
                AbstractVcsHelper.getInstance((Project)project).showError(resolveException, PerforceBundle.message("shelf.unshelve", new Object[0]));
                return;
            }
            if (!((Collection)toResolve).isEmpty()) {
                Collection $this$toTypedArray$iv = toResolve;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
                LOG.info((Throwable)unshelveException);
                new PerforceMergeProvider(project).showMergeDialog(CollectionsKt.toList((Iterable)toResolve));
                return;
            }
        }
        AbstractVcsHelper.getInstance((Project)project).showError(unshelveException, PerforceBundle.message("shelf.unshelve", new Object[0]));
    }

    @JvmStatic
    public static final void deleteFromShelf(@NotNull MultiMap<Pair<P4Connection, Long>, String> paths, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        for (Map.Entry entry : paths.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            Pair pair = (Pair)entry.getKey();
            Collection specs = (Collection)entry.getValue();
            P4Connection connection = (P4Connection)pair.component1();
            long changeList = ((Number)pair.component2()).longValue();
            try {
                PerforceRunner.getInstance(project).deleteFromShelf(connection, changeList, specs);
            }
            catch (VcsException e) {
                INSTANCE.handleUnshelveException(connection, e, project, specs);
            }
        }
    }

    @JvmStatic
    public static final void deleteFromShelf(@NotNull List<? extends ShelvedChange> changes, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ShelfUtils.deleteFromShelf(ShelfUtils.groupByChangeList(changes), project);
    }

    private static final void browseShelf$lambda$1(DialogBuilder $dialogBuilder, SimpleChangesBrowser $browser) {
        Intrinsics.checkNotNullParameter((Object)$dialogBuilder, (String)"$dialogBuilder");
        Intrinsics.checkNotNullParameter((Object)$browser, (String)"$browser");
        List list = $browser.getIncludedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIncludedChanges(...)");
        $dialogBuilder.setOkActionEnabled(!((Collection)list).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private static final void browseShelf$lambda$3(SimpleChangesBrowser $browser, Project $project, DialogBuilder $dialogBuilder) {
        Intrinsics.checkNotNullParameter((Object)$browser, (String)"$browser");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$dialogBuilder, (String)"$dialogBuilder");
        FileDocumentManager.getInstance().saveAllDocuments();
        List list = $browser.getIncludedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIncludedChanges(...)");
        List selected = list;
        if (!((Collection)selected).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = selected;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Change change = (Change)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.idea.perforce.application.ShelvedChange.IdeaChange");
                collection.add(((ShelvedChange.IdeaChange)it).getOriginal());
            }
            ShelfUtils.unshelveChanges((List)destination$iv$iv, $project, true);
            $dialogBuilder.getDialogWrapper().close(0);
        }
    }

    static {
        Logger logger = Logger.getInstance(ShelfUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

