/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.AbstractP4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigFields;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParamsCalculator;

public class P4EnvHelper {
    @Topic.ProjectLevel
    public static final Topic<P4EnvListener> P4_ENV_CHANGED = new Topic(P4EnvListener.class);
    private static final Logger LOG = Logger.getInstance(P4EnvHelper.class);
    private static final List<String> ENV_CONFIGS = List.of(P4ConfigFields.P4PORT.getName(), P4ConfigFields.P4CLIENT.getName(), P4ConfigFields.P4USER.getName(), P4ConfigFields.P4PASSWD.getName(), P4ConfigFields.P4CONFIG.getName(), P4ConfigFields.P4IGNORE.getName());
    private final Project myProject;
    private final Map<String, String> myDefaultParamsMap = new HashMap<String, String>();
    private P4ConnectionParameters myDefaultParams;

    public P4EnvHelper(Project project) {
        this.myProject = project;
        this.reset();
    }

    public P4ConnectionParameters getDefaultParams() {
        return this.myDefaultParams;
    }

    public static P4EnvHelper getConfigHelper(Project project) {
        return (P4EnvHelper)project.getService(P4EnvHelper.class);
    }

    public void reset() {
        PerforceSettings settings = PerforceSettings.getSettings(this.myProject);
        this.initializeP4SetVariables(this.myProject, settings.getPhysicalSettings(false));
        settings.setEnvP4IgnoreVar(this.getP4Ignore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeP4SetVariables(Project project, PerforcePhysicalConnectionParametersI physicalParameters) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        PerforceVcs vcs = PerforceVcs.getInstance(this.myProject);
        VirtualFile[] detailedVcsMappings = vcsManager.getRootsUnderVcs((AbstractVcs)vcs);
        P4ParamsCalculator calculator = new P4ParamsCalculator(project);
        P4EnvHelper p4EnvHelper = this;
        synchronized (p4EnvHelper) {
            HashMap<String, String> oldMap = new HashMap<String, String>(this.myDefaultParamsMap);
            this.myDefaultParamsMap.clear();
            this.myDefaultParams = new P4ConnectionParameters();
            P4ConnectionParameters params = calculator.runSetOnFile(physicalParameters, this.myDefaultParams, SystemProperties.getUserHome());
            P4EnvHelper.takeProblemsIntoDefaultParams(params, this.myDefaultParams);
            for (VirtualFile vcsMapping : detailedVcsMappings) {
                P4ConnectionParameters mappingParams = calculator.runSetOnFile(physicalParameters, this.myDefaultParams, vcsMapping.getPath());
                P4EnvHelper.takeProblemsIntoDefaultParams(mappingParams, this.myDefaultParams);
                if (this.myDefaultParams.allFieldsDefined()) break;
            }
            for (String envVar : ENV_CONFIGS) {
                String value = EnvironmentUtil.getValue((String)envVar);
                this.tryToPutVariable(envVar, value);
            }
            this.tryToPutVariable(P4ConfigFields.P4PORT.getName(), this.myDefaultParams.getServer());
            this.tryToPutVariable(P4ConfigFields.P4USER.getName(), this.myDefaultParams.getUser());
            this.tryToPutVariable(P4ConfigFields.P4CLIENT.getName(), this.myDefaultParams.getClient());
            this.tryToPutVariable(P4ConfigFields.P4PASSWD.getName(), this.myDefaultParams.getPassword());
            this.tryToPutVariable(P4ConfigFields.P4CONFIG.getName(), this.myDefaultParams.getConfigFileName());
            this.tryToPutVariable(P4ConfigFields.P4IGNORE.getName(), this.myDefaultParams.getIgnoreFileName());
            this.tryToPutVariable(P4ConfigFields.P4CHARSET.getName(), this.myDefaultParams.getCharset());
            if (!oldMap.isEmpty() && !this.myDefaultParamsMap.equals(oldMap)) {
                LOG.info("Environment has changed: was %s now %s".formatted(((Object)oldMap).toString(), this.myDefaultParamsMap.toString()));
                ((P4EnvListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, P4_ENV_CHANGED)).environmentChanged();
            }
        }
    }

    private void tryToPutVariable(String variable, @Nullable String value) {
        if (value != null) {
            this.myDefaultParamsMap.put(variable, value);
        }
    }

    private static void takeProblemsIntoDefaultParams(P4ConnectionParameters params, P4ConnectionParameters defaultParameters) {
        if (params.hasProblems()) {
            if (params.getException() != null) {
                defaultParameters.setException(params.getException());
            }
            if (!params.getWarnings().isEmpty()) {
                for (String warning : params.getWarnings()) {
                    defaultParameters.addWarning(warning);
                }
            }
        }
    }

    public synchronized String getUnsetP4EnvironmentVars() {
        return ENV_CONFIGS.stream().filter(env -> this.myDefaultParamsMap.get(env) == null).collect(Collectors.joining(","));
    }

    public synchronized boolean hasP4ConfigSetting() {
        return this.myDefaultParamsMap.get(P4ConfigFields.P4CONFIG.getName()) != null;
    }

    public synchronized boolean hasP4IgnoreSetting() {
        return this.myDefaultParamsMap.get(P4ConfigFields.P4IGNORE.getName()) != null;
    }

    @Nullable
    public synchronized String getP4Config() {
        return this.myDefaultParamsMap.get(P4ConfigFields.P4CONFIG.getName());
    }

    @Nullable
    public synchronized String getP4Ignore() {
        return this.myDefaultParamsMap.get(P4ConfigFields.P4IGNORE.getName());
    }

    public synchronized void fillDefaultValues(P4ConnectionParameters parameters) {
        if (parameters.getServer() == null) {
            parameters.setServer(this.myDefaultParamsMap.get(P4ConfigFields.P4PORT.getName()));
        }
        if (parameters.getUser() == null) {
            parameters.setUser(this.myDefaultParamsMap.get(P4ConfigFields.P4USER.getName()));
        }
        if (parameters.getClient() == null) {
            parameters.setClient(this.myDefaultParamsMap.get(P4ConfigFields.P4CLIENT.getName()));
        }
        if (parameters.getPassword() == null) {
            parameters.setPassword(this.myDefaultParamsMap.get(P4ConfigFields.P4PASSWD.getName()));
        }
        if (parameters.getIgnoreFileName() == null) {
            parameters.setIgnoreFileName(this.myDefaultParams.getIgnoreFileName());
        }
    }

    @Nullable
    public static String getP4IgnoreFileNameFromEnv() {
        String testValue = AbstractP4Connection.getTestEnvironment().get(P4ConfigFields.P4IGNORE.getName());
        if (testValue != null) {
            return testValue;
        }
        return EnvironmentUtil.getValue((String)P4ConfigFields.P4IGNORE.getName());
    }

    public static boolean hasP4ConfigSettingInEnvironment() {
        return EnvironmentUtil.getValue((String)P4ConfigFields.P4CONFIG.getName()) != null;
    }

    public static interface P4EnvListener {
        public void environmentChanged();
    }
}

