/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.ASTNodeEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AfterSemicolonEnterProcessor
implements ASTNodeEnterProcessor {
    @Override
    public boolean doEnter(@NotNull Editor editor, @NotNull ASTNode astNode, boolean isModified) {
        PsiElement psiElement;
        if (editor == null) {
            AfterSemicolonEnterProcessor.$$$reportNull$$$0(0);
        }
        if (astNode == null) {
            AfterSemicolonEnterProcessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = BasicJavaAstTreeUtil.toPsi(astNode)) == null) {
            return false;
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_EXPRESSION_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_DECLARATION_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_DO_WHILE_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_RETURN_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_THROW_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_BREAK_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_CONTINUE_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_YIELD_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_ASSERT_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, Set.of(BasicJavaElementType.BASIC_FIELD, BasicJavaElementType.BASIC_ENUM_CONSTANT)) || AfterSemicolonEnterProcessor.isImportStatementBase(psiElement) || AfterSemicolonEnterProcessor.isMethodWithoutBody(psiElement)) {
            CharSequence text;
            int commaOffset;
            int errorOffset = AfterSemicolonEnterProcessor.getErrorElementOffset(psiElement);
            int elementEndOffset = astNode.getTextRange().getEndOffset();
            if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_ENUM_CONSTANT) && (commaOffset = CharArrayUtil.shiftForwardUntil((CharSequence)(text = editor.getDocument().getCharsSequence()), (int)elementEndOffset, (String)",")) < text.length()) {
                elementEndOffset = commaOffset + 1;
            }
            if (errorOffset >= 0 && errorOffset < elementEndOffset && (text = editor.getDocument().getCharsSequence()).charAt(errorOffset) == ' ' && text.charAt(errorOffset + 1) == ';') {
                ++errorOffset;
            }
            editor.getCaretModel().moveToOffset(errorOffset >= 0 ? errorOffset : elementEndOffset);
            return isModified;
        }
        return false;
    }

    static boolean shouldHaveBody(@Nullable ASTNode element) {
        if (element == null) {
            return false;
        }
        ASTNode containingClass = BasicJavaAstTreeUtil.getParentOfType(element, BasicJavaElementType.CLASS_SET);
        if (containingClass == null) {
            return false;
        }
        if (BasicJavaAstTreeUtil.hasModifierProperty(element, JavaTokenType.ABSTRACT_KEYWORD) || BasicJavaAstTreeUtil.hasModifierProperty(element, JavaTokenType.NATIVE_KEYWORD)) {
            return false;
        }
        if (BasicJavaAstTreeUtil.hasModifierProperty(element, JavaTokenType.PRIVATE_KEYWORD)) {
            return true;
        }
        return !BasicJavaAstTreeUtil.isInterfaceEnumClassOrRecord(containingClass, JavaTokenType.INTERFACE_KEYWORD) || BasicJavaAstTreeUtil.hasModifierProperty(element, JavaTokenType.DEFAULT_KEYWORD) || BasicJavaAstTreeUtil.hasModifierProperty(element, JavaTokenType.STATIC_KEYWORD);
    }

    private static boolean isMethodWithoutBody(@Nullable PsiElement psiElement) {
        ASTNode node = BasicJavaAstTreeUtil.toNode(psiElement);
        return BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_METHOD) && !AfterSemicolonEnterProcessor.shouldHaveBody(node);
    }

    private static boolean isImportStatementBase(@Nullable PsiElement psiElement) {
        ASTNode node = BasicJavaAstTreeUtil.toNode(psiElement);
        return BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_IMPORT_STATEMENT) || BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_IMPORT_STATIC_STATEMENT);
    }

    private static int getErrorElementOffset(PsiElement elt) {
        final int[] offset = new int[]{-1};
        elt.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (offset[0] == -1) {
                    offset[0] = element.getTextRange().getStartOffset();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/smartEnter/AfterSemicolonEnterProcessor$1", "visitErrorElement"));
            }
        });
        return offset[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "astNode";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/smartEnter/AfterSemicolonEnterProcessor";
        objectArray[2] = "doEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

