/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionController;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalCopyAction;", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromotedDumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Disabled;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getBlocksText", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "blocks", "", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "update", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCopyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCopyAction.kt\norg/jetbrains/plugins/terminal/action/TerminalCopyAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1#2:53\n1045#3:54\n*S KotlinDebug\n*F\n+ 1 TerminalCopyAction.kt\norg/jetbrains/plugins/terminal/action/TerminalCopyAction\n*L\n40#1:54\n*E\n"})
public final class TerminalCopyAction
extends TerminalPromotedDumbAwareAction
implements ActionRemoteBehaviorSpecification.Disabled {
    public void actionPerformed(@NotNull AnActionEvent e) {
        String selectedText;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TerminalSelectionController selectionController = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
        if (editor2.getSelectionModel().hasSelection()) {
            String string = editor2.getSelectionModel().getSelectedText();
            v2 = string;
            Intrinsics.checkNotNull((Object)string);
        } else if (selectionController != null) {
            String string;
            String it = string = this.getBlocksText(editor2, selectionController.getSelectedBlocks());
            boolean bl = false;
            v2 = ((CharSequence)it).length() > 0 ? string : null;
        } else {
            v2 = selectedText = null;
        }
        if (selectedText != null) {
            CopyPasteManager.copyTextToClipboard((String)selectedText);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        v0 = e.getPresentation();
        if (editor == null || !TerminalDataContextUtils.INSTANCE.isOutputEditor(editor) && !TerminalDataContextUtils.INSTANCE.isAlternateBufferEditor(editor)) ** GOTO lbl-1000
        v1 = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
        if ((v1 != null ? v1.getPrimarySelection() : null) != null || editor.getSelectionModel().hasSelection()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0.setEnabledAndVisible(v2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final String getBlocksText(Editor editor, List<CommandBlock> blocks) {
        Iterable $this$sortedBy$iv = blocks;
        boolean $i$f$sortedBy = false;
        List sortedBlocks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CommandBlock it = (CommandBlock)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (CommandBlock)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        StringBuilder builder = new StringBuilder();
        int n = sortedBlocks.size();
        for (int index = 0; index < n; ++index) {
            CommandBlock block = (CommandBlock)sortedBlocks.get(index);
            builder.append(editor.getDocument().getText(block.getTextRange()));
            if (index == CollectionsKt.getLastIndex((List)sortedBlocks)) continue;
            builder.append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

