/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.check;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.gradle.internal.impldep.org.apache.ivy.core.check.CheckEngineSettings;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveData;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveEngine;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveOptions;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class CheckEngine {
    private CheckEngineSettings settings;
    private ResolveEngine resolveEngine;

    public CheckEngine(CheckEngineSettings settings, ResolveEngine resolveEngine) {
        this.settings = settings;
        this.resolveEngine = resolveEngine;
    }

    public boolean check(URL ivyFile, String resolvername) {
        try {
            boolean result = true;
            ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this.settings, ivyFile, this.settings.doValidate());
            if (resolvername != null) {
                DependencyResolver resolver = this.settings.getResolver(resolvername);
                HashSet<Artifact> artifacts = new HashSet<Artifact>();
                for (String string : md.getConfigurationsNames()) {
                    artifacts.addAll(Arrays.asList(md.getArtifacts(string)));
                }
                for (Artifact artifact : artifacts) {
                    if (resolver.exists(artifact)) continue;
                    Message.info("declared publication not found: " + artifact);
                    result = false;
                }
            }
            ResolveData data = new ResolveData(this.resolveEngine, new ResolveOptions());
            for (DependencyDescriptor dd : md.getDependencies()) {
                for (String masterConf : dd.getModuleConfigurations()) {
                    if ("*".equals(masterConf.trim()) || md.getConfiguration(masterConf) != null) continue;
                    Message.info("dependency required in non existing conf for " + ivyFile + " \n\tin " + dd + ": " + masterConf);
                    result = false;
                }
                DependencyResolver dependencyResolver = this.settings.getResolver(dd.getDependencyRevisionId());
                ResolvedModuleRevision rmr = dependencyResolver.getDependency(dd, data);
                if (rmr == null) {
                    Message.info("dependency not found in " + ivyFile + ":\n\t" + dd);
                    result = false;
                    continue;
                }
                for (String depConf : dd.getDependencyConfigurations(md.getConfigurationsNames())) {
                    if (!Arrays.asList(rmr.getDescriptor().getConfigurationsNames()).contains(depConf)) {
                        Message.info("dependency configuration is missing for " + ivyFile + "\n\tin " + dd + ": " + depConf);
                        result = false;
                    }
                    for (Artifact art : rmr.getDescriptor().getArtifacts(depConf)) {
                        if (dependencyResolver.exists(art)) continue;
                        Message.info("dependency artifact is missing for " + ivyFile + "\n\t in " + dd + ": " + art);
                        result = false;
                    }
                }
            }
            return result;
        }
        catch (ParseException e) {
            Message.info("parse problem on " + ivyFile, e);
            return false;
        }
        catch (IOException e) {
            Message.info("io problem on " + ivyFile, e);
            return false;
        }
        catch (Exception e) {
            Message.info("problem on " + ivyFile, e);
            return false;
        }
    }
}

