/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.retrieve;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ArtifactDownloadReport;

public class RetrieveReport {
    private Collection<File> upToDateFiles = new HashSet<File>();
    private Collection<File> copiedFiles = new HashSet<File>();
    private Map<File, ArtifactDownloadReport> downloadReport = new HashMap<File, ArtifactDownloadReport>();
    private File retrieveRoot;

    public File getRetrieveRoot() {
        return this.retrieveRoot;
    }

    public void setRetrieveRoot(File retrieveRoot) {
        this.retrieveRoot = retrieveRoot;
    }

    public int getNbrArtifactsCopied() {
        return this.copiedFiles.size();
    }

    public int getNbrArtifactsUpToDate() {
        return this.upToDateFiles.size();
    }

    public void addCopiedFile(File file, ArtifactDownloadReport report) {
        this.copiedFiles.add(file);
        this.downloadReport.put(file, report);
    }

    public void addUpToDateFile(File file, ArtifactDownloadReport report) {
        this.upToDateFiles.add(file);
        this.downloadReport.put(file, report);
    }

    public Collection<File> getCopiedFiles() {
        return new ArrayList<File>(this.copiedFiles);
    }

    public Collection<File> getUpToDateFiles() {
        return new ArrayList<File>(this.upToDateFiles);
    }

    public Collection<File> getRetrievedFiles() {
        ArrayList<File> result = new ArrayList<File>(this.upToDateFiles.size() + this.copiedFiles.size());
        result.addAll(this.upToDateFiles);
        result.addAll(this.copiedFiles);
        return result;
    }

    public Map<File, ArtifactDownloadReport> getDownloadReport() {
        return this.downloadReport;
    }
}

