/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.filter;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.org.apache.ivy.osgi.filter.OSGiFilter;

public abstract class MultiOperatorFilter
extends OSGiFilter {
    private List<OSGiFilter> subFilters = new ArrayList<OSGiFilter>();

    public MultiOperatorFilter() {
    }

    public MultiOperatorFilter(OSGiFilter[] filters) {
        for (OSGiFilter filter : filters) {
            this.add(filter);
        }
    }

    protected abstract char operator();

    @Override
    public void append(StringBuffer builder) {
        builder.append('(');
        builder.append(this.operator());
        for (OSGiFilter filter : this.subFilters) {
            filter.append(builder);
        }
        builder.append(')');
    }

    public void add(OSGiFilter subFilter2) {
        this.subFilters.add(subFilter2);
    }

    public List<OSGiFilter> getSubFilters() {
        return this.subFilters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (OSGiFilter subFilter : this.subFilters) {
            result = 31 * result + (subFilter == null ? 0 : subFilter.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MultiOperatorFilter)) {
            return false;
        }
        MultiOperatorFilter other = (MultiOperatorFilter)obj;
        return this.subFilters == null ? other.subFilters == null : other.subFilters != null && this.subFilters.size() == other.subFilters.size() && this.subFilters.containsAll(other.subFilters);
    }
}

