/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.gradle.internal.impldep.org.apache.ivy.util.Checks;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;
import org.gradle.internal.impldep.org.apache.ivy.util.MessageLogger;
import org.gradle.internal.impldep.org.apache.ivy.util.MessageLoggerHelper;

public class MessageLoggerEngine
implements MessageLogger {
    private final ThreadLocal<Stack<MessageLogger>> loggerStacks = new ThreadLocal();
    private MessageLogger defaultLogger = null;
    private List<String> problems = new ArrayList<String>();
    private List<String> warns = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();

    private Stack<MessageLogger> getLoggerStack() {
        Stack<MessageLogger> stack = this.loggerStacks.get();
        if (stack == null) {
            stack = new Stack();
            this.loggerStacks.set(stack);
        }
        return stack;
    }

    public void setDefaultLogger(MessageLogger defaultLogger) {
        this.defaultLogger = defaultLogger;
    }

    public void pushLogger(MessageLogger logger) {
        Checks.checkNotNull(logger, "logger");
        this.getLoggerStack().push(logger);
    }

    public void popLogger() {
        if (!this.getLoggerStack().isEmpty()) {
            this.getLoggerStack().pop();
        }
    }

    public MessageLogger peekLogger() {
        if (this.getLoggerStack().isEmpty()) {
            return this.getDefaultLogger();
        }
        return this.getLoggerStack().peek();
    }

    private MessageLogger getDefaultLogger() {
        return this.defaultLogger == null ? Message.getDefaultLogger() : this.defaultLogger;
    }

    @Override
    public void warn(String msg) {
        this.peekLogger().warn(msg);
        this.problems.add("WARN:  " + msg);
        this.warns.add(msg);
    }

    @Override
    public void error(String msg) {
        this.peekLogger().error(msg);
        this.problems.add("\tERROR: " + msg);
        this.errors.add(msg);
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public List<String> getProblems() {
        return this.problems;
    }

    @Override
    public List<String> getWarns() {
        return this.warns;
    }

    @Override
    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public void clearProblems() {
        this.getDefaultLogger().clearProblems();
        for (MessageLogger l : this.getLoggerStack()) {
            l.clearProblems();
        }
        this.problems.clear();
        this.errors.clear();
        this.warns.clear();
    }

    @Override
    public void setShowProgress(boolean progress) {
        this.getDefaultLogger().setShowProgress(progress);
        for (MessageLogger l : this.getLoggerStack()) {
            l.setShowProgress(progress);
        }
    }

    @Override
    public boolean isShowProgress() {
        return this.getDefaultLogger().isShowProgress();
    }

    @Override
    public void debug(String msg) {
        this.peekLogger().debug(msg);
    }

    @Override
    public void deprecated(String msg) {
        this.peekLogger().deprecated(msg);
    }

    @Override
    public void endProgress() {
        this.peekLogger().endProgress();
    }

    @Override
    public void endProgress(String msg) {
        this.peekLogger().endProgress(msg);
    }

    @Override
    public void info(String msg) {
        this.peekLogger().info(msg);
    }

    @Override
    public void rawinfo(String msg) {
        this.peekLogger().rawinfo(msg);
    }

    @Override
    public void log(String msg, int level) {
        this.peekLogger().log(msg, level);
    }

    @Override
    public void progress() {
        this.peekLogger().progress();
    }

    @Override
    public void rawlog(String msg, int level) {
        this.peekLogger().rawlog(msg, level);
    }

    @Override
    public void verbose(String msg) {
        this.peekLogger().verbose(msg);
    }
}

