/*
 * Decompiled with CFR 0.152.
 */
package org.toml.ide.json;

import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.ide.json.TomlJsonGenericValueAdapter;
import org.toml.ide.json.TomlJsonObjectAdapter;
import org.toml.ide.json.TomlJsonValueAdapter;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlKeyValueOwner;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/toml/ide/json/TomlJsonPropertyAdapter;", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonPropertyAdapter;", "keyValue", "Lorg/toml/lang/psi/TomlKeyValue;", "(Lorg/toml/lang/psi/TomlKeyValue;)V", "getDelegate", "Lcom/intellij/psi/PsiElement;", "getName", "", "getNameValueAdapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonValueAdapter;", "getParentObject", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonObjectValueAdapter;", "getValues", "", "intellij.toml.json"})
public final class TomlJsonPropertyAdapter
implements JsonPropertyAdapter {
    @NotNull
    private final TomlKeyValue keyValue;

    public TomlJsonPropertyAdapter(@NotNull TomlKeyValue keyValue) {
        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
        this.keyValue = keyValue;
    }

    @NotNull
    public String getName() {
        TomlKeySegment tomlKeySegment = (TomlKeySegment)CollectionsKt.lastOrNull(this.keyValue.getKey().getSegments());
        String string = tomlKeySegment != null ? tomlKeySegment.getName() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public JsonValueAdapter getNameValueAdapter() {
        return new TomlJsonGenericValueAdapter(this.keyValue.getKey());
    }

    @NotNull
    public PsiElement getDelegate() {
        return this.keyValue;
    }

    @NotNull
    public Collection<JsonValueAdapter> getValues() {
        TomlValue tomlValue = this.keyValue.getValue();
        if (tomlValue == null) {
            return CollectionsKt.emptyList();
        }
        TomlValue value = tomlValue;
        return CollectionsKt.listOf(TomlJsonValueAdapter.Companion.createAdapterByType(value));
    }

    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        PsiElement parent = this.keyValue.getParent();
        if (!(parent instanceof TomlKeyValueOwner)) {
            return null;
        }
        return new TomlJsonObjectAdapter((TomlKeyValueOwner)parent);
    }
}

