/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.impl.BundledSharedIndexProvider;
import com.intellij.indexing.shared.platform.impl.SingleChunkReadonlyZipStorage;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/platform/impl/BundledSharedIndexProvider;", "Lcom/intellij/openapi/extensions/PluginAware;", "()V", "chunkId", "", "getChunkId", "()Ljava/lang/String;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "pluginPath", "productPath", "resolvedChunkIdAndPath", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "getResolvedChunkIdAndPath", "()Lkotlin/Pair;", "resolvedChunkIdAndPath$delegate", "Lkotlin/Lazy;", "openChunkStorage", "Lcom/intellij/indexing/shared/platform/impl/SingleChunkReadonlyZipStorage;", "setPluginDescriptor", "", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexZipBundledStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexZipBundledStorage.kt\ncom/intellij/indexing/shared/platform/impl/BundledSharedIndexProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,197:1\n8#2:198\n*S KotlinDebug\n*F\n+ 1 SharedIndexZipBundledStorage.kt\ncom/intellij/indexing/shared/platform/impl/BundledSharedIndexProvider\n*L\n85#1:198\n*E\n"})
public final class BundledSharedIndexProvider
implements PluginAware {
    @Attribute(value="productPath")
    @JvmField
    @Nullable
    public String productPath;
    @Attribute(value="pluginPath")
    @JvmField
    @Nullable
    public String pluginPath;
    @Nullable
    private PluginDescriptor pluginDescriptor;
    @NotNull
    private final Lazy resolvedChunkIdAndPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair<? extends String, ? extends Path>>(this){
        final /* synthetic */ BundledSharedIndexProvider this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Pair<String, Path> invoke() {
            Pair pair;
            try {
                Path resolvedPath;
                Object object;
                String productPath = this.this$0.productPath;
                String pluginPath = this.this$0.pluginPath;
                if (!(productPath != null ^ pluginPath != null)) {
                    BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Only one parameter must be used in " + this.this$0);
                    return null;
                }
                Path path = productPath != null ? Paths.get(PathManager.getHomePath(), new String[0]).resolve(productPath) : (pluginPath != null ? ((object = BundledSharedIndexProvider.access$getPluginDescriptor$p(this.this$0)) != null && (object = object.getPluginPath()) != null ? object.resolve(pluginPath) : null) : (resolvedPath = null));
                if (resolvedPath == null) {
                    return null;
                }
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(resolvedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Bundled shared index is not found at: " + resolvedPath);
                    return null;
                }
                String sharedIndexExtension = ".ijx";
                AutoCloseable autoCloseable = Files.list(resolvedPath);
                Throwable throwable = null;
                try {
                    Object stream = (Stream)autoCloseable;
                    boolean bl = false;
                    stream = stream.filter(arg_0 -> resolvedChunkIdAndPath.2.invoke$lambda$1$lambda$0((Function1)new Function1<Path, Boolean>(sharedIndexExtension){
                        final /* synthetic */ String $sharedIndexExtension;
                        {
                            this.$sharedIndexExtension = $sharedIndexExtension;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(Path it) {
                            Intrinsics.checkNotNull((Object)it);
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && StringsKt.endsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$sharedIndexExtension, (boolean)false, (int)2, null);
                        }
                    }, arg_0)).toList();
                }
                catch (Throwable stream) {
                    throwable = stream;
                    throw stream;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Object indexes2 = stream;
                if (indexes2.isEmpty()) {
                    BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Failed to find any bundled shared indexes at: " + resolvedPath);
                    return null;
                }
                Intrinsics.checkNotNull((Object)indexes2);
                Path path2 = (Path)CollectionsKt.singleOrNull((List)indexes2);
                if (path2 == null) {
                    BundledSharedIndexProvider $this$invoke_u24lambda_u242 = this.this$0;
                    boolean bl = false;
                    BundledSharedIndexProvider $this$thisLogger$iv = $this$invoke_u24lambda_u242;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("There are several shared index files found at " + resolvedPath + ": " + (List)indexes2 + ". Please make sure IntelliJ was installed into an empty folder");
                    return null;
                }
                Path theBundledIndex = path2;
                BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Resolved bundled shared shared index: " + theBundledIndex + " (" + StringUtil.formatFileSize((long)Files.size(theBundledIndex)));
                BundledSharedIndexProvider $this$invoke_u24lambda_u243 = this.this$0;
                boolean bl = false;
                String name = StringsKt.removeSuffix((String)((Object)theBundledIndex.getFileName()).toString(), (CharSequence)sharedIndexExtension);
                Object object2 = BundledSharedIndexProvider.access$getPluginDescriptor$p($this$invoke_u24lambda_u243);
                if (object2 == null || (object2 = object2.getPluginId()) == null || (object2 = object2.getIdString()) == null) {
                    object2 = "global";
                }
                Object object3 = object2;
                Intrinsics.checkNotNull((Object)object3);
                Object source = object3;
                String chunkId = "bundled-" + name + "-" + (String)source + "-" + ApplicationInfo.getInstance().getBuild();
                pair = TuplesKt.to((Object)chunkId, (Object)theBundledIndex);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to locate bundled shared index for " + BundledSharedIndexProvider.access$getPluginDescriptor$p(this.this$0) + " and " + this.this$0.pluginPath + ". " + t.getMessage(), t);
                pair = null;
            }
            return pair;
        }

        private static final boolean invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }));

    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public final String getChunkId() {
        Pair<String, Path> pair = this.getResolvedChunkIdAndPath();
        if (pair == null) {
            return null;
        }
        String chunkId = (String)pair.component1();
        return chunkId;
    }

    @Nullable
    public final SingleChunkReadonlyZipStorage openChunkStorage() {
        SingleChunkReadonlyZipStorage singleChunkReadonlyZipStorage;
        Pair<String, Path> pair = this.getResolvedChunkIdAndPath();
        if (pair == null) {
            return null;
        }
        Pair<String, Path> pair2 = pair;
        String chunkId = (String)pair2.component1();
        Path resolvedPath = (Path)pair2.component2();
        try {
            singleChunkReadonlyZipStorage = new SingleChunkReadonlyZipStorage(chunkId, resolvedPath, "bundled-" + chunkId);
        }
        catch (Throwable t) {
            BundledSharedIndexProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to load bundled shared index: " + resolvedPath + ". " + t.getMessage(), t);
            return null;
        }
        return singleChunkReadonlyZipStorage;
    }

    private final Pair<String, Path> getResolvedChunkIdAndPath() {
        Lazy lazy = this.resolvedChunkIdAndPath$delegate;
        return (Pair)lazy.getValue();
    }

    public static final /* synthetic */ PluginDescriptor access$getPluginDescriptor$p(BundledSharedIndexProvider $this) {
        return $this.pluginDescriptor;
    }
}

