/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util.zipFs;

import com.intellij.indexing.shared.util.zipFs.TraceableFileChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jetbrains.annotations.NotNull;

public abstract class FileBlockReadOnlyFileChannel
extends FileChannel {
    private final String myEntryName;
    @NotNull
    private final TraceableFileChannel myUnderlying;
    private final long myStartOffset;
    private final long mySize;
    private volatile long myLocalPosition;

    /*
     * WARNING - void declaration
     */
    public FileBlockReadOnlyFileChannel(@NotNull String entryName, @NotNull TraceableFileChannel underlying, long startOffset, long l) {
        void size;
        if (entryName == null) {
            FileBlockReadOnlyFileChannel.$$$reportNull$$$0(0);
        }
        if (underlying == null) {
            FileBlockReadOnlyFileChannel.$$$reportNull$$$0(1);
        }
        this.myEntryName = entryName;
        this.myUnderlying = underlying;
        this.myStartOffset = startOffset;
        this.mySize = size;
        this.myLocalPosition = 0L;
    }

    public String toString() {
        return "FileBlockReadOnlyFileChannel{myEntryName='" + this.myEntryName + "', myStartOffset=" + this.myStartOffset + ", mySize=" + this.mySize + "}";
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = this.read(dst, this.myLocalPosition);
        if (read > 0) {
            this.position(this.myLocalPosition + (long)read);
        }
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw this.createNotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        long availableBytes = this.mySize - position;
        if (position < 0L || availableBytes <= 0L) {
            return -1;
        }
        int currentLimit = dst.limit();
        try {
            if ((long)dst.remaining() > availableBytes) {
                dst.limit((int)((long)dst.position() + availableBytes));
            }
            int n = this.myUnderlying.read(dst, this.myStartOffset + position);
            return n;
        }
        finally {
            dst.limit(currentLimit);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw this.createWriteNotSupportedException();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw this.createWriteNotSupportedException();
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw this.createWriteNotSupportedException();
    }

    @Override
    public long position() {
        return this.myLocalPosition;
    }

    @Override
    public FileChannel position(long newPosition) {
        this.myLocalPosition = newPosition;
        assert (this.myLocalPosition <= this.mySize);
        return this;
    }

    @Override
    public long size() {
        return this.mySize;
    }

    @Override
    public FileChannel truncate(long size) {
        throw this.createNotImplementedException();
    }

    @Override
    public void force(boolean metaData) {
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (count <= 0L) {
            return 0L;
        }
        long transferred = 0L;
        boolean countIsRead = false;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (!countIsRead && this.read(buffer, position + transferred) >= 0 || buffer.position() != 0) {
            buffer.flip();
            if (transferred + (long)buffer.limit() > count) {
                countIsRead = true;
                buffer.limit((int)(count - transferred));
            }
            transferred += (long)target.write(buffer);
            buffer.compact();
        }
        return transferred;
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) {
        throw this.createWriteNotSupportedException();
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
        throw this.createNotImplementedException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) {
        return null;
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) {
        return null;
    }

    @Override
    protected void implCloseChannel() throws IOException {
    }

    @NotNull
    private UnsupportedOperationException createWriteNotSupportedException() {
        return new UnsupportedOperationException("Write operation is not supported for " + this);
    }

    @NotNull
    private UnsupportedOperationException createNotImplementedException() {
        return new UnsupportedOperationException("Operation is not implemented for " + this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "entryName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "underlying";
                break;
            }
        }
        objectArray[1] = "com/intellij/indexing/shared/util/zipFs/FileBlockReadOnlyFileChannel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

