/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class GroovyFix
implements LocalQuickFix {
    public static final GroovyFix EMPTY_FIX = new GroovyFix(){

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String getFamilyName() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/GroovyFix$1";
            objectArray[2] = "doFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroovyFix[] EMPTY_ARRAY = new GroovyFix[0];

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement problemElement;
        if (project == null) {
            GroovyFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            GroovyFix.$$$reportNull$$$0(1);
        }
        if ((problemElement = descriptor2.getPsiElement()) == null || !problemElement.isValid()) {
            return;
        }
        try {
            this.doFix(project, descriptor2);
        }
        catch (IncorrectOperationException e) {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            Logger logger = Logger.getInstance((String)className);
            logger.error((Throwable)e);
        }
    }

    protected abstract void doFix(@NotNull Project var1, @NotNull ProblemDescriptor var2) throws IncorrectOperationException;

    protected static void replaceExpression(GrExpression expression, @NonNls String newExpression) {
        GrInspectionUtil.replaceExpression(expression, newExpression);
    }

    protected static void replaceStatement(GrStatement statement, @NonNls String newStatement) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        GrStatement newCall = (GrStatement)factory.createTopElementFromText(newStatement);
        statement.replaceWithStatement(newCall);
    }

    protected static void replaceStatement(GrStatement oldStatement, GrStatement newStatement) throws IncorrectOperationException {
        if (newStatement instanceof GrBlockStatement) {
            GrBlockStatement blockStatement = (GrBlockStatement)newStatement;
            GrOpenBlock openBlock = blockStatement.getBlock();
            GrStatement[] statements2 = openBlock.getStatements();
            if (statements2.length == 0) {
                oldStatement.removeStatement();
            } else {
                PsiElement parent2 = oldStatement.getParent();
                if (parent2 instanceof GrStatementOwner) {
                    GrStatementOwner statementOwner = (GrStatementOwner)parent2;
                    for (GrStatement statement : statements2) {
                        statementOwner.addStatementBefore(statement, oldStatement);
                    }
                    oldStatement.removeStatement();
                } else if (parent2 instanceof GrControlStatement) {
                    oldStatement.replace(newStatement);
                }
            }
        } else {
            oldStatement.replaceWithStatement(newStatement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/GroovyFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

