/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.RelaxedDirectInheritorChecker;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public class GroovyDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @NotNull
    private static List<PsiClass> getDerivingClassCandidates(PsiClass clazz, GlobalSearchScope scope, boolean includeAnonymous) {
        String name = clazz.getName();
        if (name == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                GroovyDirectInheritorsSearcher.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<PsiClass> inheritors = new ArrayList<PsiClass>();
        for (GrReferenceList list : StubIndex.getElements(GrDirectInheritorsIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, GrReferenceList.class)) {
            PsiElement parent2 = list.getParent();
            if (!(parent2 instanceof GrTypeDefinition)) continue;
            inheritors.add((PsiClass)parent2);
        }
        if (includeAnonymous) {
            inheritors.addAll(StubIndex.getElements(GrAnonymousClassIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, GrAnonymousClassDefinition.class));
        }
        ArrayList<PsiClass> arrayList = inheritors;
        if (arrayList == null) {
            GroovyDirectInheritorsSearcher.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiClass> consumer) {
        if (queryParameters == null) {
            GroovyDirectInheritorsSearcher.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            GroovyDirectInheritorsSearcher.$$$reportNull$$$0(3);
        }
        PsiClass clazz = queryParameters.getClassToProcess();
        SearchScope scope = (SearchScope)ReadAction.compute(() -> queryParameters.getScope().intersectWith(clazz.getUseScope()));
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)clazz);
        GlobalSearchScope globalSearchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)scope, (Project)project);
        DumbService dumbService = DumbService.getInstance((Project)project);
        List candidates = (List)dumbService.runReadActionInSmartMode(() -> {
            if (!clazz.isValid()) {
                return Collections.emptyList();
            }
            return GroovyDirectInheritorsSearcher.getDerivingClassCandidates(clazz, globalSearchScope, queryParameters.includeAnonymous());
        });
        if (!candidates.isEmpty()) {
            RelaxedDirectInheritorChecker checker = (RelaxedDirectInheritorChecker)dumbService.runReadActionInSmartMode(() -> new RelaxedDirectInheritorChecker(clazz));
            for (PsiClass candidate : candidates) {
                if (queryParameters.isCheckInheritance() && !((Boolean)dumbService.runReadActionInSmartMode(() -> checker.checkInheritance(candidate))).booleanValue() || consumer.process((Object)candidate)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivingClassCandidates";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

