/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToSeparateFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGeneratorImpl;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.git.RenameTrackingKt;

public class ConvertToJavaProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ConvertToJavaProcessor.class);
    private final GroovyFile[] myFiles;

    protected ConvertToJavaProcessor(Project project, GroovyFile ... files) {
        super(project);
        this.myFiles = files;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToJavaProcessor.$$$reportNull$$$0(0);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                if (ConvertToJavaProcessor.this.myFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ConvertToJavaProcessor.this.myFiles;
            }

            public String getProcessedElementsHeader() {
                return GroovyRefactoringBundle.message("files.to.be.converted", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ConvertToJavaProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (UsageInfo.EMPTY_ARRAY == null) {
            ConvertToJavaProcessor.$$$reportNull$$$0(1);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToJavaProcessor.$$$reportNull$$$0(2);
        }
        GeneratorClassNameProvider classNameProvider = new GeneratorClassNameProvider();
        ExpressionContext context = new ExpressionContext(this.myProject, this.myFiles);
        ClassGenerator classGenerator = new ClassGenerator(classNameProvider, new ClassItemGeneratorImpl(context));
        for (GroovyFile file : this.myFiles) {
            PsiElement newFile;
            PsiClass[] classes2 = file.getClasses();
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (PsiClass aClass : classes2) {
                classGenerator.writeTypeDefinition(builder, aClass, true, first);
                first = false;
                builder.append('\n');
            }
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)file);
            LOG.assertTrue(document != null);
            document.setText((CharSequence)builder.toString());
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            String fileName = ConvertToJavaProcessor.getNewFileName(file);
            try {
                String filePathBeforeConvert = file.getVirtualFile().getPath();
                RenameTrackingKt.setPathBeforeGroovyToJavaConversion(file.getVirtualFile(), filePathBeforeConvert);
                newFile = file.setName(fileName);
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
                return;
            }
            this.doPostProcessing(newFile);
        }
    }

    private void doPostProcessing(PsiElement newFile) {
        PsiClass[] inner;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!(newFile instanceof PsiJavaFile)) {
            LOG.info(".java is not assigned to java file type");
            return;
        }
        newFile = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(newFile);
        newFile = CodeStyleManager.getInstance((Project)this.myProject).reformat(newFile);
        for (PsiClass psiClass : inner = ((PsiJavaFile)newFile).getClasses()) {
            IntentionAction fix = new MoveClassToSeparateFileFix(psiClass).asIntention();
            if (!fix.isAvailable(this.myProject, null, (PsiFile)newFile)) continue;
            fix.invoke(this.myProject, null, (PsiFile)newFile);
        }
    }

    private static String getNewFileName(GroovyFile file) {
        PsiDirectory dir = file.getContainingDirectory();
        LOG.assertTrue(dir != null);
        PsiFile[] files = dir.getFiles();
        HashSet<String> fileNames = new HashSet<String>();
        for (PsiFile psiFile : files) {
            fileNames.add(psiFile.getName());
        }
        String prefix = FileUtilRt.getNameWithoutExtension((String)file.getName());
        String fileName = prefix + ".java";
        int index = 1;
        while (fileNames.contains(fileName)) {
            fileName = prefix + index++ + ".java";
        }
        return fileName;
    }

    @NotNull
    protected String getCommandName() {
        String string = GroovyRefactoringBundle.message("converting.files.to.java", new Object[0]);
        if (string == null) {
            ConvertToJavaProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/ConvertToJavaProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/ConvertToJavaProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

