/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import java.util.Vector;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class RegexpMatcherTest {
    public static final String UNIX_LINE = "\n";
    private RegexpMatcher reg;

    public abstract RegexpMatcher getImplementation();

    protected final RegexpMatcher getReg() {
        return this.reg;
    }

    @Before
    public void setUp() {
        this.reg = this.getImplementation();
    }

    @Test
    public void testMatches() {
        this.reg.setPattern("aaaa");
        Assert.assertTrue((String)"aaaa should match itself", (boolean)this.reg.matches("aaaa"));
        Assert.assertTrue((String)"aaaa should match xaaaa", (boolean)this.reg.matches("xaaaa"));
        Assert.assertFalse((String)"aaaa shouldn't match xaaa", (boolean)this.reg.matches("xaaa"));
        this.reg.setPattern("^aaaa");
        Assert.assertFalse((String)"^aaaa shouldn't match xaaaa", (boolean)this.reg.matches("xaaaa"));
        Assert.assertTrue((String)"^aaaa should match aaaax", (boolean)this.reg.matches("aaaax"));
        this.reg.setPattern("aaaa$");
        Assert.assertFalse((String)"aaaa$ shouldn't match aaaax", (boolean)this.reg.matches("aaaax"));
        Assert.assertTrue((String)"aaaa$ should match xaaaa", (boolean)this.reg.matches("xaaaa"));
        this.reg.setPattern("[0-9]+");
        Assert.assertTrue((String)"[0-9]+ should match 123", (boolean)this.reg.matches("123"));
        Assert.assertTrue((String)"[0-9]+ should match 1", (boolean)this.reg.matches("1"));
        Assert.assertFalse((String)"[0-9]+ shouldn't match ''", (boolean)this.reg.matches(""));
        Assert.assertFalse((String)"[0-9]+ shouldn't match a", (boolean)this.reg.matches("a"));
        this.reg.setPattern("[0-9]*");
        Assert.assertTrue((String)"[0-9]* should match 123", (boolean)this.reg.matches("123"));
        Assert.assertTrue((String)"[0-9]* should match 1", (boolean)this.reg.matches("1"));
        Assert.assertTrue((String)"[0-9]* should match ''", (boolean)this.reg.matches(""));
        Assert.assertTrue((String)"[0-9]* should match a", (boolean)this.reg.matches("a"));
        this.reg.setPattern("([0-9]+)=\\1");
        Assert.assertTrue((String)"([0-9]+)=\\1 should match 1=1", (boolean)this.reg.matches("1=1"));
        Assert.assertFalse((String)"([0-9]+)=\\1 shouldn't match 1=2", (boolean)this.reg.matches("1=2"));
    }

    @Test
    public void testGroups() {
        this.reg.setPattern("aaaa");
        Vector<String> v = this.reg.getGroups("xaaaa");
        Assert.assertEquals((String)"No parens -> no extra groups", (long)1L, (long)v.size());
        Assert.assertEquals((String)"Trivial match with no parens", (Object)"aaaa", (Object)v.elementAt(0));
        this.reg.setPattern("(aaaa)");
        v = this.reg.getGroups("xaaaa");
        Assert.assertEquals((String)"Trivial match with single paren", (long)2L, (long)v.size());
        Assert.assertEquals((String)"Trivial match with single paren, full match", (Object)"aaaa", (Object)v.elementAt(0));
        Assert.assertEquals((String)"Trivial match with single paren, matched paren", (Object)"aaaa", (Object)v.elementAt(0));
        this.reg.setPattern("(a+)b(b+)");
        v = this.reg.getGroups("xaabb");
        Assert.assertEquals((long)3L, (long)v.size());
        Assert.assertEquals((Object)"aabb", (Object)v.elementAt(0));
        Assert.assertEquals((Object)"aa", (Object)v.elementAt(1));
        Assert.assertEquals((Object)"b", (Object)v.elementAt(2));
    }

    @Test
    public void testBugzillaReport14619() {
        this.reg.setPattern("^(.*)/src/((.*/)*)([a-zA-Z0-9_\\.]+)\\.java$");
        Vector<String> v = this.reg.getGroups("de/tom/src/Google.java");
        Assert.assertEquals((long)5L, (long)v.size());
        Assert.assertEquals((Object)"de/tom", (Object)v.elementAt(1));
        Assert.assertEquals((Object)"", (Object)v.elementAt(2));
        Assert.assertEquals((Object)"", (Object)v.elementAt(3));
        Assert.assertEquals((Object)"Google", (Object)v.elementAt(4));
    }

    @Test
    public void testCaseInsensitiveMatch() {
        this.reg.setPattern("aaaa");
        Assert.assertFalse((String)"aaaa doesn't match AAaa", (boolean)this.reg.matches("AAaa"));
        Assert.assertTrue((String)"aaaa matches AAaa ignoring case", (boolean)this.reg.matches("AAaa", 256));
    }

    @Test
    public void testParagraphCharacter() {
        this.reg.setPattern("end of text$");
        Assert.assertFalse((String)"paragraph character", (boolean)this.reg.matches("end of text\u2029"));
    }

    @Test
    public void testLineSeparatorCharacter() {
        this.reg.setPattern("end of text$");
        Assert.assertFalse((String)"line-separator character", (boolean)this.reg.matches("end of text\u2028"));
    }

    @Test
    public void testNextLineCharacter() {
        this.reg.setPattern("end of text$");
        Assert.assertFalse((String)"next-line character", (boolean)this.reg.matches("end of text\u0085"));
    }

    @Test
    public void testStandaloneCR() {
        this.reg.setPattern("end of text$");
        Assert.assertFalse((String)"standalone CR", (boolean)this.reg.matches("end of text\r"));
    }

    @Test
    public void testWindowsLineSeparator() {
        this.reg.setPattern("end of text$");
        Assert.assertFalse((String)"Windows line separator", (boolean)this.reg.matches("end of text\r\n"));
    }

    @Test
    public void testWindowsLineSeparator2() {
        this.reg.setPattern("end of text\r$");
        Assert.assertTrue((String)"Windows line separator", (boolean)this.reg.matches("end of text\r\n"));
    }

    @Test
    public void testUnixLineSeparator() {
        this.reg.setPattern("end of text$");
        Assert.assertTrue((String)"Unix line separator", (boolean)this.reg.matches("end of text\n"));
    }

    @Test
    public void testMultiVersusSingleLine() {
        String text = "Line1\nstarttest Line2\nLine3 endtest\nLine4\n";
        this.doStartTest1(text);
        this.doStartTest2(text);
        this.doEndTest1(text);
        this.doEndTest2(text);
    }

    protected void doStartTest1(String text) {
        this.reg.setPattern("^starttest");
        Assert.assertFalse((String)"^starttest in default mode", (boolean)this.reg.matches(text));
        Assert.assertFalse((String)"^starttest in single line mode", (boolean)this.reg.matches(text, 65536));
        Assert.assertTrue((String)"^starttest in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doStartTest2(String text) {
        this.reg.setPattern("^Line1");
        Assert.assertTrue((String)"^Line1 in default mode", (boolean)this.reg.matches(text));
        Assert.assertTrue((String)"^Line1 in single line mode", (boolean)this.reg.matches(text, 65536));
        Assert.assertTrue((String)"^Line1 in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doEndTest1(String text) {
        this.reg.setPattern("endtest$");
        Assert.assertFalse((String)"endtest$ in default mode", (boolean)this.reg.matches(text));
        Assert.assertFalse((String)"endtest$ in single line mode", (boolean)this.reg.matches(text, 65536));
        Assert.assertTrue((String)"endtest$ in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doEndTest2(String text) {
        this.reg.setPattern("Line4$");
        Assert.assertTrue((String)"Line4$ in default mode", (boolean)this.reg.matches(text));
        Assert.assertTrue((String)"Line4$ in single line mode", (boolean)this.reg.matches(text, 65536));
        Assert.assertTrue((String)"Line4$ in multi line mode", (boolean)this.reg.matches(text, 4096));
    }
}

