/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.framework.base;

import com.jetbrains.rd.framework.AbstractBuffer;
import com.jetbrains.rd.framework.IWireWithDelayedDelivery;
import com.jetbrains.rd.framework.MessageBroker;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.base.IRdWireable;
import com.jetbrains.rd.framework.impl.ProtocolContexts;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.string.IPrintableKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020 J$\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001a0%H&J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\tH\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020#H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/jetbrains/rd/framework/base/WireBase;", "Lcom/jetbrains/rd/framework/IWireWithDelayedDelivery;", "()V", "connected", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getConnected", "()Lcom/jetbrains/rd/util/reactive/Property;", "contexts", "Lcom/jetbrains/rd/framework/impl/ProtocolContexts;", "getContexts", "()Lcom/jetbrains/rd/framework/impl/ProtocolContexts;", "contextsInternal", "heartbeatAlive", "getHeartbeatAlive", "heartbeatIntervalMs", "", "getHeartbeatIntervalMs", "()J", "setHeartbeatIntervalMs", "(J)V", "messageBroker", "Lcom/jetbrains/rd/framework/MessageBroker;", "getMessageBroker", "()Lcom/jetbrains/rd/framework/MessageBroker;", "advise", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "entity", "Lcom/jetbrains/rd/framework/base/IRdWireable;", "dumpToString", "", "send", "id", "Lcom/jetbrains/rd/framework/RdId;", "writer", "Lkotlin/Function1;", "Lcom/jetbrains/rd/framework/AbstractBuffer;", "setupContexts", "newContexts", "startDeliveringMessages", "tryGetById", "rdId", "rd-framework"})
@SourceDebugExtension(value={"SMAP\nWireBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireBase.kt\ncom/jetbrains/rd/framework/base/WireBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public abstract class WireBase
implements IWireWithDelayedDelivery {
    private ProtocolContexts contextsInternal;
    @NotNull
    private final Property<Boolean> connected = new Property<Boolean>(false);
    @NotNull
    private final Property<Boolean> heartbeatAlive = new Property<Boolean>(false);
    @NotNull
    private final MessageBroker messageBroker = new MessageBroker(true);
    private long heartbeatIntervalMs = 500L;

    @NotNull
    public final Property<Boolean> getConnected() {
        return this.connected;
    }

    @Override
    @NotNull
    public Property<Boolean> getHeartbeatAlive() {
        return this.heartbeatAlive;
    }

    @NotNull
    protected final MessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    @Override
    public void advise(@NotNull Lifetime lifetime, @NotNull IRdWireable entity) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.messageBroker.adviseOn(lifetime, entity);
    }

    @NotNull
    public final String dumpToString() {
        return IPrintableKt.printToString(this.messageBroker);
    }

    @Override
    public void startDeliveringMessages() {
        this.messageBroker.startDeliveringMessages();
    }

    @Override
    @NotNull
    public ProtocolContexts getContexts() {
        ProtocolContexts protocolContexts = this.contextsInternal;
        if (protocolContexts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contextsInternal");
            protocolContexts = null;
        }
        return protocolContexts;
    }

    @Override
    public long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    @Override
    public void setHeartbeatIntervalMs(long l) {
        this.heartbeatIntervalMs = l;
    }

    @Override
    public abstract void send(@NotNull RdId var1, @NotNull Function1<? super AbstractBuffer, Unit> var2);

    @Override
    public void setupContexts(@NotNull ProtocolContexts newContexts) {
        Intrinsics.checkNotNullParameter((Object)newContexts, (String)"newContexts");
        if (!(this.contextsInternal == null)) {
            boolean bl = false;
            String string2 = "Can't replace ProtocolContexts in IWire";
            throw new IllegalArgumentException(string2.toString());
        }
        this.contextsInternal = newContexts;
    }

    @Override
    @Nullable
    public IRdWireable tryGetById(@NotNull RdId rdId2) {
        Intrinsics.checkNotNullParameter((Object)rdId2, (String)"rdId");
        return this.messageBroker.tryGetById(rdId2);
    }
}

