/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetadataStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0015\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0015H$J \u0010\"\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\b\u0010$\u001a\u00020\u000fH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataDecompiler;", "V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "expectedBinaryVersion", "invalidBinaryVersion", "(Lcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "metadataStubBuilder", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "getMetadataStubBuilder", "()Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "virtualFile", "buildDecompiledTextForTests", "buildDecompiledTextForTests$native", "createFileViewProvider", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinDecompiledFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "doReadFile", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "getDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "getStubBuilder", "readFileSafely", "native"})
@SourceDebugExtension(value={"SMAP\nKlibMetadataDecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibMetadataDecompiler.kt\norg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataDecompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public abstract class KlibMetadataDecompiler<V extends BinaryVersion>
extends ClassFileDecompilers.Full {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final FlexibleTypeDeserializer flexibleTypeDeserializer;
    @NotNull
    private final Function0<V> expectedBinaryVersion;
    @NotNull
    private final Function0<V> invalidBinaryVersion;

    public KlibMetadataDecompiler(@NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer, @NotNull Function0<? extends V> expectedBinaryVersion, @NotNull Function0<? extends V> invalidBinaryVersion) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter((Object)flexibleTypeDeserializer, (String)"flexibleTypeDeserializer");
        Intrinsics.checkNotNullParameter(expectedBinaryVersion, (String)"expectedBinaryVersion");
        Intrinsics.checkNotNullParameter(invalidBinaryVersion, (String)"invalidBinaryVersion");
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.flexibleTypeDeserializer = flexibleTypeDeserializer;
        this.expectedBinaryVersion = expectedBinaryVersion;
        this.invalidBinaryVersion = invalidBinaryVersion;
    }

    @NotNull
    protected abstract KlibMetadataStubBuilder getMetadataStubBuilder();

    @Nullable
    protected abstract FileWithMetadata doReadFile(@NotNull VirtualFile var1);

    @NotNull
    protected abstract DecompiledText getDecompiledText(@NotNull FileWithMetadata.Compatible var1, @NotNull SerializerExtensionProtocol var2, @NotNull FlexibleTypeDeserializer var3);

    public boolean accepts(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileTypeRegistry.getInstance().isFileOfType(file, this.fileType);
    }

    @NotNull
    public KlibMetadataStubBuilder getStubBuilder() {
        return this.getMetadataStubBuilder();
    }

    @NotNull
    public KotlinDecompiledFileViewProvider createFileViewProvider(@NotNull VirtualFile file, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return new KotlinDecompiledFileViewProvider(manager, file, physical, (Function1<? super KotlinDecompiledFileViewProvider, ? extends KtDecompiledFile>)((Function1)new Function1<KotlinDecompiledFileViewProvider, KtDecompiledFile>(this){
            final /* synthetic */ KlibMetadataDecompiler<V> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final KtDecompiledFile invoke(@NotNull KotlinDecompiledFileViewProvider provider2) {
                Intrinsics.checkNotNullParameter((Object)((Object)provider2), (String)"provider");
                return new KlibDecompiledFile(provider2, (Function1<? super VirtualFile, DecompiledText>)((Function1)new Function1<VirtualFile, DecompiledText>(this.this$0){

                    @NotNull
                    public final DecompiledText invoke(@NotNull VirtualFile p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return KlibMetadataDecompiler.access$buildDecompiledText((KlibMetadataDecompiler)((Object)this.receiver), p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "buildDecompiledText(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;";
                    }

                    @NotNull
                    public final String getName() {
                        return "buildDecompiledText";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KlibMetadataDecompiler.class);
                    }
                }));
            }
        }));
    }

    @Nullable
    protected final FileWithMetadata readFileSafely(@NotNull VirtualFile file) {
        FileWithMetadata fileWithMetadata;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid()) {
            return null;
        }
        try {
            fileWithMetadata = this.doReadFile(file);
        }
        catch (IOException e) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    private final DecompiledText buildDecompiledText(VirtualFile virtualFile) {
        DecompiledText decompiledText2;
        boolean bl = FileTypeRegistry.getInstance().isFileOfType(virtualFile, this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Unexpected file type " + virtualFile.getFileType();
            throw new AssertionError((Object)string);
        }
        FileWithMetadata file = this.readFileSafely(virtualFile);
        if (file instanceof FileWithMetadata.Incompatible) {
            decompiledText2 = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)this.expectedBinaryVersion.invoke(), ((FileWithMetadata.Incompatible)file).getVersion());
        } else if (file instanceof FileWithMetadata.Compatible) {
            decompiledText2 = this.getDecompiledText((FileWithMetadata.Compatible)file, (SerializerExtensionProtocol)this.serializerProtocol.invoke(), this.flexibleTypeDeserializer);
        } else if (file == null) {
            decompiledText2 = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)this.expectedBinaryVersion.invoke(), (BinaryVersion)this.invalidBinaryVersion.invoke());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return decompiledText2;
    }

    @NotNull
    public final DecompiledText buildDecompiledTextForTests$native(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.buildDecompiledText(virtualFile);
    }

    public static final /* synthetic */ DecompiledText access$buildDecompiledText(KlibMetadataDecompiler $this, VirtualFile virtualFile) {
        return $this.buildDecompiledText(virtualFile);
    }
}

