/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.impl;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.completion.ml.personalization.UserFactor;
import com.intellij.completion.ml.personalization.UserFactorDescriptions;
import com.intellij.completion.ml.personalization.UserFactorStorage;
import com.intellij.completion.ml.personalization.impl.CompletionTypeReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/completion/ml/personalization/impl/CompletionTypeRatio;", "Lcom/intellij/completion/ml/personalization/UserFactor;", "type", "Lcom/intellij/codeInsight/completion/CompletionType;", "(Lcom/intellij/codeInsight/completion/CompletionType;)V", "id", "", "getId", "()Ljava/lang/String;", "compute", "storage", "Lcom/intellij/completion/ml/personalization/UserFactorStorage;", "intellij.completionMlRanking"})
public final class CompletionTypeRatio
implements UserFactor {
    @NotNull
    private final CompletionType type;
    @NotNull
    private final String id;

    public CompletionTypeRatio(@NotNull CompletionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        this.id = "CompletionTypeRatioOf" + this.type;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String compute(@NotNull UserFactorStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        CompletionTypeReader reader = storage.getFactorReader(UserFactorDescriptions.INSTANCE.getCOMPLETION_TYPE());
        double total = reader.getTotalCompletionCount();
        return total == 0.0 ? "0.0" : String.valueOf(reader.getCompletionCountByType(this.type) / total);
    }
}

