/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.jvmcompat;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.Year;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.jvmcompat.ClassFileData;
import org.jetbrains.plugins.gradle.jvmcompat.CompatibilityInfoGeneratorKt;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityState;
import org.jetbrains.plugins.gradle.jvmcompat.VersionMapping;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0001\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0019\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\u0002\u0010\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0005\u001a\u0012\u0010\u0012\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0019\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u00a8\u0006\u001a"}, d2={"createCopyrightComment", "", "generateJvmSupportMatrices", "", "json", "Ljava/nio/file/Path;", "kt", "applicationVersion", "copyrightComment", "getGeneratedString", "data", "Lorg/jetbrains/plugins/gradle/jvmcompat/ClassFileData;", "main", "args", "", "([Ljava/lang/String;)V", "readAppVersion", "appInfoPath", "requireNonNullElse", "s", "printCompatibility", "", "Lorg/jetbrains/plugins/gradle/jvmcompat/VersionMapping;", "indentPrefix", "printGradleVersions", "printJavaVersions", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nCompatibilityInfoGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompatibilityInfoGenerator.kt\norg/jetbrains/plugins/gradle/jvmcompat/CompatibilityInfoGeneratorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,166:1\n1#2:167\n1477#3:168\n1502#3,3:169\n1505#3,3:179\n372#4,7:172\n*S KotlinDebug\n*F\n+ 1 CompatibilityInfoGenerator.kt\norg/jetbrains/plugins/gradle/jvmcompat/CompatibilityInfoGeneratorKt\n*L\n153#1:168\n153#1:169,3\n153#1:179,3\n153#1:172,7\n*E\n"})
public final class CompatibilityInfoGeneratorKt {
    public static final void main(@NotNull String[] args) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        boolean bl2 = bl = args.length == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CompatibilityInfoGeneratorKt$main$22 = false;
            String $i$a$-assert-CompatibilityInfoGeneratorKt$main$22 = "Should be 1 arg: Path to project";
            throw new AssertionError((Object)$i$a$-assert-CompatibilityInfoGeneratorKt$main$22);
        }
        Path projectPath = Paths.get(args[0], new String[0]);
        Path compatibilityJsonPath = projectPath.resolve("community/plugins/gradle/resources/compatibility/compatibility.json");
        Path generatedDataPath = projectPath.resolve("community/plugins/gradle/generated/GradleJvmSupportDefaultData.kt");
        Path applicationInfoPath = projectPath.resolve("ultimate/ultimate-resources/resources/idea/ApplicationInfo.xml");
        Intrinsics.checkNotNull((Object)applicationInfoPath);
        String applicationVersion = CompatibilityInfoGeneratorKt.readAppVersion(applicationInfoPath);
        Intrinsics.checkNotNull((Object)compatibilityJsonPath);
        Intrinsics.checkNotNull((Object)generatedDataPath);
        CompatibilityInfoGeneratorKt.generateJvmSupportMatrices(compatibilityJsonPath, generatedDataPath, applicationVersion);
    }

    @NotNull
    public static final String createCopyrightComment() {
        int year = Year.now().getValue();
        return "// Copyright 2000-" + year + " JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.";
    }

    public static final void generateJvmSupportMatrices(@NotNull Path json, @NotNull Path kt, @NotNull String applicationVersion) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)kt, (String)"kt");
        Intrinsics.checkNotNullParameter((Object)applicationVersion, (String)"applicationVersion");
        CompatibilityInfoGeneratorKt.generateJvmSupportMatrices(json, kt, applicationVersion, CompatibilityInfoGeneratorKt.createCopyrightComment());
    }

    public static final void generateJvmSupportMatrices(@NotNull Path json, @NotNull Path kt, @NotNull String applicationVersion, @NotNull String copyrightComment) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)kt, (String)"kt");
        Intrinsics.checkNotNullParameter((Object)applicationVersion, (String)"applicationVersion");
        Intrinsics.checkNotNullParameter((Object)copyrightComment, (String)"copyrightComment");
        String jsonData = PathsKt.readText((Path)json, (Charset)Charsets.UTF_8);
        GradleCompatibilityState gradleCompatibilityState = (GradleCompatibilityState)((Object)GradleCompatibilityDataParser.INSTANCE.parseVersionedJson(jsonData, applicationVersion));
        if (gradleCompatibilityState == null) {
            throw new IllegalStateException("Cannot get compatibility data");
        }
        GradleCompatibilityState parsedData = gradleCompatibilityState;
        if (StringsKt.contains$default((CharSequence)copyrightComment, (char)'\n', (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("Copyright should be in single line");
        }
        ClassFileData classFileData = new ClassFileData(copyrightComment, parsedData);
        String fileData = CompatibilityInfoGeneratorKt.getGeneratedString(classFileData);
        File file = kt.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.writeText((File)file, (String)fileData, (Charset)Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final String readAppVersion(@NotNull Path appInfoPath) {
        Iterator<Attribute> iterator;
        boolean eap;
        String suffix;
        String patch;
        String micro;
        String minor;
        String major;
        String fullVersionFormat;
        Intrinsics.checkNotNullParameter((Object)appInfoPath, (String)"appInfoPath");
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        Intrinsics.checkNotNullExpressionValue((Object)xMLInputFactory, (String)"newInstance(...)");
        XMLInputFactory xmlInputFactory = xMLInputFactory;
        Closeable closeable = new BufferedInputStream(new FileInputStream(appInfoPath.toFile()));
        Throwable throwable = null;
        try {
            XMLEvent startElement;
            block22: {
                BufferedInputStream bis = (BufferedInputStream)closeable;
                boolean bl = false;
                XMLEventReader reader = xmlInputFactory.createXMLEventReader(bis);
                XMLEvent startDocument = reader.nextEvent();
                boolean bl2 = startDocument.isStartDocument();
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (!reader.hasNext()) throw new IllegalArgumentException(appInfoPath.toFile() + " is not ApplicationInfo.xml");
                XMLEvent startElement2 = reader.nextEvent();
                if (!startElement2.isStartElement()) throw new IllegalArgumentException(appInfoPath.toFile() + " is not ApplicationInfo.xml");
                if (!Intrinsics.areEqual((Object)startElement2.asStartElement().getName().getLocalPart(), (Object)"component")) {
                    throw new IllegalArgumentException(appInfoPath.toFile() + " is not ApplicationInfo.xml");
                }
                fullVersionFormat = null;
                major = null;
                minor = null;
                micro = null;
                patch = null;
                suffix = null;
                eap = false;
                while (reader.hasNext()) {
                    startElement = reader.nextEvent();
                    if (!startElement.isStartElement() || !Intrinsics.areEqual((Object)startElement.asStartElement().getName().getLocalPart(), (Object)"version")) continue;
                    break block22;
                }
                Unit unit = Unit.INSTANCE;
                throw new IllegalArgumentException("What a Terrible Failure! " + appInfoPath.toFile() + " is not ApplicationInfo.xml");
            }
            iterator = startElement.asStartElement().getAttributes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        while (iterator.hasNext()) {
            block25: {
                Attribute attribute;
                block29: {
                    block28: {
                        block24: {
                            block27: {
                                block26: {
                                    attribute = iterator.next();
                                    String string3 = attribute.getName().getLocalPart();
                                    if (string3 == null) continue;
                                    switch (string3.hashCode()) {
                                        case 106438728: {
                                            if (string3.equals("patch")) break block24;
                                            break block25;
                                        }
                                        case 103658937: {
                                            if (string3.equals("major")) break;
                                            break block25;
                                        }
                                        case 103901109: {
                                            if (string3.equals("minor")) break block26;
                                            break block25;
                                        }
                                        case 103890628: {
                                            if (string3.equals("micro")) break block27;
                                            break block25;
                                        }
                                        case 100180: {
                                            if (string3.equals("eap")) break block28;
                                            break block25;
                                        }
                                        case -891422895: {
                                            if (string3.equals("suffix")) break block29;
                                            break block25;
                                        }
                                        case 3154575: {
                                            if (string3.equals("full")) {
                                                fullVersionFormat = attribute.getValue();
                                            }
                                            break block25;
                                        }
                                    }
                                    major = attribute.getValue();
                                    continue;
                                }
                                minor = attribute.getValue();
                                continue;
                            }
                            micro = attribute.getValue();
                            continue;
                        }
                        patch = attribute.getValue();
                        continue;
                    }
                    eap = Boolean.parseBoolean(attribute.getValue());
                    continue;
                }
                suffix = attribute.getValue();
            }
        }
        if (suffix == null) {
            suffix = eap ? " EAP" : "";
        }
        if (fullVersionFormat == null) return CompatibilityInfoGeneratorKt.requireNonNullElse(major) + "." + CompatibilityInfoGeneratorKt.requireNonNullElse(minor) + suffix;
        Object[] objectArray = new Object[]{major, minor, micro, patch};
        return MessageFormat.format(fullVersionFormat, objectArray) + suffix;
    }

    private static final String requireNonNullElse(String s) {
        String string2 = s;
        if (string2 == null) {
            string2 = "0";
        }
        return string2;
    }

    @NotNull
    public static final String getGeneratedString(@NotNull ClassFileData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return StringsKt.trimMargin$default((String)("\n    |" + data.getCopyrightComment() + "\n    |\n    |package org.jetbrains.plugins.gradle.jvmcompat;\n    |\n    |import com.intellij.openapi.application.ApplicationInfo\n    |import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityState\n    |\n    |/**\n    | * NOTE THIS FILE IS AUTO-GENERATED\n    | * DO NOT EDIT IT BY HAND, run \"Generate Gradle Compatibility Matrix\" configuration instead\n    | */\n    |internal val DEFAULT_DATA = GradleCompatibilityState(\n    |  supportedJavaVersions = listOf(\n    " + CompatibilityInfoGeneratorKt.printJavaVersions(data.getParsedData().getSupportedJavaVersions(), "|    ") + "\n    |  ),\n    |  supportedGradleVersions = listOf(\n    " + CompatibilityInfoGeneratorKt.printGradleVersions(data.getParsedData().getSupportedGradleVersions(), "|    ") + "\n    |  ),\n    |  compatibility = listOf(\n    " + CompatibilityInfoGeneratorKt.printCompatibility(data.getParsedData().getCompatibility(), "|    ") + "\n    |  )\n    |);\n  "), null, (int)1, null);
    }

    private static final String printCompatibility(List<VersionMapping> $this$printCompatibility, String indentPrefix) {
        return CollectionsKt.joinToString$default((Iterable)$this$printCompatibility, (CharSequence)("," + System.lineSeparator()), null, null, (int)0, null, (Function1)((Function1)new Function1<VersionMapping, CharSequence>(indentPrefix){
            final /* synthetic */ String $indentPrefix;
            {
                this.$indentPrefix = $indentPrefix;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull VersionMapping it) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                String string2 = this.$indentPrefix;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.append(string2);
                $this$invoke_u24lambda_u240.append("VersionMapping(java = \"");
                $this$invoke_u24lambda_u240.append(it.getJavaVersionInfo());
                $this$invoke_u24lambda_u240.append("\", gradle = \"");
                $this$invoke_u24lambda_u240.append(it.getGradleVersionInfo());
                $this$invoke_u24lambda_u240.append("\")");
                String string3 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                return string3;
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String printGradleVersions(List<String> $this$printGradleVersions, String indentPrefix) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$printGradleVersions;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"."};
            String key$iv$iv = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)destination$iv$iv.values(), (CharSequence)("," + System.lineSeparator()), null, null, (int)0, null, (Function1)((Function1)new Function1<List<? extends String>, CharSequence>(indentPrefix){
            final /* synthetic */ String $indentPrefix;
            {
                this.$indentPrefix = $indentPrefix;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull List<String> versions) {
                Intrinsics.checkNotNullParameter(versions, (String)"versions");
                return this.$indentPrefix + CollectionsKt.joinToString$default((Iterable)versions, (CharSequence)", ", null, null, (int)0, null, (Function1)printGradleVersions.1.INSTANCE, (int)30, null);
            }
        }), (int)30, null);
    }

    private static final String printJavaVersions(List<String> $this$printJavaVersions, String indentPrefix) {
        return indentPrefix + CollectionsKt.joinToString$default((Iterable)$this$printJavaVersions, (CharSequence)", ", null, null, (int)0, null, (Function1)printJavaVersions.1.INSTANCE, (int)30, null);
    }
}

