/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/EnsureInstalledWrapperExecutionTask;", "Lcom/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask;", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "Ljava/nio/file/Path;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Lorg/gradle/util/GradleVersion;)V", "newCancellationTokenSource", "Lorg/gradle/tooling/CancellationTokenSource;", "kotlin.jvm.PlatformType", "progressNotificationManager", "Lcom/intellij/openapi/externalSystem/service/remote/ExternalSystemProgressNotificationManagerImpl;", "createExecutionSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "doCancel", "", "doExecute", "", "ensureInstalledWrapper", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "getDistributionType", "Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "getGradleHome", "", "intellij.gradle.common"})
final class EnsureInstalledWrapperExecutionTask
extends AbstractExternalSystemTask {
    @NotNull
    private final GradleVersion gradleVersion;
    @NotNull
    private final ExternalSystemProgressNotificationManagerImpl progressNotificationManager;
    private final CancellationTokenSource newCancellationTokenSource;

    public EnsureInstalledWrapperExecutionTask(@NotNull Project project, @NotNull Path externalProjectPath2, @NotNull GradleVersion gradleVersion2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        super(GradleConstants.SYSTEM_ID, ExternalSystemTaskType.EXECUTE_TASK, project, PathKt.getSystemIndependentPath((Path)externalProjectPath2));
        this.gradleVersion = gradleVersion2;
        this.progressNotificationManager = ExternalSystemProgressNotificationManagerImpl.Companion.getInstanceImpl();
        this.newCancellationTokenSource = GradleConnector.newCancellationTokenSource();
    }

    private final GradleExecutionSettings createExecutionSettings() {
        GradleSettings gradleSettings = GradleSettings.getInstance(this.getIdeProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        GradleExecutionSettings executionSettings = new GradleExecutionSettings(this.getGradleHome(), settings2.getServiceDirectoryPath(), this.getDistributionType(), settings2.getGradleVmOptions(), settings2.isOfflineWork());
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        executionSettings.setJavaHome(jdkProvider.getInternalJdk().getHomePath());
        ProjectSystemId projectSystemId = this.getExternalSystemId();
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"getExternalSystemId(...)");
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.Companion.getExtensions(projectSystemId)) {
            String string2 = this.getExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalProjectPath(...)");
            Project project = this.getIdeProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getIdeProject(...)");
            TargetEnvironmentConfigurationProvider environmentConfigurationProvider = executionAware.getEnvironmentConfigurationProvider(string2, false, project);
            if (environmentConfigurationProvider == null) continue;
            ExternalSystemExecutionAware.Companion.setEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)executionSettings, environmentConfigurationProvider);
            break;
        }
        return executionSettings;
    }

    private final String getGradleHome() {
        File gradleHome2;
        GradleInstallationManager installationManager = GradleInstallationManager.getInstance();
        File file = gradleHome2 = installationManager.getGradleHome(this.getIdeProject(), this.getExternalProjectPath());
        return FileUtil.toCanonicalPath((String)(file != null ? file.getPath() : null));
    }

    private final DistributionType getDistributionType() {
        DistributionType distributionType;
        GradleSettings gradleSettings = GradleSettings.getInstance(this.getIdeProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        GradleProjectSettings projectSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(this.getExternalProjectPath());
        GradleProjectSettings gradleProjectSettings = projectSettings;
        if (gradleProjectSettings != null) {
            DistributionType distributionType2 = gradleProjectSettings.getDistributionType();
            if (distributionType2 == null) {
                distributionType2 = DistributionType.LOCAL;
            }
            DistributionType distributionType3 = distributionType2;
            Intrinsics.checkNotNull((Object)((Object)distributionType3));
            distributionType = distributionType3;
        } else {
            distributionType = GradleUtil.isGradleDefaultWrapperFilesExist(this.getExternalProjectPath()) ? DistributionType.DEFAULT_WRAPPED : DistributionType.BUNDLED;
        }
        return distributionType;
    }

    private final void ensureInstalledWrapper(ExternalSystemTaskNotificationListener listener2) {
        new GradleExecutionHelper().ensureInstalledWrapper(this.getId(), this.getExternalProjectPath(), this.createExecutionSettings(), this.gradleVersion, listener2, this.newCancellationTokenSource.token());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = AbstractExternalSystemTask.wrapWithListener((ExternalSystemProgressNotificationManagerImpl)this.progressNotificationManager);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskNotificationListener, (String)"wrapWithListener(...)");
        ExternalSystemTaskNotificationListener progressNotificationListener = externalSystemTaskNotificationListener;
        try {
            ExternalSystemTaskId externalSystemTaskId = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"getId(...)");
            String string2 = this.getExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalProjectPath(...)");
            this.progressNotificationManager.onStart(externalSystemTaskId, string2);
            this.ensureInstalledWrapper(progressNotificationListener);
            ExternalSystemTaskId externalSystemTaskId2 = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId2, (String)"getId(...)");
            this.progressNotificationManager.onSuccess(externalSystemTaskId2);
        }
        catch (ProcessCanceledException e) {
            ExternalSystemTaskId externalSystemTaskId = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"getId(...)");
            this.progressNotificationManager.onCancel(externalSystemTaskId);
            throw e;
        }
        catch (Exception e) {
            ExternalSystemTaskId externalSystemTaskId = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"getId(...)");
            this.progressNotificationManager.onFailure(externalSystemTaskId, e);
            throw e;
        }
        finally {
            ExternalSystemTaskId externalSystemTaskId = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"getId(...)");
            this.progressNotificationManager.onEnd(externalSystemTaskId);
        }
    }

    protected boolean doCancel() {
        ExternalSystemTaskId externalSystemTaskId = this.getId();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"getId(...)");
        this.progressNotificationManager.beforeCancel(externalSystemTaskId);
        this.newCancellationTokenSource.cancel();
        ExternalSystemTaskId externalSystemTaskId2 = this.getId();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId2, (String)"getId(...)");
        this.progressNotificationManager.onCancel(externalSystemTaskId2);
        return true;
    }
}

