/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.startup.GradleProjectSettingsUpdater;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J:\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001a\u0010\u000e\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater;", "Lcom/intellij/openapi/externalSystem/settings/ExternalSystemSettingsListenerEx;", "()V", "notifyGradleJvmChangeInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "gradleJvm", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "onProjectsLoaded", "manager", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "settings", "", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "showGradleProjectSettings", "externalProjectPath", "UpdatedSdkStatus", "Util", "intellij.gradle.common"})
public final class GradleProjectSettingsUpdater
implements ExternalSystemSettingsListenerEx {
    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (Registry.is((String)"gradle.auto.auto.jdk.fix.disabled")) {
            return;
        }
        if (!(manager instanceof GradleManager)) {
            return;
        }
        for (ExternalProjectSettings externalProjectSettings : settings2) {
            if (!(externalProjectSettings instanceof GradleProjectSettings)) continue;
            CompletableFuture<UpdatedSdkStatus> statusFuture = Util.INSTANCE.updateGradleJvm(project, (GradleProjectSettings)externalProjectSettings);
            statusFuture.thenAccept(arg_0 -> GradleProjectSettingsUpdater.onProjectsLoaded$lambda$0((Function1)new Function1<UpdatedSdkStatus, Unit>(this, project, externalProjectSettings){
                final /* synthetic */ GradleProjectSettingsUpdater this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ ExternalProjectSettings $projectSettings;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$projectSettings = $projectSettings;
                    super(1);
                }

                public final void invoke(UpdatedSdkStatus it) {
                    if (it.getUpdated() && it.getSdkName() != null) {
                        GradleProjectSettingsUpdater.access$notifyGradleJvmChangeInfo(this.this$0, this.$project, (GradleProjectSettings)this.$projectSettings, it.getSdkName(), it.getSdk());
                    }
                }
            }, arg_0));
        }
    }

    private final void notifyGradleJvmChangeInfo(Project project, GradleProjectSettings projectSettings, String gradleJvm, Sdk sdk) {
        if (sdk == null) {
            return;
        }
        String string2 = sdk.getVersionString();
        if (string2 == null) {
            return;
        }
        String versionString = string2;
        String string3 = sdk.getHomePath();
        if (string3 == null) {
            return;
        }
        String homePath = string3;
        String string4 = projectSettings.getExternalProjectPath();
        if (string4 == null) {
            return;
        }
        String externalProjectPath2 = string4;
        String string5 = SdkListPresenter.presentDetectedSdkPath((String)homePath);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"presentDetectedSdkPath(...)");
        String presentablePath = string5;
        String notificationTitle = GradleBundle.message("gradle.notifications.java.home.change.title", new Object[0]);
        Object[] objectArray = new Object[]{gradleJvm, versionString, presentablePath};
        String notificationContent = GradleBundle.message("gradle.notifications.java.home.change.content", objectArray);
        Intrinsics.checkNotNull((Object)notificationTitle);
        Intrinsics.checkNotNull((Object)notificationContent);
        Notification notification = GradleNotification.NOTIFICATION_GROUP.createNotification(notificationTitle, notificationContent, NotificationType.INFORMATION);
        notification.setDisplayId("gradle.jvm.configured");
        notification.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.open.gradle.settings", new Object[0]), () -> GradleProjectSettingsUpdater.notifyGradleJvmChangeInfo$lambda$1(this, project, externalProjectPath2)));
        notification.notify(project);
    }

    private final void showGradleProjectSettings(Project project, String externalProjectPath2) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNull((Object)manager, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware");
        Configurable configurable = ((ExternalSystemConfigurableAware)manager).getConfigurable(project);
        Intrinsics.checkNotNullExpressionValue((Object)configurable, (String)"getConfigurable(...)");
        Configurable configurable2 = configurable;
        if (configurable2 instanceof AbstractExternalSystemConfigurable) {
            ShowSettingsUtil settingsUtil = ShowSettingsUtil.getInstance();
            settingsUtil.editConfigurable(project, configurable2, () -> GradleProjectSettingsUpdater.showGradleProjectSettings$lambda$2(configurable2, externalProjectPath2));
        }
    }

    private static final void onProjectsLoaded$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void notifyGradleJvmChangeInfo$lambda$1(GradleProjectSettingsUpdater this$0, Project $project, String $externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$externalProjectPath, (String)"$externalProjectPath");
        this$0.showGradleProjectSettings($project, $externalProjectPath);
    }

    private static final void showGradleProjectSettings$lambda$2(Configurable $configurable, String $externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)$configurable, (String)"$configurable");
        Intrinsics.checkNotNullParameter((Object)$externalProjectPath, (String)"$externalProjectPath");
        ((AbstractExternalSystemConfigurable)$configurable).selectProject($externalProjectPath);
    }

    public static final /* synthetic */ void access$notifyGradleJvmChangeInfo(GradleProjectSettingsUpdater $this, Project project, GradleProjectSettings projectSettings, String gradleJvm, Sdk sdk) {
        $this.notifyGradleJvmChangeInfo(project, projectSettings, gradleJvm, sdk);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$UpdatedSdkStatus;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkName", "", "updated", "", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Z)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSdkName", "()Ljava/lang/String;", "getUpdated", "()Z", "intellij.gradle.common"})
    public static final class UpdatedSdkStatus {
        @Nullable
        private final Sdk sdk;
        @Nullable
        private final String sdkName;
        private final boolean updated;

        public UpdatedSdkStatus(@Nullable Sdk sdk, @Nullable String sdkName, boolean updated) {
            this.sdk = sdk;
            this.sdkName = sdkName;
            this.updated = updated;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Nullable
        public final String getSdkName() {
            return this.sdkName;
        }

        public final boolean getUpdated() {
            return this.updated;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$Util;", "", "()V", "NOT_UPDATED_STATUS", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$UpdatedSdkStatus;", "kotlin.jvm.PlatformType", "findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "fixupInternalJdk", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "fixupUnknownSdk", "isInternalSdk", "", "jdkReference", "", "isSdkName", "isUnknownSdk", "sdkName", "updateGradleJvm", "intellij.gradle.common"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        private static final CompletableFuture<UpdatedSdkStatus> NOT_UPDATED_STATUS = CompletableFuture.completedFuture(new UpdatedSdkStatus(null, null, false));

        private Util() {
        }

        @NotNull
        public final CompletableFuture<UpdatedSdkStatus> updateGradleJvm(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
            CompletableFuture<UpdatedSdkStatus> completableFuture;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
            String string2 = projectSettings.getGradleJvm();
            if (string2 == null) {
                CompletableFuture<UpdatedSdkStatus> completableFuture2 = NOT_UPDATED_STATUS;
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"NOT_UPDATED_STATUS");
                return completableFuture2;
            }
            String gradleJvm = string2;
            if (this.isInternalSdk(gradleJvm)) {
                completableFuture = this.fixupInternalJdk(project, projectSettings);
            } else if (this.isSdkName(gradleJvm) && this.isUnknownSdk(gradleJvm)) {
                completableFuture = this.fixupUnknownSdk(project, projectSettings);
            } else {
                CompletableFuture<UpdatedSdkStatus> completableFuture3 = NOT_UPDATED_STATUS;
                completableFuture = completableFuture3;
                Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"NOT_UPDATED_STATUS");
            }
            return completableFuture;
        }

        private final CompletableFuture<UpdatedSdkStatus> fixupInternalJdk(Project project, GradleProjectSettings projectSettings) {
            ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
            Sdk sdk = jdkProvider.getInternalJdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInternalJdk(...)");
            Sdk internalSdk = sdk;
            projectSettings.setGradleJvm(internalSdk.getName());
            return this.fixupUnknownSdk(project, projectSettings);
        }

        private final CompletableFuture<UpdatedSdkStatus> fixupUnknownSdk(Project project, GradleProjectSettings projectSettings) {
            String string2 = projectSettings.getGradleJvm();
            if (string2 == null) {
                CompletableFuture<UpdatedSdkStatus> completableFuture = NOT_UPDATED_STATUS;
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"NOT_UPDATED_STATUS");
                return completableFuture;
            }
            String gradleJvm = string2;
            GradleVersion gradleVersion2 = projectSettings.resolveGradleVersion();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"resolveGradleVersion(...)");
            GradleVersion gradleVersion3 = gradleVersion2;
            CompletableFuture<UpdatedSdkStatus> future = new CompletableFuture<UpdatedSdkStatus>();
            projectSettings.setGradleJvm(null);
            SdkLookupBuilder sdkLookupBuilder = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, projectSettings).newLookupBuilder().withSdkName(gradleJvm).withVersionFilter((Function1)new Function1<String, Boolean>(gradleVersion3){
                final /* synthetic */ GradleVersion $gradleVersion;
                {
                    this.$gradleVersion = $gradleVersion;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JavaVersion javaVersion = JavaVersion.tryParse((String)it);
                    return javaVersion != null && GradleJvmSupportMatrix.Companion.isJavaSupportedByIdea(javaVersion) && GradleJvmSupportMatrix.Companion.isSupported(this.$gradleVersion, javaVersion);
                }
            });
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType(...)");
            sdkLookupBuilder.withSdkType(sdkType).withSdkHomeFilter((Function1)fixupUnknownSdk.2.INSTANCE).onSdkNameResolved((Function1)new Function1<Sdk, Unit>(projectSettings){
                final /* synthetic */ GradleProjectSettings $projectSettings;
                {
                    this.$projectSettings = $projectSettings;
                    super(1);
                }

                public final void invoke(@Nullable Sdk sdk) {
                    Sdk fakeSdk;
                    Sdk sdk2 = sdk;
                    if (sdk2 != null) {
                        Sdk sdk3 = sdk2;
                        Util util = Util.INSTANCE;
                        Sdk p0 = sdk3;
                        boolean bl = false;
                        v1 = Util.access$findRegisteredSdk(util, p0);
                    } else {
                        v1 = fakeSdk = null;
                    }
                    if (fakeSdk != null && this.$projectSettings.getGradleJvm() == null) {
                        this.$projectSettings.setGradleJvm(fakeSdk.getName());
                    }
                }
            }).onSdkResolved((Function1)new Function1<Sdk, Unit>(projectSettings, gradleJvm, future){
                final /* synthetic */ GradleProjectSettings $projectSettings;
                final /* synthetic */ String $gradleJvm;
                final /* synthetic */ CompletableFuture<UpdatedSdkStatus> $future;
                {
                    this.$projectSettings = $projectSettings;
                    this.$gradleJvm = $gradleJvm;
                    this.$future = $future;
                    super(1);
                }

                public final void invoke(@Nullable Sdk sdk) {
                    if (this.$projectSettings.getGradleJvm() == null) {
                        Object object = sdk;
                        if (object == null || (object = object.getName()) == null) {
                            object = this.$gradleJvm;
                        }
                        this.$projectSettings.setGradleJvm((String)object);
                    }
                    this.$future.complete(new UpdatedSdkStatus(sdk, this.$gradleJvm, true));
                }
            }).executeLookup();
            return future;
        }

        private final boolean isUnknownSdk(String sdkName) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            Sdk sdk = projectJdkTable.findJdk(sdkName);
            return sdk == null;
        }

        private final boolean isSdkName(String jdkReference) {
            return jdkReference != null && !StringsKt.startsWith$default((CharSequence)jdkReference, (char)'#', (boolean)false, (int)2, null);
        }

        private final boolean isInternalSdk(String jdkReference) {
            return Intrinsics.areEqual((Object)jdkReference, (Object)"#JAVA_INTERNAL");
        }

        private final Sdk findRegisteredSdk(Sdk sdk) {
            return (Sdk)ActionsKt.runReadAction((Function0)((Function0)new Function0<Sdk>(sdk){
                final /* synthetic */ Sdk $sdk;
                {
                    this.$sdk = $sdk;
                    super(0);
                }

                @Nullable
                public final Sdk invoke() {
                    ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                    return projectJdkTable.findJdk(this.$sdk.getName(), this.$sdk.getSdkType().getName());
                }
            }));
        }

        public static final /* synthetic */ Sdk access$findRegisteredSdk(Util $this, Sdk sdk) {
            return $this.findRegisteredSdk(sdk);
        }
    }
}

