/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.sudo.ExecSudoCommandKt;
import com.intellij.profiler.sudo.SendResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\"\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getChildrenProcessIDs", "", "", "myPid", "isProcessAlive", "", "pid", "killSudoProcessTreeSync", "process", "Ljava/lang/Process;", "sudoPassword", "", "signal", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProcessUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessUtil.kt\ncom/intellij/profiler/ProcessUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1855#2,2:49\n*S KotlinDebug\n*F\n+ 1 ProcessUtil.kt\ncom/intellij/profiler/ProcessUtilKt\n*L\n23#1:49,2\n*E\n"})
public final class ProcessUtilKt {
    @NotNull
    private static final Logger LOG;

    public static final boolean isProcessAlive(int pid) {
        return ProcessHandle.of(pid).isPresent();
    }

    public static final boolean killSudoProcessTreeSync(@NotNull Process process, @NotNull String sudoPassword, int signal) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)sudoPassword, (String)"sudoPassword");
        int pid = OSProcessUtil.getProcessID((Process)process);
        List<Integer> children2 = ProcessUtilKt.getChildrenProcessIDs(pid);
        if (children2.isEmpty()) {
            LOG.warn("Can't find children of process " + pid + " (sudo process)");
        } else if (children2.size() > 1) {
            LOG.warn("Too many children of process " + pid + ": " + children2 + ". Will kill all of them anyway");
        }
        Iterable $this$forEach$iv = children2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            ExecSudoCommandKt.sudoSendSignal(it, signal, sudoPassword);
        }
        if (process.isAlive()) {
            return ExecSudoCommandKt.sudoSendSignal(pid, signal, sudoPassword) != SendResult.FAILED;
        }
        return true;
    }

    public static /* synthetic */ boolean killSudoProcessTreeSync$default(Process process, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 9;
        }
        return ProcessUtilKt.killSudoProcessTreeSync(process, string, n);
    }

    @NotNull
    public static final List<Integer> getChildrenProcessIDs(int myPid) {
        List list = new ArrayList();
        UnixProcessManager.processPSOutput((String[])UnixProcessManager.getPSCmd((boolean)false), arg_0 -> ProcessUtilKt.getChildrenProcessIDs$lambda$1(myPid, list, arg_0));
        return list;
    }

    private static final boolean getChildrenProcessIDs$lambda$1(int $myPid, List $list, String line) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        StringTokenizer st = new StringTokenizer(line, " ");
        String string = st.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextToken(...)");
        Integer parentPid = StringsKt.toIntOrNull((String)string);
        String string2 = st.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextToken(...)");
        Integer pid = StringsKt.toIntOrNull((String)string2);
        Integer n = parentPid;
        int n2 = $myPid;
        if (n != null && n == n2 && pid != null) {
            ((Collection)$list).add(pid);
        }
        return true;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.profiler.dummy.ProcessUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

