/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamechart;

import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorsKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005H$J\f\u0010\u0011\u001a\u00020\u0006*\u00020\u0005H\u0004J\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0005H\u0004R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "", "()V", "colorScheme", "", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "Lcom/intellij/ui/JBColor;", "getColorScheme", "()Ljava/util/Map;", "colorScheme$delegate", "Lkotlin/Lazy;", "color", "type", "convert", "getPrefix", "", "produce", "colorize", "shadow", "intellij.profiler.common"})
public abstract class FlameChartColorScheme {
    @NotNull
    private final Lazy colorScheme$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<ColorType, ? extends JBColor>>(this){
        final /* synthetic */ FlameChartColorScheme this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<ColorType, JBColor> invoke() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ColorType[] colorTypeArray = ColorType.values();
            FlameChartColorScheme flameChartColorScheme = this.this$0;
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it, (Object)FlameChartColorScheme.access$convert(flameChartColorScheme, (ColorType)it)));
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
    }));

    private final Map<ColorType, JBColor> getColorScheme() {
        Lazy lazy = this.colorScheme$delegate;
        return (Map)lazy.getValue();
    }

    private final JBColor convert(ColorType type) {
        String propName = "FlameGraph." + this.getPrefix() + "Cell." + FlameChartColorsKt.access$toStyle(type);
        return new JBColor(() -> FlameChartColorScheme.convert$lambda$1(propName, this, type));
    }

    @NotNull
    public String getPrefix() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @NotNull
    protected final JBColor colorize(@NotNull ColorType $this$colorize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$colorize), (String)"<this>");
        return new JBColor(() -> FlameChartColorScheme.colorize$lambda$2(this, $this$colorize));
    }

    @NotNull
    protected final JBColor shadow(@NotNull ColorType $this$shadow) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$shadow), (String)"<this>");
        return new JBColor(() -> FlameChartColorScheme.shadow$lambda$3(this, $this$shadow));
    }

    @NotNull
    public final JBColor color(@NotNull ColorType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        JBColor jBColor = this.getColorScheme().get((Object)type);
        if (jBColor == null) {
            throw new NoSuchElementException("Cannot find color for type " + this + "}");
        }
        return jBColor;
    }

    @NotNull
    protected abstract JBColor produce(@NotNull ColorType var1);

    private static final Color convert$lambda$1(String $propName, FlameChartColorScheme this$0, ColorType $type) {
        Color color2;
        Intrinsics.checkNotNullParameter((Object)$propName, (String)"$propName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Color color3 = UIManager.getColor($propName);
        if (color3 == null) {
            FlameChartColorScheme it = this$0;
            boolean bl = false;
            JBColor defaultColor = this$0.produce($type);
            UIManager.put($propName, defaultColor);
            color2 = (Color)defaultColor;
        } else {
            color2 = color3;
        }
        return color2;
    }

    private static final Color colorize$lambda$2(FlameChartColorScheme this$0, ColorType $this_colorize) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this_colorize), (String)"$this_colorize");
        return ColorUtil.mix((Color)((Color)this$0.color($this_colorize)), (Color)Color.BLACK, (double)0.75);
    }

    private static final Color shadow$lambda$3(FlameChartColorScheme this$0, ColorType $this_shadow) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this_shadow), (String)"$this_shadow");
        return ColorUtil.mix((Color)((Color)this$0.color($this_shadow)), (Color)Color.DARK_GRAY, (double)0.3);
    }

    public static final /* synthetic */ JBColor access$convert(FlameChartColorScheme $this, ColorType type) {
        return $this.convert(type);
    }
}

