/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0010H\u0086\b\u00f8\u0001\u0000J\u0012\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J>\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010 \u001a\u00020\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010$\u001a\u00020\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020%0\"2\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0004J\u0016\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010-\u001a\u00020\n2\u0006\u0010+\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010/\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u00100\u001a\u00020\n2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u00101\u001a\u00020\n2\u0006\u0010+\u001a\u0002022\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u00103\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u00104\u001a\u00020\nJ\u0006\u00105\u001a\u00020\nJ\u001c\u00106\u001a\u00020\n2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\"2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010<\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ1\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0@\"\u00020AH&\u00a2\u0006\u0002\u0010BJ)\u0010C\u001a\u00020\n2\u0006\u0010>\u001a\u00020\u00182\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0@\"\u00020AH\u0002\u00a2\u0006\u0002\u0010DJ6\u0010E\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0010H\u0086\b\u00f8\u0001\u0000J\u001c\u0010F\u001a\u00020\n2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0'2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010I\u001a\u00020\n2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0'2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010L\u001a\u00020\n2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0'2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010M\u001a\u00020\n2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\"2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010N\u001a\u00020\n2\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010O\u001a\u00020\n2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020H0\"2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010R\u001a\u00020\n2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020H0\"2\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010S\u001a\u00020\n2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020H0\"2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010T\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010U\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010V\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010W\u001a\u00020\nJ\u001a\u0010X\u001a\u00020\n2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\f0ZH\u0086\b\u00f8\u0001\u0000J\u001a\u0010[\u001a\u00020\n2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\f0ZH\u0086\b\u00f8\u0001\u0000R\u0018\u0010\u0003\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "", "()V", "numberOfNestedBlocks", "", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "buildBlock", "", "label", "", "resultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "body", "Lkotlin/Function1;", "buildBr", "absoluteBlockLevel", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "buildBrIf", "buildBrInstr", "brOp", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "buildBrOnCastInstr", "fromIsNullable", "", "toIsNullable", "from", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "to", "buildCall", "symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "buildCallIndirect", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "tableIdx", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "buildCatch", "tagIdx", "buildConstF32", "value", "", "buildConstF64", "", "buildConstI32", "buildConstI32Symbol", "buildConstI64", "", "buildDrop", "buildElse", "buildEnd", "buildGetGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "buildGetLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "buildIf", "buildInstr", "op", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildInstrWithNoLocation", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildLoop", "buildRefCastNullStatic", "toType", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "buildRefCastStatic", "buildRefNull", "type", "buildRefTestStatic", "buildSetGlobal", "buildSetLocal", "buildStructGet", "struct", "fieldId", "buildStructNew", "buildStructSet", "buildThrow", "buildTry", "buildUnreachable", "commentGroupEnd", "commentGroupStart", "text", "Lkotlin/Function0;", "commentPreviousInstr", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public abstract class WasmExpressionBuilder {
    public abstract void buildInstr(@NotNull WasmOp var1, @NotNull SourceLocation var2, WasmImmediate ... var3);

    public abstract int getNumberOfNestedBlocks();

    public abstract void setNumberOfNestedBlocks(int var1);

    public final void buildConstI32(int value, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI32(value)};
        this.buildInstr(WasmOp.I32_CONST, location, wasmImmediateArray);
    }

    public final void buildConstI64(long value, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI64(value)};
        this.buildInstr(WasmOp.I64_CONST, location, wasmImmediateArray);
    }

    public final void buildConstF32(float value, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF32(UInt.constructor-impl((int)Float.floatToRawIntBits(value)), null)};
        this.buildInstr(WasmOp.F32_CONST, location, wasmImmediateArray);
    }

    public final void buildConstF64(double value, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF64(ULong.constructor-impl((long)Double.doubleToRawLongBits(value)), null)};
        this.buildInstr(WasmOp.F64_CONST, location, wasmImmediateArray);
    }

    public final void buildConstI32Symbol(@NotNull WasmSymbol<Integer> value, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.SymbolI32(value)};
        this.buildInstr(WasmOp.I32_CONST, location, wasmImmediateArray);
    }

    public final void buildUnreachable(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.UNREACHABLE, location, new WasmImmediate[0]);
    }

    public final void buildBlock(@Nullable String label, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        boolean $i$f$buildBlock = false;
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        body2.invoke((Object)this.getNumberOfNestedBlocks());
        this.buildEnd();
    }

    public static /* synthetic */ void buildBlock$default(WasmExpressionBuilder $this, String label, WasmType resultType, Function1 body2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        boolean $i$f$buildBlock = false;
        int n2 = $this.getNumberOfNestedBlocks();
        $this.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        $this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        body2.invoke((Object)$this.getNumberOfNestedBlocks());
        $this.buildEnd();
    }

    public final void buildLoop(@Nullable String label, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        boolean $i$f$buildLoop = false;
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        body2.invoke((Object)this.getNumberOfNestedBlocks());
        this.buildEnd();
    }

    public static /* synthetic */ void buildLoop$default(WasmExpressionBuilder $this, String label, WasmType resultType, Function1 body2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildLoop");
        }
        if ((n & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        boolean $i$f$buildLoop = false;
        int n2 = $this.getNumberOfNestedBlocks();
        $this.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        $this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        body2.invoke((Object)$this.getNumberOfNestedBlocks());
        $this.buildEnd();
    }

    private final void buildInstrWithNoLocation(WasmOp op, WasmImmediate ... immediates) {
        this.buildInstr(op, SourceLocation.Companion.NoLocation(op.getMnemonic()), Arrays.copyOf(immediates, immediates.length));
    }

    public final void buildIf(@Nullable String label, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.IF, wasmImmediateArray);
    }

    public static /* synthetic */ void buildIf$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildIf");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildIf(string, wasmType);
    }

    public final void buildElse() {
        this.buildInstrWithNoLocation(WasmOp.ELSE, new WasmImmediate[0]);
    }

    public final int buildBlock(@Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.BLOCK, wasmImmediateArray);
        return this.getNumberOfNestedBlocks();
    }

    public static /* synthetic */ int buildBlock$default(WasmExpressionBuilder wasmExpressionBuilder, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 1) != 0) {
            wasmType = null;
        }
        return wasmExpressionBuilder.buildBlock(wasmType);
    }

    public final void buildEnd() {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + -1);
        this.buildInstrWithNoLocation(WasmOp.END, new WasmImmediate[0]);
    }

    public final void buildBrInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)brOp), (String)"brOp");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Negative relative block index";
            throw new AssertionError((Object)string);
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(relativeLevel)};
        this.buildInstr(brOp, location, wasmImmediateArray);
    }

    public final void buildBrOnCastInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, boolean fromIsNullable, boolean toIsNullable, @NotNull WasmHeapType from2, @NotNull WasmHeapType to, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)brOp), (String)"brOp");
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = false;
            String $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = "Negative relative block index";
            throw new AssertionError((Object)$i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22);
        }
        int fromTypeFlag = fromIsNullable ? 1 : 0;
        int toTypeFlag = toIsNullable ? 2 : 0;
        int flags = fromTypeFlag | toTypeFlag;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstU8(UByte.constructor-impl((byte)((byte)flags)), null), new WasmImmediate.LabelIdx(relativeLevel), new WasmImmediate.HeapType(from2), new WasmImmediate.HeapType(to)};
        this.buildInstr(brOp, location, wasmImmediateArray);
    }

    public final void buildBr(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildBrInstr(WasmOp.BR, absoluteBlockLevel, location);
    }

    public final void buildThrow(int tagIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstr(WasmOp.THROW, location, wasmImmediateArray);
    }

    public final void buildTry(@Nullable String label, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.TRY, wasmImmediateArray);
    }

    public static /* synthetic */ void buildTry$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildTry");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTry(string, wasmType);
    }

    public final void buildCatch(int tagIdx) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstrWithNoLocation(WasmOp.CATCH, wasmImmediateArray);
    }

    public final void buildBrIf(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildBrInstr(WasmOp.BR_IF, absoluteBlockLevel, location);
    }

    public final void buildCall(@NotNull WasmSymbol<? extends WasmFunction> symbol2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(symbol2)};
        this.buildInstr(WasmOp.CALL, location, wasmImmediateArray);
    }

    public final void buildCallIndirect(@NotNull WasmSymbol<WasmFunctionType> symbol2, @NotNull WasmSymbolReadOnly<Integer> tableIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter(tableIdx, (String)"tableIdx");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)symbol2), new WasmImmediate.TableIdx(tableIdx)};
        this.buildInstr(WasmOp.CALL_INDIRECT, location, wasmImmediateArray);
    }

    public static /* synthetic */ void buildCallIndirect$default(WasmExpressionBuilder wasmExpressionBuilder, WasmSymbol wasmSymbol, WasmSymbolReadOnly wasmSymbolReadOnly, SourceLocation sourceLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCallIndirect");
        }
        if ((n & 2) != 0) {
            wasmSymbolReadOnly = new WasmSymbol<Integer>(0);
        }
        wasmExpressionBuilder.buildCallIndirect(wasmSymbol, wasmSymbolReadOnly, sourceLocation);
    }

    public final void buildGetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_GET, location, wasmImmediateArray);
    }

    public final void buildSetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_SET, location, wasmImmediateArray);
    }

    public final void buildGetGlobal(@NotNull WasmSymbol<WasmGlobal> global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_GET, location, wasmImmediateArray);
    }

    public final void buildSetGlobal(@NotNull WasmSymbol<WasmGlobal> global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_SET, location, wasmImmediateArray);
    }

    public final void buildStructGet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_GET, location, wasmImmediateArray);
    }

    public final void buildStructNew(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct)};
        this.buildInstr(WasmOp.STRUCT_NEW, location, wasmImmediateArray);
    }

    public final void buildStructSet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_SET, location, wasmImmediateArray);
    }

    public final void buildRefCastNullStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_CAST_NULL, location, wasmImmediateArray);
    }

    public final void buildRefCastStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_CAST, location, wasmImmediateArray);
    }

    public final void buildRefTestStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_TEST, location, wasmImmediateArray);
    }

    public final void buildRefNull(@NotNull WasmHeapType type2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmRefType(type2))};
        this.buildInstr(WasmOp.REF_NULL, location, wasmImmediateArray);
    }

    public final void buildDrop(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.DROP, location, new WasmImmediate[0]);
    }

    public final void commentPreviousInstr(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstString((String)text.invoke())};
        this.buildInstr(WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR, SourceLocation.Companion.NoLocation("Pseudo-instruction"), wasmImmediateArray);
    }

    public final void commentGroupStart(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        boolean $i$f$commentGroupStart = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstString((String)text.invoke())};
        this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_START, SourceLocation.Companion.NoLocation("Pseudo-instruction"), wasmImmediateArray);
    }

    public final void commentGroupEnd() {
        this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_END, SourceLocation.Companion.NoLocation("Pseudo-instruction"), new WasmImmediate[0]);
    }
}

