/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.codeinsight.inspections.EditorConfigSpaceInHeaderInspectionKt;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveSpacesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigRemoveSpacesQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigRemoveSpacesQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveSpacesQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,22:1\n1855#2,2:23\n*S KotlinDebug\n*F\n+ 1 EditorConfigRemoveSpacesQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveSpacesQuickFix\n*L\n19#1:23,2\n*E\n"})
public final class EditorConfigRemoveSpacesQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.header.remove.spaces.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        EditorConfigHeader editorConfigHeader = psiElement instanceof EditorConfigHeader ? (EditorConfigHeader)psiElement : null;
        if (editorConfigHeader == null) {
            return;
        }
        EditorConfigHeader header = editorConfigHeader;
        CodeStyleManager manager = CodeStyleManager.getInstance((Project)project);
        List list = EditorConfigSpaceInHeaderInspectionKt.findSuspiciousSpaces(header).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List spaces = list;
        if (spaces.isEmpty()) {
            return;
        }
        manager.performActionWithFormatterDisabled(() -> EditorConfigRemoveSpacesQuickFix.applyFix$lambda$1(spaces));
    }

    private static final void applyFix$lambda$1(List $spaces) {
        Intrinsics.checkNotNullParameter((Object)$spaces, (String)"$spaces");
        Iterable $this$forEach$iv = $spaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.delete();
        }
    }
}

