/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.indices;

import ai.grazie.emb.FloatTextEmbedding;
import com.intellij.platform.ml.embeddings.search.indices.DiskSynchronizedEmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.EmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.EmbeddingSearchIndexKt;
import com.intellij.platform.ml.embeddings.search.indices.LocalEmbeddingIndexFileManager;
import com.intellij.platform.ml.embeddings.search.utils.ScoredText;
import com.intellij.util.containers.CollectionFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001FB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u00020\u001c2\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001f0#0\"H\u0016J\u0016\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(H\u0016J\b\u0010)\u001a\u00020&H\u0016J\u0011\u0010*\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u000bH\u0096\u0002J\u001a\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\b\b\u0002\u0010,\u001a\u00020&H\u0002J\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0010\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\u001c\u00102\u001a\u00020\u001c2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000504H\u0016J-\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u00052\b\u0010:\u001a\u0004\u0018\u00010;H\u0016\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\u001cH\u0016J\b\u0010>\u001a\u00020\u001cH\u0002J\b\u0010?\u001a\u00020\u001cH\u0002J\b\u0010@\u001a\u00020\u001cH\u0016J%\u0010A\u001a\b\u0012\u0004\u0012\u0002070B2\u0006\u00108\u001a\u00020\u001f2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016\u00a2\u0006\u0002\u0010CJ\u001e\u0010D\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006G"}, d2={"Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex;", "Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;", "root", "Ljava/nio/file/Path;", "limit", "", "(Ljava/nio/file/Path;Ljava/lang/Integer;)V", "fileManager", "Lcom/intellij/platform/ml/embeddings/search/indices/LocalEmbeddingIndexFileManager;", "idToEntry", "", "", "Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex$IndexEntry;", "indexToId", "value", "getLimit", "()Ljava/lang/Integer;", "setLimit", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getRoot", "()Ljava/nio/file/Path;", "size", "getSize", "()I", "add", "", "id", "embedding", "Lai/grazie/emb/FloatTextEmbedding;", "addEntries", "values", "", "Lkotlin/Pair;", "addEntry", "checkAllIdsPresent", "", "ids", "", "checkCanAddEntry", "contains", "delete", "all", "deleteEntry", "estimateLimitByMemory", "memory", "", "estimateMemoryUsage", "filterIdsTo", "idToCount", "", "findClosest", "", "Lcom/intellij/platform/ml/embeddings/search/utils/ScoredText;", "searchEmbedding", "topK", "similarityThreshold", "", "(Lai/grazie/emb/FloatTextEmbedding;ILjava/lang/Double;)Ljava/util/List;", "loadFromDisk", "save", "saveIds", "saveToDisk", "streamFindClose", "Lkotlin/sequences/Sequence;", "(Lai/grazie/emb/FloatTextEmbedding;Ljava/lang/Double;)Lkotlin/sequences/Sequence;", "updateEntry", "newId", "IndexEntry", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nDiskSynchronizedEmbeddingSearchIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskSynchronizedEmbeddingSearchIndex.kt\ncom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,177:1\n1#2:178\n372#3,7:179\n453#3:204\n403#3:205\n478#3,7:210\n372#3,7:235\n1179#4,2:186\n1253#4,4:188\n1179#4,2:192\n1253#4,4:194\n1271#4,2:198\n1285#4,4:200\n1238#4,4:206\n1726#4,3:223\n1045#4:226\n1549#4:227\n1620#4,3:228\n1549#4:231\n1620#4,3:232\n1045#4:242\n1549#4:243\n1620#4,3:244\n215#5,2:217\n125#5:219\n152#5,3:220\n*S KotlinDebug\n*F\n+ 1 DiskSynchronizedEmbeddingSearchIndex.kt\ncom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex\n*L\n49#1:179,7\n74#1:204\n74#1:205\n84#1:210,7\n141#1:235,7\n63#1:186,2\n63#1:188,4\n66#1:192,2\n66#1:194,4\n68#1:198,2\n68#1:200,4\n74#1:206,4\n93#1:223,3\n107#1:226\n107#1:227\n107#1:228,3\n108#1:231\n108#1:232,3\n175#1:242\n175#1:243\n175#1:244,3\n85#1:217,2\n88#1:219\n88#1:220,3\n*E\n"})
public final class DiskSynchronizedEmbeddingSearchIndex
implements EmbeddingSearchIndex {
    @NotNull
    private final Path root;
    @NotNull
    private Map<Integer, String> indexToId;
    @NotNull
    private Map<String, IndexEntry> idToEntry;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final LocalEmbeddingIndexFileManager fileManager;
    @Nullable
    private Integer limit;

    public DiskSynchronizedEmbeddingSearchIndex(@NotNull Path root, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        Map map = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSmallMemoryFootprintMap(...)");
        this.indexToId = map;
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        this.idToEntry = map2;
        this.lock = new ReentrantReadWriteLock();
        this.fileManager = new LocalEmbeddingIndexFileManager(this.root, 0, 2, null);
        this.limit = limit;
    }

    public /* synthetic */ DiskSynchronizedEmbeddingSearchIndex(Path path, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(path, n);
    }

    @NotNull
    public final Path getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLimit(@Nullable Integer value) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (value != null) {
                while (this.idToEntry.size() > value) {
                    String string = this.indexToId.get(this.idToEntry.size() - 1);
                    Intrinsics.checkNotNull((Object)string);
                    this.delete(string, true);
                }
            }
            this.limit = value;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.idToEntry.size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@NotNull String id) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = this.idToEntry.containsKey(id);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntries(@NotNull Iterable<Pair<String, FloatTextEmbedding>> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            for (Pair<String, FloatTextEmbedding> pair : values) {
                IndexEntry indexEntry;
                String id = (String)pair.component1();
                FloatTextEmbedding embedding = (FloatTextEmbedding)pair.component2();
                Map<String, IndexEntry> $this$getOrPut$iv = this.idToEntry;
                boolean $i$f$getOrPut = false;
                IndexEntry value$iv = $this$getOrPut$iv.get(id);
                if (value$iv == null) {
                    boolean bl2 = false;
                    if (this.getLimit() != null) {
                        int n2 = this.idToEntry.size();
                        Integer n3 = this.getLimit();
                        Intrinsics.checkNotNull((Object)n3);
                        if (n2 >= n3) break;
                    }
                    int index = this.idToEntry.size();
                    Integer n4 = index;
                    this.indexToId.put(n4, id);
                    IndexEntry answer$iv = new IndexEntry(index, 0, embedding);
                    $this$getOrPut$iv.put(id, answer$iv);
                    indexEntry = answer$iv;
                } else {
                    indexEntry = value$iv;
                }
                IndexEntry entry2 = indexEntry;
                entry2.setCount(entry2.getCount() + 1);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToDisk() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            this.save();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void loadFromDisk() {
        void $this$associateTo$iv$iv;
        Pair<List<String>, List<FloatTextEmbedding>> pair = this.fileManager.loadIndex();
        if (pair == null) {
            return;
        }
        Pair<List<String>, List<FloatTextEmbedding>> pair2 = pair;
        List ids = (List)pair2.component1();
        List embeddings = (List)pair2.component2();
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)ids);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            it = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
            map.put(it.getFirst(), it.getSecond());
        }
        Map idToIndex = destination$iv$iv;
        Map idToEmbedding = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)ids, (Iterable)embeddings));
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            void $this$associateWith$iv;
            void $this$associateTo$iv$iv2;
            Iterable $this$associate$iv2;
            boolean bl = false;
            Iterable iterable2 = CollectionsKt.withIndex((Iterable)ids);
            DiskSynchronizedEmbeddingSearchIndex diskSynchronizedEmbeddingSearchIndex = this;
            boolean $i$f$associate2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
            void bl2 = $this$associate$iv2;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateTo2 = false;
            for (Object element$iv$iv2 : $this$associateTo$iv$iv2) {
                Map map = destination$iv$iv2;
                IndexedValue it = (IndexedValue)element$iv$iv2;
                boolean bl3 = false;
                Pair pair3 = TuplesKt.to((Object)it.getIndex(), (Object)it.getValue());
                map.put(pair3.getFirst(), pair3.getSecond());
            }
            Map map = CollectionFactory.createSmallMemoryFootprintMap((Map)destination$iv$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSmallMemoryFootprintMap(...)");
            diskSynchronizedEmbeddingSearchIndex.indexToId = map;
            $this$associate$iv2 = ids;
            diskSynchronizedEmbeddingSearchIndex = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                Object element$iv$iv2;
                element$iv$iv2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl4 = false;
                Object v = idToIndex.get(it);
                Intrinsics.checkNotNull(v);
                int n2 = ((Number)v).intValue();
                Object v2 = idToEmbedding.get(it);
                Intrinsics.checkNotNull(v2);
                IndexEntry indexEntry = new IndexEntry(n2, 0, (FloatTextEmbedding)v2);
                map2.put(t, indexEntry);
            }
            Map map3 = CollectionFactory.createSmallMemoryFootprintMap((Map)result$iv);
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createSmallMemoryFootprintMap(...)");
            diskSynchronizedEmbeddingSearchIndex.idToEntry = map3;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ScoredText> findClosest(@NotNull FloatTextEmbedding searchEmbedding, int topK, @Nullable Double similarityThreshold) {
        Intrinsics.checkNotNullParameter((Object)searchEmbedding, (String)"searchEmbedding");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void $this$mapValuesTo$iv$iv;
            boolean bl = false;
            Map<String, IndexEntry> $this$mapValues$iv = this.idToEntry;
            boolean $i$f$mapValues = false;
            Map<String, IndexEntry> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k2 = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl3 = false;
                FloatTextEmbedding floatTextEmbedding = ((IndexEntry)it.getValue()).getEmbedding();
                map3.put(k2, floatTextEmbedding);
            }
            List<ScoredText> list = EmbeddingSearchIndexKt.findClosest(destination$iv$iv, searchEmbedding, topK, similarityThreshold);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Sequence<ScoredText> streamFindClose(@NotNull FloatTextEmbedding searchEmbedding, @Nullable Double similarityThreshold) {
        Intrinsics.checkNotNullParameter((Object)searchEmbedding, (String)"searchEmbedding");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Sequence<ScoredText> sequence2 = EmbeddingSearchIndexKt.streamFindClose((Sequence<Pair<String, FloatTextEmbedding>>)SequencesKt.map((Sequence)MapsKt.asSequence(this.idToEntry), (Function1)streamFindClose.1.1.INSTANCE), searchEmbedding, similarityThreshold);
            return sequence2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void filterIdsTo(@NotNull Map<String, Integer> idToCount) {
        int oldSize;
        Intrinsics.checkNotNullParameter(idToCount, (String)"idToCount");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry<String, IndexEntry> element$iv;
            void $this$filterKeys$iv;
            boolean bl = false;
            oldSize = this.idToEntry.size();
            Set<String> uniqueIds = idToCount.keySet();
            Map<String, IndexEntry> map = this.idToEntry;
            DiskSynchronizedEmbeddingSearchIndex diskSynchronizedEmbeddingSearchIndex = this;
            boolean $i$f$filterKeys22 = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl2 = false;
                if (!uniqueIds.contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map map2 = CollectionFactory.createSmallMemoryFootprintMap((Map)result$iv);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
            diskSynchronizedEmbeddingSearchIndex.idToEntry = map2;
            Map<String, IndexEntry> $this$forEach$iv = this.idToEntry;
            boolean $i$f$forEach22 = false;
            Iterator<Map.Entry<String, IndexEntry>> $i$f$filterKeys22 = $this$forEach$iv.entrySet().iterator();
            while ($i$f$filterKeys22.hasNext()) {
                Map.Entry<String, IndexEntry> it = element$iv = $i$f$filterKeys22.next();
                boolean bl3 = false;
                Integer n2 = idToCount.get(it.getKey());
                Intrinsics.checkNotNull((Object)n2);
                it.getValue().setCount(((Number)n2).intValue());
            }
            if (this.idToEntry.size() == oldSize) {
                return;
            }
            Map<String, IndexEntry> $i$f$forEach22 = this.idToEntry;
            diskSynchronizedEmbeddingSearchIndex = this;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(TuplesKt.to((Object)((IndexEntry)it.getValue()).getIndex(), it.getKey()));
            }
            Map map3 = CollectionFactory.createSmallMemoryFootprintMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createSmallMemoryFootprintMap(...)");
            diskSynchronizedEmbeddingSearchIndex.indexToId = map3;
            this.save();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (oldSize = 0; oldSize < n; ++oldSize) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAllIdsPresent(@NotNull Set<String> ids) {
        boolean bl;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2;
            block6: {
                boolean bl3 = false;
                Iterable $this$all$iv = ids;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (this.contains(it)) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            bl = bl2 || !this.checkCanAddEntry();
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @Override
    public long estimateMemoryUsage() {
        return (long)this.fileManager.getEmbeddingSizeInBytes() * (long)this.getSize();
    }

    @Override
    public int estimateLimitByMemory(long memory) {
        return (int)(memory / (long)this.fileManager.getEmbeddingSizeInBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean checkCanAddEntry() {
        var1_1 = this.lock.readLock();
        var1_1.lock();
        try {
            $i$a$-read-DiskSynchronizedEmbeddingSearchIndex$checkCanAddEntry$1 = false;
            if (this.getLimit() == null) ** GOTO lbl-1000
            v0 = this.idToEntry.size();
            v1 = this.getLimit();
            Intrinsics.checkNotNull((Object)v1);
            if (v0 < v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            var3_4 = v2;
            return var3_4;
        }
        finally {
            var1_1.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void save() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$sortedBy$iv = MapsKt.toList(this.idToEntry);
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((IndexEntry)it.getSecond()).getIndex());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IndexEntry)it.getSecond()).getIndex()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        List ids = (List)destination$iv$iv;
        Iterable $this$map$iv2 = ids;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            IndexEntry indexEntry = this.idToEntry.get(it);
            Intrinsics.checkNotNull((Object)indexEntry);
            collection.add(indexEntry.getEmbedding());
        }
        List embeddings = (List)destination$iv$iv2;
        this.fileManager.saveIndex(ids, embeddings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteEntry(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            DiskSynchronizedEmbeddingSearchIndex.delete$default(this, id, false, 2, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEntry(@NotNull String id, @NotNull FloatTextEmbedding embedding) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)embedding, (String)"embedding");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.add(id, embedding);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateEntry(@NotNull String id, @NotNull String newId, @NotNull FloatTextEmbedding embedding) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newId, (String)"newId");
        Intrinsics.checkNotNullParameter((Object)embedding, (String)"embedding");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (!this.idToEntry.containsKey(id)) {
                return;
            }
            IndexEntry indexEntry = this.idToEntry.get(id);
            Intrinsics.checkNotNull((Object)indexEntry);
            if (indexEntry.getCount() == 1 && !this.contains(newId)) {
                IndexEntry indexEntry2 = this.idToEntry.get(id);
                Intrinsics.checkNotNull((Object)indexEntry2);
                int index = indexEntry2.getIndex();
                this.fileManager.set(index, embedding);
                this.idToEntry.remove(id);
                this.idToEntry.put(newId, new IndexEntry(index, 1, embedding));
                Integer n2 = index;
                this.indexToId.put(n2, newId);
                this.saveIds();
            } else {
                DiskSynchronizedEmbeddingSearchIndex.delete$default(this, id, false, 2, null);
                this.add(newId, embedding);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void add(String id, FloatTextEmbedding embedding) {
        IndexEntry indexEntry;
        Map<String, IndexEntry> $this$getOrPut$iv = this.idToEntry;
        boolean $i$f$getOrPut = false;
        IndexEntry value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            if (this.getLimit() != null) {
                int n = this.idToEntry.size();
                Integer n2 = this.getLimit();
                Intrinsics.checkNotNull((Object)n2);
                if (n >= n2) {
                    return;
                }
            }
            int index = this.idToEntry.size();
            this.fileManager.set(index, embedding);
            Integer n = index;
            this.indexToId.put(n, id);
            IndexEntry answer$iv = new IndexEntry(index, 0, embedding);
            $this$getOrPut$iv.put(id, answer$iv);
            indexEntry = answer$iv;
        } else {
            indexEntry = value$iv;
        }
        IndexEntry entry2 = indexEntry;
        entry2.setCount(entry2.getCount() + 1);
        if (entry2.getCount() == 1) {
            this.saveIds();
        }
    }

    private final void delete(String id, boolean all) {
        IndexEntry indexEntry = this.idToEntry.get(id);
        if (indexEntry == null) {
            return;
        }
        IndexEntry entry2 = indexEntry;
        entry2.setCount(entry2.getCount() - 1);
        if (!all && entry2.getCount() > 0) {
            return;
        }
        int lastIndex = this.idToEntry.size() - 1;
        int index = entry2.getIndex();
        String string = this.indexToId.get(lastIndex);
        Intrinsics.checkNotNull((Object)string);
        String movedId = string;
        this.fileManager.removeAtIndex(index);
        Integer n = index;
        this.indexToId.put(n, movedId);
        this.indexToId.remove(lastIndex);
        IndexEntry indexEntry2 = this.idToEntry.get(movedId);
        Intrinsics.checkNotNull((Object)indexEntry2);
        indexEntry2.setIndex(index);
        this.idToEntry.remove(id);
        this.saveIds();
    }

    static /* synthetic */ void delete$default(DiskSynchronizedEmbeddingSearchIndex diskSynchronizedEmbeddingSearchIndex, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diskSynchronizedEmbeddingSearchIndex.delete(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveIds() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv = MapsKt.toList(this.idToEntry);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((IndexEntry)it.getSecond()).getIndex());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IndexEntry)it.getSecond()).getIndex()));
            }
        });
        LocalEmbeddingIndexFileManager localEmbeddingIndexFileManager = this.fileManager;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        localEmbeddingIndexFileManager.saveIds((List)destination$iv$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex$IndexEntry;", "", "index", "", "count", "embedding", "Lai/grazie/emb/FloatTextEmbedding;", "(IILai/grazie/emb/FloatTextEmbedding;)V", "getCount", "()I", "setCount", "(I)V", "getEmbedding", "()Lai/grazie/emb/FloatTextEmbedding;", "getIndex", "setIndex", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ml.embeddings"})
    public static final class IndexEntry {
        private int index;
        private int count;
        @NotNull
        private final FloatTextEmbedding embedding;

        public IndexEntry(int index, int count, @NotNull FloatTextEmbedding embedding) {
            Intrinsics.checkNotNullParameter((Object)embedding, (String)"embedding");
            this.index = index;
            this.count = count;
            this.embedding = embedding;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @NotNull
        public final FloatTextEmbedding getEmbedding() {
            return this.embedding;
        }

        public final int component1() {
            return this.index;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final FloatTextEmbedding component3() {
            return this.embedding;
        }

        @NotNull
        public final IndexEntry copy(int index, int count, @NotNull FloatTextEmbedding embedding) {
            Intrinsics.checkNotNullParameter((Object)embedding, (String)"embedding");
            return new IndexEntry(index, count, embedding);
        }

        public static /* synthetic */ IndexEntry copy$default(IndexEntry indexEntry, int n, int n2, FloatTextEmbedding floatTextEmbedding, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = indexEntry.index;
            }
            if ((n3 & 2) != 0) {
                n2 = indexEntry.count;
            }
            if ((n3 & 4) != 0) {
                floatTextEmbedding = indexEntry.embedding;
            }
            return indexEntry.copy(n, n2, floatTextEmbedding);
        }

        @NotNull
        public String toString() {
            return "IndexEntry(index=" + this.index + ", count=" + this.count + ", embedding=" + this.embedding + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.index);
            result2 = result2 * 31 + Integer.hashCode(this.count);
            result2 = result2 * 31 + this.embedding.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexEntry)) {
                return false;
            }
            IndexEntry indexEntry = (IndexEntry)other;
            if (this.index != indexEntry.index) {
                return false;
            }
            if (this.count != indexEntry.count) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.embedding, (Object)indexEntry.embedding);
        }
    }
}

